---
generated_at: 2026-01-20 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Console.Break

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/Console.cls` 72行目 - SetConsoleCtrlHandler API宣言
- E-02: `Source/CorLib/System/Console.cls` 163-169行目 - ConsoleBreakType列挙型
- E-03: `Source/CorLib/System/Console.cls` 245-247行目 - Break Getプロパティ
- E-04: `Source/CorLib/System/Console.cls` 256-258行目 - Break Letプロパティ
- E-05: `Source/CorLib/System/Console.cls` 1313-1328行目 - Init Sub
- E-06: `Source/CorLib/System/Console.cls` 1321行目 - SetConsoleCtrlHandler呼び出し
- E-07: `Source/CorLib/System/ConsoleCallbacks.bas` 32-33行目 - mBreak, mBreakType変数
- E-08: `Source/CorLib/System/ConsoleCallbacks.bas` 36-38行目 - Break Getプロパティ
- E-09: `Source/CorLib/System/ConsoleCallbacks.bas` 40-42行目 - Break Letプロパティ
- E-10: `Source/CorLib/System/ConsoleCallbacks.bas` 44-46行目 - BreakType Getプロパティ
- E-11: `Source/CorLib/System/ConsoleCallbacks.bas` 52-56行目 - ControlBreakHandler関数
- E-12: `Source/CorLib/System/ConsoleCallbacks.bas` 53行目 - mBreak = True
- E-13: `Source/CorLib/System/ConsoleCallbacks.bas` 54行目 - mBreakType = dwCtrlType
- E-14: `Source/CorLib/System/ConsoleCallbacks.bas` 55行目 - 戻り値True
- E-15: `Source/CorLib/System/ConsoleCallbacks.bas` 27-31行目 - モジュールコメント
- E-16: `Source/CorLib/System/Console.cls` 239-244行目 - Breakプロパティコメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SetConsoleCtrlHandlerでコールバック登録 | E-01, E-06 | ○ |
| C-02 | ConsoleBreakTypeはControlC=0,ControlBreak=1等の列挙型 | E-02 | ○ |
| C-03 | Console.BreakはBooleanプロパティ | E-03, E-04 | ○ |
| C-04 | Console.BreakはGet/Let両方サポート | E-03, E-04 | ○ |
| C-05 | Breakプロパティ参照はConsoleCallbacks.Break経由 | E-03 | ○ |
| C-06 | mBreakはConsoleCallbacksモジュールに配置 | E-07 | ○ |
| C-07 | スレッドセーフではないためCOM使用回避 | E-15 | ○ |
| C-08 | ControlBreakHandlerでmBreak=True設定 | E-11, E-12 | ○ |
| C-09 | ControlBreakHandlerでmBreakType=dwCtrlType設定 | E-11, E-13 | ○ |
| C-10 | ControlBreakHandlerはTrueを返却 | E-14 | ○ |
| C-11 | Init SubでSetConsoleCtrlHandler呼び出し | E-05, E-06 | ○ |
| C-12 | DoEventsなしでもBreak更新 | E-16 | ○ |
| C-13 | BreakをFalseにリセット可能 | E-04, E-09 | ○ |
| C-14 | BreakType取得可能 | E-10 | ○ |
| C-15 | CloseWindow=2の値 | E-02 | ○ |
| C-16 | LogOffUser=5, ShutDownSystem=6 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-06のSetConsoleCtrlHandler呼び出しが設計書と一致するか確認
- [ ] E-11のControlBreakHandler処理が設計書と一致するか確認
- [ ] E-02のConsoleBreakType列挙値が設計書と一致するか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
