---
generated_at: 2026-01-20 11:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-Console.BreakType

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/Console.cls` 163-169行目 - ConsoleBreakType列挙型
- E-02: `Source/CorLib/System/Console.cls` 164行目 - ControlC = 0
- E-03: `Source/CorLib/System/Console.cls` 165行目 - ControlBreak = 1
- E-04: `Source/CorLib/System/Console.cls` 166行目 - CloseWindow = 2
- E-05: `Source/CorLib/System/Console.cls` 167行目 - LogOffUser = 5
- E-06: `Source/CorLib/System/Console.cls` 168行目 - ShutDownSystem = 6
- E-07: `Source/CorLib/System/Console.cls` 231-233行目 - BreakType Getプロパティ
- E-08: `Source/CorLib/System/ConsoleCallbacks.bas` 33行目 - mBreakType変数
- E-09: `Source/CorLib/System/ConsoleCallbacks.bas` 44-46行目 - BreakType Getプロパティ
- E-10: `Source/CorLib/System/ConsoleCallbacks.bas` 54行目 - mBreakType = dwCtrlType
- E-11: `Source/CorLib/System/Console.cls` 154-162行目 - ConsoleBreakTypeコメント
- E-12: `Source/CorLib/System/Console.cls` 232行目 - ConsoleCallbacks.BreakType参照

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BreakTypeはConsoleBreakType型を返す | E-07 | ○ |
| C-02 | ControlC = 0 | E-02 | ○ |
| C-03 | ControlBreak = 1 | E-03 | ○ |
| C-04 | CloseWindow = 2 | E-04 | ○ |
| C-05 | LogOffUser = 5 | E-05 | ○ |
| C-06 | ShutDownSystem = 6 | E-06 | ○ |
| C-07 | BreakTypeはGetのみ（読み取り専用） | E-07, E-09 | ○ |
| C-08 | mBreakTypeはConsoleCallbacksモジュールに配置 | E-08 | ○ |
| C-09 | ControlBreakHandlerでmBreakType設定 | E-10 | ○ |
| C-10 | Console.BreakTypeはConsoleCallbacks.BreakType経由 | E-12 | ○ |
| C-11 | ConsoleBreakType列挙型のコメント説明あり | E-11 | ○ |
| C-12 | 列挙値3,4は未定義 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のConsoleBreakType列挙型が設計書と一致するか確認
- [ ] E-07のBreakTypeプロパティが読み取り専用であることを確認
- [ ] E-10のmBreakType設定処理が設計書と一致するか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
