---
generated_at: 2026-01-20 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **サポート連絡方法の最新性**：外部URLの有効性未確認
  2. **OCXファイルの入手方法**：具体的な入手手順が不明
  3. **Git設定の必要性**：環境依存の可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要、ディレクトリ構成、セットアップ手順
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 15画面の一覧情報
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 110機能の一覧情報
- E-04: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 85件の業務要件
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応関係
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面構成と操作フロー
- E-07: `docs/code-to-docs/画面設計書/1-Simply VB Unit Runner.md` - テストランナー画面設計
- E-08: `docs/code-to-docs/画面設計書/7-File Encryption.md` - ファイル暗号化画面設計
- E-09: `docs/code-to-docs/画面設計書/4-Base64 Encoding.md` - Base64エンコード画面設計
- E-10: `docs/code-to-docs/画面設計書/8-Hash Codes.md` - ハッシュ計算画面設計
- E-11: `docs/code-to-docs/画面設計書/9-Simple Registry Browser.md` - レジストリブラウザ画面設計

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Frameworkの機能をVB6で実装したライブラリ | E-01 | ○ |
| C-02 | VBCorLib3.dllとして出力される | E-01 | ○ |
| C-03 | Windows OS、VB6開発環境が必要 | E-01 | ○ |
| C-04 | 15種類の画面（サンプルアプリケーション）が存在 | E-02 | ○ |
| C-05 | 110種類の機能が提供されている | E-03 | ○ |
| C-06 | 85件の業務要件が定義されている | E-04 | ○ |
| C-07 | Simply VB Unit Runnerでテスト実行が可能 | E-07 | ○ |
| C-08 | F5キーでテスト実行、ESCキーで終了 | E-07 | ○ |
| C-09 | テストカテゴリにSystem、Collections、Cryptography等が含まれる | E-07 | ○ |
| C-10 | SimplyVBUnit.Component.ocxが必要 | E-07 | ○ |
| C-11 | File Encryptionで4種類の暗号化アルゴリズムに対応 | E-08 | ○ |
| C-12 | DES、TripleDES、RC2、Rijndaelが選択可能 | E-08 | ○ |
| C-13 | Rfc2898DeriveBytesでパスワードから鍵を導出 | E-08 | ○ |
| C-14 | Hash Codesで6種類のハッシュアルゴリズムに対応 | E-10 | ○ |
| C-15 | SHA-1、SHA-256、SHA-384、SHA-512、MD5、RIPEMD-160を計算可能 | E-10 | ○ |
| C-16 | テキスト変更ごとに自動的にハッシュ値を計算 | E-10 | ○ |
| C-17 | Base64 EncodingでFile.ReadAllBytes、Convert.ToBase64Stringを使用 | E-09 | ○ |
| C-18 | 処理時間をStopWatchクラスで計測 | E-09 | ○ |
| C-19 | 出力先にファイルが存在する場合、上書き確認が表示される | E-09 | ○ |
| C-20 | Simple Registry BrowserでTreeView/ListViewを使用 | E-11 | ○ |
| C-21 | レジストリの4つのルートキーにアクセス可能 | E-11 | ○ |
| C-22 | 読み取り専用で書き込み機能は未実装 | E-11 | ○ |
| C-23 | 値の種別（REG_SZ、REG_DWORD等）が表示される | E-11 | ○ |
| C-24 | MSCOMCTL.OCXが必要 | E-02, E-11 | ○ |
| C-25 | COMDLG32.OCXが必要 | E-02, E-08 | ○ |
| C-26 | 各サンプルは独立したVBプロジェクトとして構成 | E-06 | ○ |
| C-27 | 画面間での直接的な遷移は存在しない | E-06 | ○ |
| C-28 | Source/Tests/VBCorLibTests.vbpがテストプロジェクト | E-01, E-07 | ○ |
| C-29 | Source/CorLib/CorLib.vbpがメインプロジェクト | E-01 | ○ |
| C-30 | regsvr32でDLLを登録 | E-01 | ○ |
| C-31 | git config --global core.autocrlf falseが必要 | E-01 | ○ |
| C-32 | UTF-8、UTF-7、UTF-16、UTF-32、ASCIIエンコーディングに対応 | E-03, E-04 | ○ |
| C-33 | コレクション（ArrayList、Hashtable等）機能を提供 | E-03 | ○ |
| C-34 | 暗号化（対称・非対称）機能を提供 | E-03, E-04 | ○ |
| C-35 | ファイル/IO操作機能を提供 | E-03 | ○ |
| C-36 | 日付/時刻操作機能を提供 | E-03 | ○ |
| C-37 | グローバリゼーション機能を提供 | E-03 | ○ |
| C-38 | BigInteger（任意精度整数）を提供 | E-03 | ○ |
| C-39 | MemoryMappedFileで2GB超のファイルに対応 | E-01, E-03 | ○ |
| C-40 | INIファイル操作機能を提供 | E-03 | ○ |
| C-41 | MIT Licenseで提供 | E-01 | ○ |
| C-42 | Kelly Ethridgeが著作権者 | E-01 | ○ |
| C-43 | オンラインドキュメントのURL | **外部URL未確認** | △ |
| C-44 | SimplyVBUnitのインストール方法 | **根拠なし** | △ |
| C-45 | RICHTX32.OCXの必要性 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **外部URLの有効性未確認**
  - オンラインドキュメントURL（http://www.kellyethridge.com/vbcorlib/doc/CorLib.html）の現在の有効性
  - 候補：実際にURLにアクセスして確認 / READMEの記載を信頼
- **SimplyVBUnitのインストール方法**
  - テストランナーで使用するSimplyVBUnit.Component.ocxの入手方法・インストール手順
  - 候補：外部サイトからダウンロード / 開発者に確認
- **OCXファイルの入手方法**
  - MSCOMCTL.OCX、COMDLG32.OCX、RICHTX32.OCXの具体的な入手方法
  - 候補：Windows SDKに同梱 / Visual Studioに同梱 / Microsoft提供

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、機能一覧、画面構成
  - README.md、画面一覧.csv、機能一覧.csvから直接抽出
- **0: 低リスク** - 操作手順（テスト実行、暗号化、Base64変換等）
  - 画面設計書から直接抽出、コード参照あり
- **1: 中リスク** - 環境構築手順
  - README.mdに記載あるが、実際の環境での検証は未実施
- **2: 高リスク** - 外部URLの有効性
  - ドキュメント内の外部リンクが現在も有効かどうか未確認

## 6) レビュアーチェックリスト（最小）
- [ ] システム概要がREADME.mdの記載と一致しているか
- [ ] 画面一覧が画面一覧.csvの内容を網羅しているか
- [ ] 操作手順が画面設計書の記載と整合しているか
- [ ] 暗号化アルゴリズムの説明が技術的に正確か
- [ ] ハッシュアルゴリズムの出力長が正しいか
- [ ] 環境構築手順が実際に動作するか（要実機検証）
- [ ] 外部URLが有効かどうか確認
- [ ] OCXファイルの入手方法を補完する必要があるか判断
