# VBCorLib 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [環境構築手順](#2-環境構築手順)
3. [テストランナー（TOP画面）](#3-テストランナーtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】ユニットテスト実行（品質検証）](#4-step1ユニットテスト実行品質検証)
5. [【STEP2-3】暗号化サンプル（セキュリティ機能）](#5-step2-3暗号化サンプルセキュリティ機能)
6. [【STEP3-4】ファイル操作サンプル（IO機能）](#6-step3-4ファイル操作サンプルio機能)
7. [【STEP4-5】システム情報閲覧（管理機能）](#7-step4-5システム情報閲覧管理機能)

**【サポート機能】**
8. [数値フォーマット機能](#8-数値フォーマット機能)
9. [タイマー・コールバック機能](#9-タイマーコールバック機能)
10. [エンコーディング機能](#10-エンコーディング機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 VBCorLibとは

VBCorLibは、.NET Frameworkの多くのクラスをVisual Basic 6（VB6）で実装したライブラリです。VBCorLib内のクラスは.NETの対応クラスとほぼ同じように使用できるため、.NETアプリケーションとVB6間でのデータ共有が容易になります。

本ライブラリは開発者向けのツールであり、VB6/VBAアプリケーションに.NET相当の機能を追加するために使用されます。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **品質保証** | ユニットテストの実行、テスト結果の確認、回帰テストの実施 |
| **暗号化処理** | ファイルの暗号化/復号化、ハッシュ値の計算、Base64エンコード/デコード |
| **データ管理** | ファイル操作、レジストリ閲覧、INIファイル解析、リソース管理 |
| **開発支援** | 数値フォーマット確認、タイマー機能確認、エンコーディング確認 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
+---------------------------------------------------------------------+
|                        業務フロー                                    |
+---------------------------------------------------------------------+
|                                                                     |
|  【STEP 1】開発者がユニットテストを実行し、ライブラリの品質を検証   |
|      |                                                              |
|  【STEP 2】暗号化機能を使用してファイルのセキュリティを確保         |
|      |                                                              |
|  【STEP 3】ファイル操作機能を使用してデータを管理                   |
|      |                                                              |
|  【STEP 4】システム情報（レジストリ等）を閲覧・確認                 |
|      |                                                              |
|  【STEP 5】サンプルアプリケーションで各機能の動作を確認             |
|                                                                     |
+---------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **開発者** | ユニットテスト実行、サンプルアプリケーションの確認、ライブラリ機能のテスト |
| **テスター** | 回帰テスト実行、暗号化機能の検証、ファイル操作のテスト |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| ユニットテスト実行 | VBCorLibの全機能をテスト実行 | STEP 1 |
| ファイル暗号化/復号 | DES、TripleDES、RC2、Rijndaelによる暗号化 | STEP 2 |
| ハッシュ計算 | SHA-1、SHA-256、SHA-384、SHA-512、MD5、RIPEMD-160 | STEP 2 |
| Base64変換 | ファイルのBase64エンコード/デコード | STEP 2-3 |
| レジストリ閲覧 | Windowsレジストリの読み取り表示 | STEP 4 |
| ファイルブラウザ | ファイルシステムの閲覧 | STEP 3 |
| INIファイル閲覧 | INIファイルの解析・表示 | STEP 3 |
| リソース閲覧 | RES/EXE/DLLのリソース表示 | STEP 3 |
| 数値フォーマット | 各種数値書式のデモ | STEP 5 |
| タイマー機能 | Ticker機能のデモ | STEP 5 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| VB6開発者 | VBCorLibを使用してアプリケーションを開発する開発者 |
| VBA開発者 | Excel/Access等でVBCorLibを使用する開発者 |
| テスター | ライブラリの品質検証を行うテスト担当者 |

### 1.6 対応環境

**必要条件：**
- Windows OS
- Visual Basic 6（VB6）開発環境
- VB6 IDE（ソースコードの編集・コンパイル用）

**推奨環境：**
- Windows 10/11
- Visual Basic 6.0 SP6
- SimplyVBUnit.Component.ocx（テスト実行用）
- MSCOMCTL.OCX（コモンコントロール）
- COMDLG32.OCX（コモンダイアログ）

---

## 2. 環境構築手順

### 2.1 インストール方法

1. リポジトリをクローンまたはダウンロードします
2. 「Source/CorLib/CorLib.vbp」をVB6 IDEで開きます
3. プロジェクトをコンパイルしてDLLを生成します
4. 生成されたDLLをWindowsに登録します

**DLL登録コマンド：**
```
regsvr32 VBCorLib3.dll
```

### 2.2 プロジェクト構成

| プロジェクト | パス | 説明 |
|-------------|------|------|
| メインライブラリ | `Source/CorLib/CorLib.vbp` | VBCorLib本体 |
| ビルド用 | `Source/CorLib/CorLib.Build.vbp` | ビルド用プロジェクト |
| テストプロジェクト | `Source/Tests/CorLib.Tests.vbp` | ユニットテスト |
| フェイクオブジェクト | `Source/Fakes/Fakes.vbp` | テスト用モック |

### 2.3 Git設定（開発者向け）

VB6 IDEが要求するWindows改行コードを正しく扱うため、以下の設定が必要です：

```shell
git config --global core.autocrlf false
```

---

## 3. テストランナー（TOP画面）

### 3.1 Simply VB Unit Runner

Simply VB Unit Runnerは、VBCorLibのユニットテスト実行画面です。

**画面へのアクセス方法：**
1. VB6 IDEで「Source/Tests/VBCorLibTests.vbp」を開きます
2. 「F5」キーを押して実行します
3. テストランナー画面が表示されます

**画面構成：**

| コンポーネント | 説明 |
|---------------|------|
| テストスイート一覧 | カテゴリ別に構造化されたテストケース一覧（TreeView形式） |
| テスト実行結果 | 成功/失敗数、実行時間、エラー詳細 |

### 3.2 テスト実行操作

**キーボード操作：**

| キー | アクション |
|------|----------|
| F5 | テストスイート全体を実行 |
| ESC | 画面を終了 |

---

## 4. 【STEP1】ユニットテスト実行（品質検証）

> **業務フローでの位置**: 開発者がライブラリの品質検証を行うステップです。

### 4.1 テストを実行する

**業務シーン：** ライブラリの機能が正しく動作することを確認したい場合

**前提条件：**
- VB6 IDEがインストールされていること
- SimplyVBUnit.Component.ocxがシステムに登録されていること

**操作手順：**

1. VB6 IDEで「Source/Tests/VBCorLibTests.vbp」を開きます
2. 「F5」キーを押して実行します
3. テストランナー画面が表示されます
4. 「F5」キーを押してテストを実行します
5. テスト結果を確認します
6. 「ESC」キーを押して終了します

**テストカテゴリ：**

| カテゴリ | 内容 |
|---------|------|
| System | 基本型、例外、配列、文字列等のテスト |
| System.Collections | ArrayList、Hashtable、Stack、Queue等のテスト |
| System.Security.Cryptography | 暗号化アルゴリズムのテスト |
| System.IO | ファイルIOのテスト |
| System.Text | エンコーディング、StringBuilderのテスト |
| System.Globalization | カレンダー、カルチャーのテスト |
| System.Numerics | BigIntegerのテスト |
| Microsoft.Win32 | レジストリ関連のテスト |

### 4.2 テスト結果の確認

テスト実行後、以下の情報を確認できます：

- 成功したテストの数
- 失敗したテストの数
- テスト実行時間
- エラーの詳細情報

**注意点・Tips:**
- テストが失敗した場合は、エラー詳細を確認して原因を特定してください
- 環境依存のタイムゾーンテストはスキップされる場合があります

---

## 5. 【STEP2-3】暗号化サンプル（セキュリティ機能）

> **業務フローでの位置**: 開発者がセキュリティ機能の使用方法を学習・検証するステップです。

### 5.1 ファイル暗号化画面（File Encryption）

**業務シーン：** ファイルを暗号化/復号化する機能を確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/Cryptography/FileEncryption/FileEncryption.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順（暗号化）：**

1. 「Algorithms」ドロップダウンから暗号化アルゴリズムを選択します
   - DES、TripleDES、RC2、Rijndael（AES）から選択可能
2. 「Key Size」「Block Size」「Mode」「Padding」を設定します
3. 「Password」にパスワードを入力します
4. 「Browse」ボタンで入力ファイルを選択します
5. 出力ファイル名を指定します
6. 「Encrypt」ボタンをクリックします
7. 暗号化が完了します

**操作手順（復号化）：**

1. 暗号化と同じアルゴリズム・パラメータを設定します
2. 暗号化ファイルを入力ファイルとして選択します
3. 出力ファイル名を指定します
4. 「Decrypt」ボタンをクリックします
5. 復号化が完了します

**設定項目：**

| 項目 | 説明 |
|------|------|
| Algorithms | 暗号化アルゴリズム（DES、TripleDES、RC2、Rijndael） |
| Key Size | 鍵サイズ（bits） |
| Block Size | ブロックサイズ（bits） |
| Mode | 暗号化モード（CBC、ECB等） |
| Padding | パディングモード |

**注意点・Tips:**
- 復号化には暗号化と同じパラメータが必要です
- パスワードはRfc2898DeriveBytes（PBKDF2）で鍵に変換されます

### 5.2 ハッシュ計算画面（Hash Codes）

**業務シーン：** テキストのハッシュ値を計算したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/Cryptography/HashCodes/HashCodes.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順：**

1. 「Source」テキストボックスにハッシュ対象のテキストを入力します
2. テキスト変更ごとに自動的に6種類のハッシュ値が計算されます
3. 各ハッシュ値が16進数文字列で表示されます

**対応ハッシュアルゴリズム：**

| アルゴリズム | ハッシュ長 |
|-------------|----------|
| SHA-1 | 160bit (20bytes) |
| SHA-256 | 256bit (32bytes) |
| SHA-384 | 384bit (48bytes) |
| SHA-512 | 512bit (64bytes) |
| MD5 | 128bit (16bytes) |
| RIPEMD-160 | 160bit (20bytes) |

### 5.3 リアルタイム復号画面（Real-Time Decryption）

**業務シーン：** CryptoStreamを使用したリアルタイム復号を確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/Cryptography/RealTimeDecryption/RealTimeDecryption.vbp」を開きます
2. 「F5」キーを押して実行します

---

## 6. 【STEP3-4】ファイル操作サンプル（IO機能）

> **業務フローでの位置**: 開発者がファイル操作機能を確認・検証するステップです。

### 6.1 Base64エンコード画面

**業務シーン：** ファイルをBase64エンコード/デコードしたい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/Misc/Base64 Encoding/Base64 Encoding.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順（エンコード）：**

1. 「Browse」ボタンで入力ファイルを選択します
2. 「Encode Base64」ボタンをクリックします
3. エンコード結果がテキストボックスに表示されます
4. ファイルサイズ、エンコード後の長さ、処理時間が表示されます

**操作手順（デコード）：**

1. 「Browse」ボタン（New File）で出力先ファイルを指定します
2. 「Decode To New File」ボタンをクリックします
3. Base64文字列がデコードされてファイル出力されます

**注意点・Tips:**
- 出力先にファイルが存在する場合、上書き確認が表示されます
- 処理時間はStopWatchクラスで計測されます

### 6.2 ファイルブラウザ画面（Simple Browser）

**業務シーン：** ファイルシステムを閲覧したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/IO Examples/SimpleBrowser/SimpleBrowser.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順：**

1. TreeViewでドライブを選択します
2. ノードをクリックしてディレクトリを展開します
3. ListViewにファイル一覧が表示されます
4. 列ヘッダをクリックするとソートされます

**関連画面：**
- Simple Browser 2（Callback版）: コールバック関数を使用したソート

### 6.3 INIファイルブラウザ画面

**業務シーン：** INIファイルの内容を確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/IO Examples/SimpleINIFileBrowser/SimpleINIFileBrowser.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順：**

1. ファイルダイアログでINIファイルを選択します
2. TreeViewにセクション一覧が表示されます
3. セクションをクリックするとキー/値ペアが表示されます

### 6.4 Hex Viewer画面

**業務シーン：** ファイルの16進数ダンプを確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/IO Examples/FileHexViewer/FileHexViewer.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順：**

1. ファイルダイアログでファイルを選択します
2. 16進数ダンプが表示されます
3. スクロールして内容を確認します

**注意点・Tips:**
- MemoryMappedFileを使用して大容量ファイルを仮想的に表示します
- 2GB超のファイルにも対応しています

### 6.5 リソースブラウザ画面

**業務シーン：** RESファイルやEXE/DLLのリソースを確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/IO Examples/ResourceBrowser/ResourceBrowser.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順：**

1. ファイルダイアログでRES/EXE/DLL/OCXファイルを選択します
2. TreeViewにリソース一覧が表示されます
3. リソースを選択すると内容がプレビュー表示されます

---

## 7. 【STEP4-5】システム情報閲覧（管理機能）

> **業務フローでの位置**: 開発者がシステム情報を確認するステップです。

### 7.1 レジストリブラウザ画面

**業務シーン：** Windowsレジストリの内容を確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/Registry/SimpleRegistryBrowser/SimpleRegistryBrowser.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順：**

1. TreeViewでルートキーを選択します
   - HKEY_CLASSES_ROOT
   - HKEY_CURRENT_CONFIG
   - HKEY_CURRENT_USER
   - HKEY_LOCAL_MACHINE
2. ノードをクリックしてサブキーを展開します
3. ListViewに値一覧が表示されます
   - Name: 値の名前
   - Type: 値の種別（REG_SZ、REG_DWORD等）
   - Data: 値のデータ

**注意点・Tips:**
- 読み取り専用で、レジストリへの書き込みは行いません
- アクセス権限のないキーは展開できない場合があります

### 7.2 Static Classes Demo画面

**業務シーン：** VBCorLibの静的クラス機能を確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/Misc/StaticClasses/StaticClasses.vbp」を開きます
2. 「F5」キーを押して実行します

**確認できる機能：**

| 機能 | 説明 |
|------|------|
| Path | パス操作（GetFullPath、GetFileName、GetDirectoryName等） |
| Environment | 環境情報取得（UserName、MachineName、OSVersion等） |
| CorMath | 数学関数（PI、CDeg、CRad、DivRem等） |
| TimeZone | タイムゾーン情報（CurrentTimeZone、IsDayLightSavingTime等） |

---

## 8. 数値フォーマット機能

### 8.1 Number Formatting画面

**業務シーン：** 数値フォーマット機能の動作を確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/NumberFormatting/Format Integer/NumberFormatting.vbp」を開きます
2. 「F5」キーを押して実行します

**対応フォーマット：**

| 書式 | 説明 |
|------|------|
| G | 一般（General） |
| D | 10進数（Decimal） |
| E | 指数（Exponential） |
| F | 固定小数点（Fixed-point） |
| C | 通貨（Currency） |
| N | 数値（Number） |
| X | 16進数（Hexadecimal） |

---

## 9. タイマー・コールバック機能

### 9.1 Simple Ticker（Event版）

**業務シーン：** Tickerオブジェクトのイベント通知機能を確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/Misc/SimpleTicker/SimpleTicker.vbp」を開きます
2. 「F5」キーを押して実行します

**操作手順：**

1. 「Start」ボタンでタイマーを開始します
2. 「Stop」ボタンでタイマーを停止します
3. 「Reset」ボタンでタイマーをリセットします

### 9.2 Simple Ticker 2（Callback版）

**業務シーン：** Tickerオブジェクトのコールバック通知機能を確認したい場合

**画面へのアクセス方法：**
1. VB6 IDEで「Examples/Misc/SimpleTicker2/SimpleTicker2.vbp」を開きます
2. 「F5」キーを押して実行します

**注意点・Tips:**
- イベント版とコールバック版の違いを比較できます

---

## 10. エンコーディング機能

### 10.1 対応エンコーディング

VBCorLibは以下のエンコーディングに対応しています：

| エンコーディング | クラス名 |
|-----------------|---------|
| UTF-8 | UTF8Encoding |
| UTF-7 | UTF7Encoding |
| UTF-16 | UnicodeEncoding |
| UTF-32 | UTF32Encoding |
| ASCII | ASCIIEncoding |
| Windows各種コードページ | SBCSCodePageEncoding、DBCSCodePageEncoding |

### 10.2 使用例

```vb
Dim bytes() As Byte
bytes = Encoding.UTF8.GetBytes("Hello World")

Dim text As String
text = Encoding.UTF8.GetString(bytes)
```

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
----------------------------------------------------------------------
【STEP 1】開発者がユニットテストを実行し品質検証 -> 4章参照
    |
【STEP 2】暗号化機能を使用してセキュリティ確保 -> 5章参照
    |
【STEP 3】ファイル操作機能を使用してデータ管理 -> 6章参照
    |
【STEP 4】システム情報を閲覧・確認 -> 7章参照
    |
【STEP 5】サンプルアプリケーションで各機能の動作確認 -> 8-10章参照
----------------------------------------------------------------------
```

### 11.1 【開発者】STEP1: ユニットテストの実行

開発開始時またはコード変更後に、ユニットテストを実行して品質を検証します。

**操作手順：**
1. VB6 IDEで「Source/Tests/VBCorLibTests.vbp」を開きます
2. 「F5」キーで実行します
3. テストランナー画面で「F5」キーを押してテスト実行します
4. 全テストが成功（緑色）することを確認します
5. 失敗がある場合はエラー詳細を確認して修正します

### 11.2 【開発者】STEP2: 暗号化機能の確認

セキュリティ機能を使用する前に、サンプルアプリケーションで動作を確認します。

**操作手順：**
1. File Encryption画面で暗号化/復号化をテストします
2. Hash Codes画面でハッシュ計算をテストします
3. 期待通りの結果が得られることを確認します

### 11.3 【開発者】STEP3: ファイル操作機能の確認

ファイル操作機能を使用する前に、サンプルアプリケーションで動作を確認します。

**操作手順：**
1. Base64 Encoding画面でエンコード/デコードをテストします
2. Simple Browser画面でファイルシステム閲覧をテストします
3. 期待通りの結果が得られることを確認します

### 11.4 【開発者】STEP4-5: システム情報の確認・各機能テスト

システム情報の取得や各種機能の動作を確認します。

**操作手順：**
1. Simple Registry Browser画面でレジストリ閲覧をテストします
2. Static Classes Demo画面で静的クラス機能を確認します
3. Number Formatting画面で数値フォーマットを確認します

---

## 12. よくある質問と対処法

### 12.1 環境構築に関するQ&A

**Q: DLLの登録に失敗します**

A: 以下を確認してください：
- 管理者権限でコマンドプロンプトを実行しているか
- DLLのパスが正しいか
- 依存するOCXが登録されているか

**Q: SimplyVBUnit.Component.ocxが見つかりません**

A: 以下を確認してください：
- SimplyVBUnitが正しくインストールされているか
- システムにOCXが登録されているか

### 12.2 テストに関するQ&A

**Q: テストが失敗します**

A: 以下を確認してください：
- VBCorLib.dllが正しくコンパイルされているか
- 依存するコンポーネントが全て登録されているか
- 環境固有のテスト（タイムゾーン等）の場合はスキップを検討

**Q: テスト実行中にエラーが発生します**

A: 以下を確認してください：
- メモリが十分にあるか
- VB6 IDEが正しく動作しているか
- テストプロジェクトの参照設定が正しいか

### 12.3 暗号化に関するQ&A

**Q: 復号化に失敗します**

A: 以下を確認してください：
- 暗号化と同じアルゴリズム、パラメータを使用しているか
- 同じパスワードを使用しているか
- ファイルが破損していないか

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| "File does not exist." | 指定したファイルが存在しない | ファイルパスを確認し、正しいファイルを選択する |
| "File already exists, Overwrite?" | 出力先にファイルが存在する | 上書きするか、別のファイル名を指定する |
| 暗号化/復号エラー | パラメータが不正 | アルゴリズム、鍵サイズ、パスワードを確認する |
| アクセス権限エラー | レジストリキーへのアクセス権限がない | 別のキーを選択するか、管理者権限で実行する |

### 13.2 よくあるトラブルと解決方法

**トラブル: VB6 IDEがフリーズする**

解決方法：
1. VB6 IDEを強制終了します
2. 一時ファイルを削除します
3. VB6 IDEを再起動します

**トラブル: コンパイルエラーが発生する**

解決方法：
1. 参照設定を確認します
2. 必要なタイプライブラリが登録されているか確認します
3. コードの構文エラーを修正します

**トラブル: テストが途中で停止する**

解決方法：
1. VB6 IDEを再起動します
2. 問題のあるテストケースを特定します
3. 必要に応じてテストをスキップします

### 13.3 サポートへの連絡方法

**オンラインドキュメント：**
- http://www.kellyethridge.com/vbcorlib/doc/CorLib.html

**オフラインドキュメント：**
- http://www.kellyethridge.com/vbcorlib/doc/CorLib.chm
- `Source/CorLib/CorLib.chm`に同梱

**ライセンス：**
- MIT License
- Copyright (c) 2017 Kelly Ethridge

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-20 | 初版作成 |

---

*本マニュアルは、VBCorLibの開発者向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
