---
generated_at: 2026-01-20 20:40:00
metrics:
  claims_total: 40
  claims_with_evidence: 36
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：36 / 40、根拠なし：4
- 優先レビュー（高）
  1. **NFT-001〜003 性能基準値**：具体的な数値基準の根拠不足（推定値）
  2. **NFT-007〜008 スループット基準**：処理時間の目標値は実測に基づかない推定
  3. **NFT-037 テストクラス数**：216クラスは文書からの引用であり実際の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md` - 非機能要件の定義
- E-02: `docs/code-to-docs/セキュリティ設計書/セキュリティ設計書.md` - セキュリティ要件
- E-03: `docs/code-to-docs/テスト方針書/テスト方針書.md` - テスト方針・フレームワーク
- E-04: `docs/code-to-docs/アーキテクチャ設計書/アーキテクチャ設計書.md` - アーキテクチャ設計
- E-05: `docs/code-to-docs/インフラ設計書/インフラ設計書.md` - インフラ・環境要件
- E-06: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` - Rijndael暗号実装
- E-07: `Source/CorLib/System/CorArray.cls` - 配列操作クラス
- E-08: `Source/CorLib/System.IO/FileStream.cls` - ファイルストリーム実装
- E-09: `Source/Tests/System.Security.Cryptography/*Tests.cls` - 暗号化テストクラス群
- E-10: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArrayList要素追加性能テスト（1秒基準） | E-01, E-07 | △ |
| C-02 | Hashtable検索性能（O(1)相当） | E-01 | ○ |
| C-03 | StringBuilder連結性能（1秒基準） | E-01 | △ |
| C-04 | FileStream 2GB超対応 | E-01, E-08 | ○ |
| C-05 | FileStreamバッファサイズ81920バイト | E-01, E-08 | ○ |
| C-06 | BigInteger任意精度演算 | E-01, E-10 | ○ |
| C-07 | SHA256ハッシュ計算速度（100ms基準） | E-02, E-09 | △ |
| C-08 | Rijndael暗号化速度（1秒基準） | E-02, E-06, E-09 | △ |
| C-09 | ArrayList容量2倍拡張 | E-01 | ○ |
| C-10 | StringBuilder容量2倍拡張 | E-01 | ○ |
| C-11 | Rijndael 128/192/256ビット鍵 | E-02, E-06 | ○ |
| C-12 | TripleDES暗号化 | E-02, E-09 | ○ |
| C-13 | DES弱鍵検出 | E-02, E-09 | ○ |
| C-14 | RSA 384-16384ビット鍵 | E-02 | ○ |
| C-15 | RSA OAEPパディング | E-02 | ○ |
| C-16 | SHA256ハッシュ整合性 | E-02, E-09 | ○ |
| C-17 | SHA512ハッシュ整合性 | E-02, E-09 | ○ |
| C-18 | HMAC-SHA256検証 | E-02, E-09 | ○ |
| C-19 | 暗号鍵Clear()メソッド | E-02, E-06 | ○ |
| C-20 | RNGCryptoServiceProvider乱数品質 | E-02 | ○ |
| C-21 | Rfc2898DeriveBytes PBKDF2 | E-02, E-09 | ○ |
| C-22 | SecurityElement入力検証 | E-02 | ○ |
| C-23 | 配列境界チェック | E-02, E-07 | ○ |
| C-24 | Windows XP対応（v3.2） | E-01 | ○ |
| C-25 | 64ビットOS WOW64対応 | E-01, E-05 | ○ |
| C-26 | VB6統合COM参照 | E-04, E-05 | ○ |
| C-27 | VBA対応 | E-01 | ○ |
| C-28 | .NET互換データ形式 | E-01, E-02, E-04 | ○ |
| C-29 | 32KB超ファイル名対応 | E-01 | ○ |
| C-30 | 例外階層の整合性 | E-04 | ○ |
| C-31 | ArgumentException検証 | E-03, E-04 | ○ |
| C-32 | IOException検証 | E-03, E-04 | ○ |
| C-33 | Class_Terminateリソース解放 | E-01 | ○ |
| C-34 | SafeFileHandleハンドル管理 | E-08 | ○ |
| C-35 | IEnumerable実装 | E-04 | ○ |
| C-36 | IComparer実装 | E-04 | ○ |
| C-37 | ユニットテスト216クラス | E-03 | ○ |
| C-38 | 非同期エラー処理 | E-01 | ○ |
| C-39 | 境界値入力エラー処理 | E-03 | ○ |
| C-40 | DEP対応（v2.3） | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- **性能テストの具体的数値基準**：合格基準の数値（1秒、100ms等）は実測データに基づいていない推定値
  - 候補：実機での性能測定結果 / ベンチマークツール結果 / 類似システムのSLA
- **テストカバレッジの最新状態**：216テストクラスは文書記載値であり、実際のSource/Testsディレクトリの最新状態との整合性確認が必要
  - 候補：テスト実行結果レポート / カバレッジレポート

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 性能テストの合格基準値は推定値のため、実環境での検証後に調整が必要
- **0: 低リスク** - セキュリティテストケースは非機能要件定義書・セキュリティ設計書に明確な根拠あり
- **0: 低リスク** - 互換性テストケースはプロジェクト文書・README等に明記された仕様に基づく
- **0: 低リスク** - 保守性テストケースはアーキテクチャ設計書・テスト方針書に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テストの合格基準値（NFT-001〜008）は実環境で妥当か確認
- [ ] Rijndael/RSA等の暗号化テストケースが.NET互換性テストを網羅しているか確認
- [ ] VB6 IDEでのSimplyVBUnitテスト実行が可能な環境があるか確認
- [ ] 2GB超ファイル処理テストの実行環境（ディスク容量等）が確保されているか確認
- [ ] Windows XP対応テストの実行環境が必要か、または省略可能か判断
