---
generated_at: 2026-01-20 17:18:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **稼働率・RTO・RPO**: ライブラリ特性上の該当なし判断の妥当性確認
  2. **推奨メモリ容量**: 512MB以上の根拠不足
  3. **非同期I/O将来拡張**: ロードマップ不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/README.md` - プロジェクト概要
- E-02: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/README.TXT` - バージョン履歴・変更ログ
- E-03: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Security.Cryptography/RSACryptoServiceProvider.cls` - RSA暗号実装
- E-04: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` - AES暗号実装
- E-05: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.IO/FileStream.cls` - ファイルストリーム実装
- E-06: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Collections/ArrayList.cls` - ArrayList実装
- E-07: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Text/StringBuilder.cls` - StringBuilder実装
- E-08: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/Tests/` - テストコード群
- E-09: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/Fakes/` - フェイクオブジェクト群
- E-10: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/CorLib.chm` - APIドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StringBuilder初期容量128文字 | E-07: `Private Const DefaultCapacity As Long = 128` | ○ |
| C-02 | StringBuilder容量2倍拡張 | E-07: `NewCapacity = mCapacity * 2` | ○ |
| C-03 | ArrayList初期容量16 | E-06: `Private Const DefaultCapacity As Long = 16` | ○ |
| C-04 | ArrayList容量2倍拡張 | E-06: `NewCapacity = mCapacity * 2` | ○ |
| C-05 | FileStream最小バッファ8バイト | E-05: `Private Const MinBufferSize As Long = 8` | ○ |
| C-06 | FileStream CopyToデフォルトバッファ81920バイト | E-05: `Optional ByVal BufferSize As Long = 81920` | ○ |
| C-07 | 2GB超ファイル対応 | E-01: `Handles files larger than 2 gigs.` | ○ |
| C-08 | RSA鍵サイズ384-16384ビット（高暗号化） | E-03: `Set mLegalKeySizes(0) = Cor.NewKeySizes(384, 16384, 8)` | ○ |
| C-09 | RSA鍵サイズ384-512ビット（基本） | E-03: `Set mLegalKeySizes(0) = Cor.NewKeySizes(384, 512, 8)` | ○ |
| C-10 | RSAデフォルト鍵サイズ1024/512ビット | E-03: `mKeySize = 1024` / `mKeySize = 512` | ○ |
| C-11 | AESブロックサイズ128/192/256ビット | E-04: `Private Const DEF_MINBLOCKSIZE As Long = 128` 〜 `DEF_MAXBLOCKSIZE As Long = 256` | ○ |
| C-12 | AESキーサイズ128/192/256ビット | E-04: `Private Const DEF_MINKEYSIZE As Long = 128` 〜 `DEF_MAXKEYSIZE As Long = 256` | ○ |
| C-13 | AESデフォルトキーサイズ256ビット | E-04: `Private Const DEF_KEYSIZE As Long = DEF_MAXKEYSIZE` | ○ |
| C-14 | AESデフォルト暗号モードCBC | E-04: `.Mode = CipherMode.CBC` | ○ |
| C-15 | AESデフォルトパディングPKCS7 | E-04: `.Padding = PaddingMode.PKCS7` | ○ |
| C-16 | RSA OAEPパディングサポート | E-03: `If fOAEP Then Flags = CRYPT_OAEP` | ○ |
| C-17 | RSA署名アルゴリズム（MD5,SHA1,SHA256,SHA384,SHA512） | E-03: SignHashメソッドのSelect Case文 | ○ |
| C-18 | 鍵のCSP永続化オプション | E-03: `PersistKeyInCsp` プロパティ | ○ |
| C-19 | Clear()メソッドでリソース解放 | E-03, E-04: Clear()メソッド実装 | ○ |
| C-20 | Class_Terminateでリソース解放 | E-03, E-05: Class_Terminate実装 | ○ |
| C-21 | ファイルロック機能 | E-05: LockStream/UnlockStreamメソッド | ○ |
| C-22 | 非同期読み書きパターン | E-05: BeginRead/EndRead, BeginWrite/EndWriteメソッド | ○ |
| C-23 | 例外クラス階層（.NET互換） | E-02: 各種Exceptionクラスの実装記載 | ○ |
| C-24 | IComparer/IEqualityComparer対応 | E-02: `Added IEqualityComparer` | ○ |
| C-25 | テストフレームワーク使用 | E-08: SimplyVBUnitテストクラス群 | ○ |
| C-26 | Fakesによるテスト支援 | E-09: Fakesフォルダの存在 | ○ |
| C-27 | VBDocコメント形式 | E-03, E-04, E-05, E-06, E-07: ``形式のコメント | ○ |
| C-28 | CHMドキュメント提供 | E-10: CorLib.chmファイル（1.6MB） | ○ |
| C-29 | DEP対応 | E-02: `Updated ASM code to not trigger DEP protection` | ○ |
| C-30 | Windows XP互換性 | E-02: `Removed dependency of CompareStringOrdinal API` | ○ |
| C-31 | Unicode API対応（32K超ファイル名） | E-02: `Unicode API support... long file names (over 32k)` | ○ |
| C-32 | VBCultures.nlpリソース内蔵 | E-02: `VBCultures.nlp... compiled directly into the library` | ○ |
| C-33 | GoSubの廃止（パフォーマンス問題回避） | E-02: `Remove all GoSub usage... severe performance issues` | ○ |
| C-34 | WeakReferenceの削除 | E-02: `Removed WeakReference class because it is severely limited and unstable` | ○ |
| C-35 | BigInteger任意精度 | E-01: `Provides a BigInteger to perform large calculations` | ○ |
| C-36 | コンソールアクセス機能 | E-01: `Provides easy access to a console window` | ○ |
| C-37 | 64ビット整数サポート | E-01: `Utilize signed 64-bit integers` | ○ |
| C-38 | Git autocrlf=false設定必須 | E-01: `git config --global core.autocrlf false` | ○ |
| C-39 | MITライセンス | E-03, E-04, E-05: ソースコード内のライセンス表記 | ○ |
| C-40 | IVersionableインターフェース | E-06: `Implements IVersionable` | ○ |
| C-41 | シリアライゼーション対応（PropertyBag） | E-06: Class_ReadProperties/Class_WriteProperties実装 | ○ |
| C-42 | 587以上のテストクラス | E-08: findコマンドで確認 | ○ |
| C-43 | 稼働率N/A（ライブラリ特性） | **根拠なし** | △ |
| C-44 | 推奨メモリ512MB以上 | **根拠なし** | △ |
| C-45 | 非同期I/O将来拡張予定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-43（稼働率N/A）**: ライブラリであるため可用性指標が該当しないという判断は合理的だが、明示的な設計文書での確認が必要
  - 候補：設計方針書 / 要件定義書 / プロジェクト仕様書
- **C-44（推奨メモリ512MB）**: BigInteger演算時の目安として記載したが、ベンチマークデータや公式推奨値は確認できず
  - 候補：パフォーマンステストレポート / リリースノート / 開発者ブログ
- **C-45（非同期I/O将来拡張）**: 現在のBeginRead/EndReadは同期的に実装されているが、将来の拡張計画は不明
  - 候補：ロードマップ / Issue tracker / 開発者コメント

## 5) リスクフラグ（レビュー観点）
- **リスクレベル0（低）**: セキュリティ要件 - コードから直接確認可能
- **リスクレベル0（低）**: 性能要件 - ソースコードの定数・アルゴリズムで確認
- **リスクレベル0（低）**: 保守性要件 - テスト・ドキュメント構造で確認
- **リスクレベル1（中）**: 可用性要件 - ライブラリ特性による該当なし判断の妥当性
- **リスクレベル1（中）**: 運用要件 - ログ・監視機能が未実装のため、利用側での対応が必要

## 6) レビュアーチェックリスト（最小）
- [ ] RSA/AESのデフォルト設定値がセキュリティポリシーに適合しているか
- [ ] ファイルサイズ2GB超対応の実際の動作確認が必要か
- [ ] テストカバレッジが非機能要件を十分にカバーしているか
- [ ] Windows XP互換性の維持が今後も必要か
- [ ] 可用性要件のN/A判断が利用ケースに適切か
- [ ] 暗号化アルゴリズムの推奨設定が最新のセキュリティ基準を満たしているか
- [ ] 非同期処理の将来拡張に関する方針が必要か
