# 非機能要件定義書

## 概要

本ドキュメントは、VBCorLib（Visual Basic 6向け.NET互換クラスライブラリ）プロジェクトのソースコードから抽出した非機能要件を定義するものである。VBCorLibは、VB6環境に.NET Frameworkと互換性のある機能を提供するライブラリであり、コレクション、暗号化、ファイル操作、エンコーディング、大整数演算などの機能を含む。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| StringBuilder文字列操作 | 最小限のメモリ再割当 | 容量を2倍に拡張する動的アルゴリズム採用（初期容量128文字） |
| ArrayList要素操作 | O(1)〜O(n) | インデックスアクセスはO(1)、検索・挿入・削除はO(n) |
| ハッシュアルゴリズム演算 | Windows CryptoAPI依存 | MD5, SHA1, SHA256, SHA384, SHA512はネイティブAPIを使用 |
| ファイルI/O操作 | バッファリング効率 | FileStreamは最小8バイト、デフォルト81920バイトのバッファを使用 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| ファイル処理サイズ | 2GB超対応 | 64ビットファイルポインタを使用（Currency型で実装） |
| BigInteger演算精度 | 任意精度 | メモリが許す限り無制限の精度で計算可能 |
| 暗号化キーサイズ | 最大16384ビット | RSA暗号で384〜16384ビット（高暗号化システム） |
| AES暗号ブロックサイズ | 128/192/256ビット | Rijndael実装で3種類のブロックサイズをサポート |

### メモリ管理

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| ArrayList容量管理 | 動的拡張（2倍） | 初期容量16、TrimToSizeで最適化可能 |
| StringBuilder容量管理 | 動的拡張（2倍） | 初期容量128、EnsureCapacityで事前確保可能 |
| FileStreamバッファ | 設定可能 | コンストラクタでバッファサイズ指定可能 |
| 暗号化キー管理 | 明示的クリア | Clear()メソッドでキー・IVをメモリから消去 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | N/A（ライブラリ） | 利用アプリケーションの可用性に依存 |
| 計画停止時間 | N/A | DLL形式のライブラリのため該当なし |
| 障害復旧時間（RTO） | N/A | ライブラリ特性上、アプリケーション再起動で復旧 |
| 目標復旧時点（RPO） | N/A | 状態を永続化しないライブラリのため該当なし |

### エラーハンドリング

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 例外体系 | .NET互換例外クラス | ArgumentException, IOException等の例外階層を実装 |
| リソース解放 | Class_Terminateで自動解放 | 暗号化コンテキスト、ファイルハンドル等を確実に解放 |
| 境界値チェック | 入力検証を徹底 | 配列境界、引数範囲の厳密な検証 |
| 非同期エラー処理 | StreamAsyncResultで例外保持 | BeginRead/EndReadパターンでエラー伝播 |

## セキュリティ要件

### 暗号化アルゴリズム

| アルゴリズム種別 | サポート内容 | セキュリティレベル |
| --- | --- | --- |
| 対称暗号 | Rijndael(AES), DES, TripleDES, RC2 | AES-256推奨 |
| 非対称暗号 | RSA, DSA | 1024ビット以上推奨 |
| ハッシュ | MD5, SHA1, SHA256, SHA384, SHA512, RIPEMD160 | SHA256以上推奨 |
| MAC | HMAC-SHA1/256/384/512, HMAC-MD5, HMAC-RIPEMD160, MACTripleDES | HMAC-SHA256推奨 |
| 鍵導出 | Rfc2898DeriveBytes(PBKDF2) | ソルト使用必須 |

### 暗号化設定

| 項目 | デフォルト値 | 推奨設定 |
| --- | --- | --- |
| RSAキーサイズ | 1024ビット（高暗号化）/ 512ビット（基本） | 2048ビット以上 |
| AESキーサイズ | 256ビット | 256ビット |
| AESブロックサイズ | 128ビット | 128ビット |
| 暗号モード | CBC | CBC with random IV |
| パディング | PKCS7 | PKCS7 |

### 鍵管理

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 鍵生成 | Windows CryptoAPIによる安全な乱数生成 | RNGCryptoServiceProvider使用 |
| 鍵保存 | CSPコンテナへの永続化オプション | PersistKeyInCspプロパティで制御 |
| 鍵エクスポート | XML形式、CspBlob形式 | 秘密鍵エクスポートは明示的指定が必要 |
| 鍵インポート | XML形式、CspBlob形式からのインポート | FromXmlString, ImportCspBlobメソッド |

### セキュリティ制約

| 項目 | 制約内容 | 備考 |
| --- | --- | --- |
| OAEP パディング | RSA暗号化でOAEPサポート | fOAEPパラメータで有効化 |
| 署名アルゴリズム | MD5, SHA1, SHA256, SHA384, SHA512 | SHA256以上を推奨 |
| 乱数生成 | 暗号論的擬似乱数生成器使用 | RNGCryptoServiceProvider |
| DEP対応 | ASMコードがDEP保護をトリガーしないよう更新済み | バージョン2.3で対応 |

## 拡張性要件

### インターフェース設計

| インターフェース | 目的 | 実装クラス例 |
| --- | --- | --- |
| ICollection | コレクション抽象化 | ArrayList, Hashtable, Queue, Stack |
| IEnumerable | 列挙可能性 | 全コレクションクラス |
| IComparer | 比較ロジックのカスタマイズ | Comparer, CaseInsensitiveComparer |
| IEqualityComparer | 等価性判定のカスタマイズ | Hashtable用 |
| IHashAlgorithm | ハッシュアルゴリズム抽象化 | SHA1, MD5, SHA256等 |
| ICryptoTransform | 暗号変換抽象化 | RijndaelManagedTransform等 |
| IFormatProvider | 書式設定プロバイダ | CultureInfo, NumberFormatInfo |
| Stream | ストリーム抽象化 | FileStream, MemoryStream, CryptoStream |

### プラグイン可能性

| 項目 | 拡張方法 | 備考 |
| --- | --- | --- |
| 暗号アルゴリズム | SymmetricAlgorithm継承 | カスタム対称暗号の追加可能 |
| ハッシュアルゴリズム | HashAlgorithm継承 | カスタムハッシュの追加可能 |
| エンコーディング | Encoding継承 | カスタムエンコーディングの追加可能 |
| 比較ロジック | IComparer実装 | ソート・検索のカスタマイズ |
| 書式設定 | IFormattable実装 | Object.ToString()でカスタム書式適用 |
| リソースデコーダ | IResourceDecoder実装 | カスタムリソース形式のサポート |

## 保守性要件

### コード品質

| 項目 | 実装状況 | 備考 |
| --- | --- | --- |
| 命名規則 | .NET Framework準拠 | クラス名、メソッド名はPascalCase |
| コメント | VBDoc形式のXMLコメント | DocIncludesフォルダにHTML形式ドキュメント |
| エラーメッセージ | リソース化 | Environment.GetResourceStringで取得 |
| 定数管理 | Private Const使用 | マジックナンバー回避 |
| バージョン管理 | IVersionableインターフェース | コレクション変更検出に使用 |

### テスト容易性

| 項目 | 実装状況 | 備考 |
| --- | --- | --- |
| ユニットテスト | SimplyVBUnitフレームワーク使用 | Tests フォルダに587以上のテストクラス |
| テスト構成 | 名前空間別に整理 | System.IO, System.Security.Cryptography等 |
| モック対応 | Fakesフォルダにスタブ実装 | テスト用のフェイクオブジェクト |
| テストランナー | frmSimplyVBUnitRunner.frm | GUI形式のテスト実行環境 |

### ドキュメンテーション

| 項目 | 提供形式 | 備考 |
| --- | --- | --- |
| APIリファレンス | CHM形式 | CorLib.chm（1.6MB） |
| オンラインドキュメント | HTML形式 | http://www.kellyethridge.com/vbcorlib/doc/ |
| README | Markdown形式 | プロジェクトルートおよびソースフォルダ |
| 変更履歴 | README.TXT | バージョン別の変更内容を記録 |

## 運用・監視要件

### ログ出力

| 項目 | 実装状況 | 備考 |
| --- | --- | --- |
| アプリケーションログ | 未実装 | ライブラリとしてログ機能なし |
| デバッグ出力 | Debug.Assert使用 | 開発時のみ有効 |
| エラーログ | 例外メッセージに含有 | アプリケーション側でハンドリング |

### 診断機能

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| バージョン取得 | App.Majorなどで取得可能 | VB6標準機能を利用 |
| 環境情報 | Environment クラス | OS情報、特殊フォルダ等を取得可能 |
| StopWatch | 処理時間計測用クラス | パフォーマンス測定に使用可能 |

### デプロイメント

| 項目 | 実装状況 | 備考 |
| --- | --- | --- |
| 配布形式 | COM DLL | VB6 IDE または regsvr32 で登録 |
| 依存ファイル | VBCultures.nlp内蔵 | リソースファイルとしてDLLに埋め込み |
| インストーラ | Install フォルダに配置 | 手動登録手順を提供 |
| 型ライブラリ | TypeLibrary フォルダ | tlb ファイルを提供 |

## 移植性要件

### プラットフォーム対応

| 項目 | サポート状況 | 備考 |
| --- | --- | --- |
| Windows XP | 対応 | CompareStringOrdinal API依存を削除（v3.2） |
| Windows Vista以降 | 対応 | 主要動作環境 |
| 64ビットOS | 対応（WOW64） | 32ビットCOMコンポーネントとして動作 |
| Unicode API | NT系でネイティブ対応 | 32K超ファイル名サポート |

### 相互運用性

| 項目 | サポート状況 | 備考 |
| --- | --- | --- |
| .NET相互運用 | バイナリ互換 | ファイル形式、暗号化結果が.NETと互換 |
| VB6統合 | ネイティブ | COM参照で直接利用可能 |
| VBA対応 | 参照設定で利用可能 | Excel、Access等のVBAから呼び出し可能 |
| Git管理 | CRLF必須 | core.autocrlf=false 設定が必要 |

## 備考

### 既知の制限事項

1. **シングルスレッド**: VB6の制約により、マルチスレッド処理は非サポート
2. **非同期I/O**: 現時点では同期的に実装（将来の拡張予定）
3. **メモリ制限**: VB6の32ビット制約により、単一配列は約2GBまで
4. **WeakReference**: 不安定のため削除済み（v3.0）
5. **GoSubの廃止**: コンパイル時の深刻なパフォーマンス問題を回避（v3.1）

### 推奨構成

| 項目 | 推奨値 | 備考 |
| --- | --- | --- |
| VB6ランタイム | SP6 | 最新サービスパック適用 |
| Windows暗号化 | 高暗号化パック | 16384ビットRSAキーを使用する場合 |
| メモリ | 512MB以上 | 大規模なBigInteger演算時 |
