---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **認証API の詳細仕様**：プロバイダオプションの詳細が型定義のみ
  2. **Proposed API の完全なリスト**：型定義ファイルに散在
  3. **IPC/RPC プロトコルの内部詳細**：実装コードに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vscode-dts/vscode.d.ts` - VSCode Extension API 型定義ファイル（メイン）
- E-02: `src/vs/workbench/api/common/extHost.api.impl.ts` - Extension API 実装ファイル
- E-03: `src/vs/workbench/api/common/extHost.protocol.ts` - IPC/RPC プロトコル定義
- E-04: `src/vs/workbench/api/common/extHostCommands.ts` - Commands API 実装
- E-05: `src/vs/workbench/api/common/extHostWorkspace.ts` - Workspace API 実装
- E-06: `src/vs/workbench/api/common/extHostLanguageFeatures.ts` - Language Features 実装
- E-07: `src/vs/workbench/api/common/extHostAuthentication.ts` - Authentication API 実装
- E-08: `src/vs/workbench/api/common/extHostDebugService.ts` - Debug API 実装
- E-09: `src/vs/workbench/api/common/extHostTerminalService.ts` - Terminal API 実装
- E-10: `src/vs/workbench/api/browser/mainThreadCommands.ts` - MainThread Commands 実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VSCode は Extension API を `vscode` モジュールで提供 | E-01, E-02 | ○ |
| C-02 | env.appName は読み取り専用の string 型 | E-01 (L10728) | ○ |
| C-03 | env.appRoot はアプリケーションルートパスを返す | E-01 (L10736) | ○ |
| C-04 | env.machineId はマシンの一意識別子を返す | E-01 (L10764), E-02 (L389) | ○ |
| C-05 | env.sessionId はセッションごとに変更される | E-01 (L10770), E-02 (L394) | ○ |
| C-06 | env.language はユーザーの優先言語を返す | E-01 (L10754), E-02 (L395) | ○ |
| C-07 | env.clipboard はシステムクリップボードへのアクセスを提供 | E-01 (L10759), E-02 (L400) | ○ |
| C-08 | env.openExternal は外部アプリでURIを開く | E-01 (L10843), E-02 (L428) | ○ |
| C-09 | env.asExternalUri はURIを外部アクセス可能な形式に変換 | E-01 (L10898), E-02 (L434) | ○ |
| C-10 | commands.registerCommand はコマンドを登録し Disposable を返す | E-01 (L10961), E-02 (L343-344) | ○ |
| C-11 | commands.registerTextEditorCommand はエディタコマンドを登録 | E-01 (L10978), E-02 (L346-364) | ○ |
| C-12 | commands.executeCommand はコマンドを実行し Thenable を返す | E-01 (L10994), E-02 (L379-380) | ○ |
| C-13 | commands.getCommands は利用可能なコマンド一覧を返す | E-01 (L11003), E-02 (L382-384) | ○ |
| C-14 | window.activeTextEditor は現在アクティブなエディタを返す | E-01 (L11055) | ○ |
| C-15 | window.visibleTextEditors は表示中のエディタ配列を返す | E-01 (L11060) | ○ |
| C-16 | window.showInformationMessage は情報メッセージを表示 | E-01 | ○ |
| C-17 | window.showWarningMessage は警告メッセージを表示 | E-01 | ○ |
| C-18 | window.showErrorMessage はエラーメッセージを表示 | E-01 | ○ |
| C-19 | window.createTerminal はターミナルを作成 | E-01, E-09 | ○ |
| C-20 | workspace.fs はファイルシステムアクセスを提供 | E-01 (L13779), E-05 | ○ |
| C-21 | workspace.workspaceFolders はワークスペースフォルダ配列を返す | E-01 (L13799), E-05 | ○ |
| C-22 | workspace.getWorkspaceFolder はURIを含むフォルダを返す | E-01 (L13862) | ○ |
| C-23 | workspace.findFiles はワークスペース内のファイルを検索 | E-01 (L14067) | ○ |
| C-24 | workspace.createFileSystemWatcher はファイル監視を作成 | E-01 (L14048) | ○ |
| C-25 | workspace.getConfiguration は設定を取得 | E-01 | ○ |
| C-26 | languages.getLanguages は言語識別子一覧を返す | E-01 (L14702), E-06 | ○ |
| C-27 | languages.setTextDocumentLanguage はドキュメントの言語を変更 | E-01 (L14715), E-06 | ○ |
| C-28 | languages.createDiagnosticCollection は診断コレクションを作成 | E-01 (L14791) | ○ |
| C-29 | languages.registerCompletionItemProvider は補完プロバイダを登録 | E-01 (L14821), E-06 | ○ |
| C-30 | languages.registerDefinitionProvider は定義プロバイダを登録 | E-01 (L14874), E-06 | ○ |
| C-31 | languages.registerHoverProvider はホバープロバイダを登録 | E-01 (L14926), E-06 | ○ |
| C-32 | authentication.getSession は認証セッションを取得 | E-01 (L18065以降), E-02 (L307-339), E-07 | ○ |
| C-33 | authentication.registerAuthenticationProvider は認証プロバイダを登録 | E-01, E-02 (L333-338), E-07 | ○ |
| C-34 | debug.activeDebugSession はアクティブなデバッグセッションを返す | E-01 (L17257以降), E-08 | ○ |
| C-35 | debug.startDebugging はデバッグセッションを開始 | E-01, E-08 | ○ |
| C-36 | extensions.all はインストール済み拡張機能配列を返す | E-01 (L17432以降) | ○ |
| C-37 | extensions.getExtension は指定IDの拡張機能を返す | E-01 | ○ |
| C-38 | tests.createTestController はテストコントローラを作成 | E-01 (L18245以降), E-02 (L485-486) | ○ |
| C-39 | IPC/RPC は ExtHostContext と MainContext を使用 | E-03 (L90, L120以降) | ○ |
| C-40 | MainThreadCommandsShape はコマンドの登録・実行を定義 | E-03 (L127-133) | ○ |
| C-41 | MainThreadAuthenticationShape は認証セッション管理を定義 | E-03 (L211-226) | ○ |
| C-42 | MainThreadConfigurationShape は設定の更新・削除を定義 | E-03 (L235-238) | ○ |
| C-43 | 認証プロバイダオプションの詳細仕様 | **根拠不足** | △ |
| C-44 | Proposed API の完全なリスト | **根拠不足** | △ |
| C-45 | IPC/RPC プロトコルの内部詳細仕様 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **認証プロバイダオプションの詳細仕様**：型定義ファイルに AuthenticationProviderOptions インターフェースが存在するが、各オプションの動作詳細はドキュメント化されていない
  - 候補：VSCode 公式ドキュメント / GitHub Issue / ソースコードコメント
- **Proposed API の完全なリスト**：`checkProposedApiEnabled` 関数の呼び出し箇所に散在しており、包括的なリストが存在しない
  - 候補：vscode.proposed.*.d.ts ファイル群 / src/vs/workbench/services/extensions/common/extensions.ts
- **IPC/RPC プロトコルの内部詳細仕様**：シリアライゼーション方式、タイムアウト、エラーハンドリングの詳細が実装コードに埋め込まれている
  - 候補：src/vs/workbench/services/extensions/common/proxyIdentifier.ts / src/vs/workbench/services/extensions/common/rpcProtocol.ts

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - env, commands, window, workspace の基本API（型定義から明確に読み取れる）
- **1: 中リスク** - languages, debug, extensions のプロバイダ登録API（オプショナルパラメータの動作確認が必要）
- **2: 高リスク** - authentication API（セキュリティに関わるため、詳細仕様の確認が必要）
- **1: 中リスク** - IPC/RPC プロトコル（内部実装に依存するため、将来の変更に注意）

## 6) レビュアーチェックリスト（最小）
- [ ] env 名前空間のプロパティとメソッドが vscode.d.ts の定義と一致しているか確認
- [ ] commands 名前空間の registerCommand, executeCommand のシグネチャが正確か確認
- [ ] window 名前空間の UI 関連メソッドの戻り値型が正確か確認
- [ ] workspace.fs の FileSystem インターフェースメソッドが網羅されているか確認
- [ ] languages 名前空間の registerXxxProvider メソッドが主要なものを網羅しているか確認
- [ ] authentication.getSession のオプションパラメータの説明が十分か確認
- [ ] IPC/RPC プロトコルの MainThread/ExtHost インターフェース一覧が主要なものを網羅しているか確認
- [ ] イベント一覧が主要なイベントを網羅しているか確認
- [ ] 非推奨API の記載が最新の vscode.d.ts と一致しているか確認
