# Visual Studio Code - Open Source (Code - OSS)

## 概要

Visual Studio Code（VS Code）のオープンソース版リポジトリです。Microsoftが開発するクロスプラットフォーム対応の高機能コードエディタであり、コーディング、ナビゲーション、デバッグ、拡張機能による機能拡張を提供します。Electron をベースに構築され、Windows、macOS、Linux で動作します。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| コードエディタ | シンタックスハイライト、IntelliSense、コード補完、スニペット |
| デバッグ | 軽量な統合デバッガ、ブレークポイント、ステップ実行 |
| 拡張機能 | 豊富な拡張機能エコシステムによる言語サポートやツール連携 |
| Git統合 | ソースコントロール、差分表示、コミット管理 |
| ターミナル | 統合ターミナル（xterm.js ベース） |
| リモート開発 | Dev Containers、GitHub Codespaces、SSHリモート接続 |
| Web版 | ブラウザ上で動作する VS Code Web |
| マルチ言語対応 | 100以上のプログラミング言語の文法・スニペット対応 |

## 技術スタック

### コア

- フレームワーク: Electron 39.2.7
- 言語: TypeScript, JavaScript
- ビルドツール: Gulp, Webpack, esbuild
- パッケージマネージャ: npm
- CLI: Rust (code-tunnel-oss)

### 主要ライブラリ

- @xterm/xterm: ターミナルエミュレーション
- @vscode/ripgrep: 高速ファイル検索
- vscode-textmate: TextMate文法エンジン
- vscode-oniguruma: 正規表現エンジン
- node-pty: 疑似端末
- @parcel/watcher: ファイル監視
- playwright: E2Eテスト
- mocha: ユニットテスト

## ディレクトリ構成

```
vscode-main/
├── .devcontainer/        # Dev Container設定
├── .github/              # GitHub Actions, Issue/PRテンプレート
├── .vscode/              # VS Code設定
├── build/                # ビルドスクリプト（Gulp タスク等）
├── cli/                  # Rust製CLIツール（code-tunnel）
├── extensions/           # 組み込み拡張機能（100+言語サポート）
│   ├── typescript-language-features/
│   ├── git/
│   ├── markdown-language-features/
│   └── ... (その他言語サポート)
├── remote/               # リモート開発関連
├── resources/            # アイコン、マニフェスト等
├── scripts/              # 開発・テスト用スクリプト
├── src/                  # メインソースコード
│   ├── vs/
│   │   ├── base/         # 基盤ユーティリティ
│   │   ├── code/         # Electronアプリエントリ
│   │   ├── editor/       # Monaco Editor
│   │   ├── platform/     # プラットフォーム抽象化
│   │   ├── server/       # サーバーモード
│   │   └── workbench/    # ワークベンチUI
│   └── vscode-dts/       # API定義ファイル
└── test/                 # テストスイート
    ├── unit/             # ユニットテスト
    ├── integration/      # 統合テスト
    ├── smoke/            # スモークテスト
    └── automation/       # 自動化テスト
```

## セットアップ

### 必要条件

- Node.js: 22.21.1（.nvmrcで指定）
- npm: Node.jsに同梱
- Git
- Python 3（ネイティブモジュールビルド用）
- C++コンパイラ（node-gypビルド用）
  - Windows: Visual Studio Build Tools
  - macOS: Xcode Command Line Tools
  - Linux: build-essential
- Docker（Dev Container使用時）
  - 最低要件: 4コア、8GB RAM（9GB推奨）

### インストール手順

1. リポジトリをクローン
   ```bash
   git clone https://github.com/microsoft/vscode.git
   cd vscode
   ```

2. 依存関係のインストール
   ```bash
   npm install
   ```

3. ビルドと起動
   ```bash
   # 開発ビルド
   npm run compile

   # VS Codeを起動
   ./scripts/code.sh      # macOS/Linux
   scripts/code.bat       # Windows
   ```

### Dev Container を使用する場合

1. VS Code に Dev Containers 拡張機能をインストール
2. コマンドパレットで「Dev Containers: Clone Repository in Container Volume...」を選択
3. `https://github.com/microsoft/vscode` を入力

## 開発

### ビルドコマンド

```bash
# フルコンパイル
npm run compile

# ウォッチモード（ファイル変更時に自動コンパイル）
npm run watch

# Web版ビルド
npm run compile-web

# CLI（Rust）ビルド
npm run compile-cli
```

### リンター・フォーマッター

```bash
# ESLint実行
npm run eslint

# Stylelint実行
npm run stylelint

# コミット前チェック（Hygiene）
npm run precommit
```

### テスト実行

```bash
# ユニットテスト（Node.js）
npm run test-node

# ユニットテスト（ブラウザ）
npm run test-browser

# 拡張機能テスト
npm run test-extension

# 統合テスト
./scripts/test-integration.sh

# スモークテスト
npm run smoketest
```

### デバッグ

VS Codeの「Run / Debug」ビューで以下の設定を使用：
- `VS Code`: メインプロセスのデバッグ
- `Attach Extension Host`: 拡張機能ホストへのアタッチ
- `Attach Main Process`: メインプロセスへのアタッチ

## ライセンス

MIT License

Copyright (c) Microsoft Corporation. All rights reserved.
