---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **Python 3要件**：公式ドキュメントに記載なし、node-gypの一般要件として推定
  2. **RAM推奨値9GB**：.devcontainer/README.mdでは8GB推奨と記載、9GBとの記載もあり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json`（プロジェクト名、バージョン、依存関係、スクリプト）
- E-02: `README.md`（既存の公式README）
- E-03: `product.json`（製品設定、アプリケーション名）
- E-04: `CONTRIBUTING.md`（コントリビューションガイド）
- E-05: `.nvmrc`（Node.jsバージョン指定）
- E-06: `.devcontainer/README.md`（開発コンテナ設定、セットアップ手順）
- E-07: `src/` ディレクトリ構造
- E-08: `extensions/` ディレクトリ構造
- E-09: `cli/Cargo.toml`（Rust CLI設定）
- E-10: `scripts/` ディレクトリ（開発スクリプト一覧）
- E-11: `LICENSE.txt`（ライセンス情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクト名「Visual Studio Code - Open Source」 | E-02, E-03 | ○ |
| C-02 | Electronベースのクロスプラットフォームエディタ | E-01 (electron: 39.2.7) | ○ |
| C-03 | TypeScript, JavaScript言語で開発 | E-01 (devDependencies: typescript) | ○ |
| C-04 | Electronバージョン 39.2.7 | E-01 (electron: 39.2.7) | ○ |
| C-05 | Gulp, Webpack, esbuildをビルドツールとして使用 | E-01 (gulp, webpack依存関係) | ○ |
| C-06 | @xterm/xtermでターミナルエミュレーション | E-01 (@xterm/xterm依存関係) | ○ |
| C-07 | @vscode/ripgrepで高速検索 | E-01 (@vscode/ripgrep依存関係) | ○ |
| C-08 | vscode-textmateで文法エンジン | E-01 (vscode-textmate依存関係) | ○ |
| C-09 | node-ptyで疑似端末 | E-01 (node-pty依存関係) | ○ |
| C-10 | Playwrightでe2eテスト | E-01 (@playwright/test依存関係) | ○ |
| C-11 | Mochaでユニットテスト | E-01 (mocha依存関係) | ○ |
| C-12 | src/vs/配下のディレクトリ構造 | E-07 (ls結果で確認) | ○ |
| C-13 | extensions/に100+の言語サポート | E-08 (107ディレクトリ確認) | ○ |
| C-14 | Rust製CLI（cli/ディレクトリ） | E-09 (Cargo.toml確認) | ○ |
| C-15 | Node.jsバージョン 22.21.1 | E-05 (.nvmrc確認) | ○ |
| C-16 | Docker最低要件4コア、8GB RAM | E-06 (.devcontainer/README.md) | ○ |
| C-17 | npm installでセットアップ | E-06 (.devcontainer/README.md) | ○ |
| C-18 | scripts/code.shで起動 | E-06, E-10 (スクリプト確認) | ○ |
| C-19 | npm run compileでビルド | E-01 (scripts.compile) | ○ |
| C-20 | npm run watchでウォッチモード | E-01 (scripts.watch) | ○ |
| C-21 | npm run eslintでリント | E-01 (scripts.eslint) | ○ |
| C-22 | npm run test-nodeでテスト | E-01 (scripts.test-node) | ○ |
| C-23 | npm run test-browserでブラウザテスト | E-01 (scripts.test-browser) | ○ |
| C-24 | npm run smoketestでスモークテスト | E-01 (scripts.smoketest) | ○ |
| C-25 | MITライセンス | E-01 (license: MIT), E-11 | ○ |
| C-26 | Dev Containers対応 | E-06 (.devcontainer/README.md) | ○ |
| C-27 | Python 3がネイティブモジュールビルドに必要 | **根拠なし** | △ |
| C-28 | RAM 9GB推奨 | E-06 (記載あるが8GB推奨と混在) | △ |

## 4) 不足情報（Unknown / Missing）
- **Python 3要件**: node-gypの一般的な要件として推定したが、このリポジトリ固有のドキュメントには明示されていない
  - 候補：wiki / CONTRIBUTING.md / build/README.md
- **RAM推奨値**: .devcontainer/README.mdには「8 GB of RAM (8 GB recommended)」と「9 GB of RAM being recommended」の両方の記載があり、一貫性が不明
  - 候補：公式Wiki / .devcontainer/devcontainer.json

## 5) リスクフラグ（レビュー観点）
- 0: プロジェクト名・ライセンス（確実な根拠あり）
- 0: 技術スタック・依存関係（package.jsonで確認済み）
- 0: ビルド・テストコマンド（package.jsonのscriptsで確認済み）
- 1: セットアップ要件のPython 3記載（一般的要件だが明示的根拠なし）
- 1: RAM推奨値（ドキュメント内で記載の揺れあり）

## 6) レビュアーチェックリスト（最小）
- [ ] Python 3要件が正しいか、または削除すべきか確認
- [ ] RAM推奨値を8GBまたは9GBに統一すべきか確認
- [ ] 拡張機能の数（100+）が現在のリポジトリ状態と一致するか確認
- [ ] Node.jsバージョンが最新の.nvmrcと一致するか確認
- [ ] Electronバージョンが最新のpackage.jsonと一致するか確認
