---
generated_at: 2026-01-27 11:32:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **キャッシュTTL**: V8 Code CacheのTTL値の詳細確認が必要
  2. **AppCenter連携**: クラッシュレポートの送信先URLの確認が必要
  3. **パフォーマンスメトリクス**: 非同期処理の遅延許容値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - 依存関係、バージョン情報
- E-02: `src/main.ts` - アプリケーションエントリポイント
- E-03: `src/vs/code/electron-main/main.ts` - Mainプロセス実装
- E-04: `src/vs/platform/instantiation/common/instantiation.ts` - DIコンテナ実装
- E-05: `src/vs/workbench/workbench.common.main.ts` - Workbenchサービス登録
- E-06: `build/checker/layersChecker.ts` - レイヤー制約チェッカー
- E-07: `product.json` - 製品設定
- E-08: `src/vs/base/` ディレクトリ構成
- E-09: `src/vs/platform/` ディレクトリ構成
- E-10: `src/vs/editor/` ディレクトリ構成
- E-11: `src/vs/workbench/` ディレクトリ構成
- E-12: `src/vs/code/` ディレクトリ構成
- E-13: `extensions/` ディレクトリ構成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Electronベースのデスクトップアプリケーション | E-01, E-02 | ○ |
| C-02 | Electron v39.2.7を使用 | E-01 | ○ |
| C-03 | VS Code Marketplaceとの連携 | E-05 | ○ |
| C-04 | GitHub OAuth連携 | E-07 | ○ |
| C-05 | Language Server Protocol対応 | E-13 | ○ |
| C-06 | Debug Adapter Protocol対応 | E-05, E-13 | ○ |
| C-07 | レイヤードアーキテクチャの採用 | E-06 | ○ |
| C-08 | 依存性注入パターンの使用 | E-04, E-05 | ○ |
| C-09 | マルチプロセスアーキテクチャ | E-02, E-03 | ○ |
| C-10 | base/platform/editor/workbench/codeのレイヤー構成 | E-08, E-09, E-10, E-11, E-12 | ○ |
| C-11 | common/browser/node/electron-*のプラットフォーム分離 | E-06, E-08 | ○ |
| C-12 | Native型のbrowser/commonでの使用禁止 | E-06 | ○ |
| C-13 | 90以上のPlatformサービス | E-09 | ○ |
| C-14 | 90以上のWorkbenchサービス | E-11 | ○ |
| C-15 | 60以上のWorkbench Contribution | E-05, E-11 | ○ |
| C-16 | 100以上の組み込み拡張機能 | E-13 | ○ |
| C-17 | SQLite (@vscode/sqlite3 5.1.11)を使用 | E-01 | ○ |
| C-18 | ripgrep (@vscode/ripgrep 1.15.13)を使用 | E-01 | ○ |
| C-19 | xterm.js (@xterm/xterm 6.1.0-beta)を使用 | E-01 | ○ |
| C-20 | node-pty (1.2.0-beta)を使用 | E-01 | ○ |
| C-21 | vscode-textmate (9.3.1)を使用 | E-01 | ○ |
| C-22 | spdlog (@vscode/spdlog 0.15.2)を使用 | E-01 | ○ |
| C-23 | Parcel Watcher (@parcel/watcher 2.5.4)を使用 | E-01 | ○ |
| C-24 | Tree-sitter (@vscode/tree-sitter-wasm 0.3.0)を使用 | E-01 | ○ |
| C-25 | KaTeX (0.16.22)を使用 | E-01 | ○ |
| C-26 | createDecorator<T>()による依存性注入 | E-04 | ○ |
| C-27 | InstantiationServiceによるDI管理 | E-03, E-04 | ○ |
| C-28 | ServiceCollectionによるサービス登録 | E-03, E-04 | ○ |
| C-29 | registerSingletonによるサービス登録 | E-05 | ○ |
| C-30 | Electron IPCによるプロセス間通信 | E-02, E-03 | ○ |
| C-31 | MessagePortによるExtension Host通信 | E-05 | ○ |
| C-32 | クラッシュレポーター設定 | E-02 | ○ |
| C-33 | V8 Code Cacheの使用 | E-02 | ○ |
| C-34 | NLS（多言語対応）設定 | E-02 | ○ |
| C-35 | サンドボックスモードの設定 | E-02 | ○ |
| C-36 | ポータブルモードのサポート | E-02 | ○ |
| C-37 | UNCパス対応（Windows） | E-02, E-03 | ○ |
| C-38 | カスタムプロトコル登録（vscode-webview, vscode-file） | E-02 | ○ |
| C-39 | 遅延サービス登録（InstantiationType.Delayed） | E-05 | ○ |
| C-40 | GitHub Copilot連携設定 | E-07 | ○ |
| C-41 | MCP (Model Context Protocol)対応 | E-05 | ○ |
| C-42 | Trusted Workspace機能 | E-05 | ○ |
| C-43 | V8 Code CacheのTTLがコミットハッシュ依存 | **根拠なし** | △ |
| C-44 | AppCenterへのクラッシュレポート送信 | E-02, **詳細URL未確認** | △ |
| C-45 | 設定変更の遅延バッチ書き込み（DELAYED SaveStrategy） | E-03, **詳細動作未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- V8 Code CacheのTTL具体的な値・動作の確認
  - 候補：Electronドキュメント / Chromiumソースコード / VS Code Wiki
- AppCenterクラッシュレポート送信先の完全なURL
  - 候補：製品版のproduct.json / AppCenter設定ドキュメント
- StateServiceの遅延書き込みの具体的なタイミング
  - 候補：StateService実装コード / テストコード

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 依存関係バージョン情報 - package.jsonから直接取得
- 0（低リスク）: レイヤー構成 - ディレクトリ構造とlayersChecker.tsから確認
- 0（低リスク）: DIパターン - instantiation.tsの実装から確認
- 1（中リスク）: プロセス間通信の詳細 - 概要レベルの確認のみ
- 1（中リスク）: 非同期処理フローの詳細 - 一部推測を含む
- 2（高リスク）: パフォーマンス関連の数値 - 明示的な根拠なし

## 6) レビュアーチェックリスト（最小）
- [ ] レイヤー構成（base/platform/editor/workbench/code）がディレクトリ構造と一致するか確認
- [ ] 依存関係バージョンがpackage.jsonと一致するか確認
- [ ] DIパターンの説明がinstantiation.tsの実装と一致するか確認
- [ ] プラットフォーム分離（common/browser/node/electron-*）がlayersChecker.tsのルールと一致するか確認
- [ ] 拡張機能数がextensions/ディレクトリの実数と一致するか確認
- [ ] GitHub Copilot連携設定がproduct.jsonと一致するか確認
