# アーキテクチャ構成図

## 1. システム全体構成図

```mermaid
graph TB
    subgraph "Visual Studio Code Architecture"
        subgraph "Desktop Application"
            MP[Main Process<br/>Electron Main]
            RP[Renderer Process<br/>Workbench UI]
            EH[Extension Host<br/>Process]
            UP[Utility Process]
        end

        subgraph "External Systems"
            MKT[VS Code Marketplace]
            GH[GitHub]
            RS[Remote Server]
            LS[Language Servers]
            DA[Debug Adapters]
        end

        MP <-->|Electron IPC| RP
        RP <-->|MessagePort| EH
        MP <-->|IPC| UP

        EH -->|HTTP/S| MKT
        EH -->|OAuth/API| GH
        RP -->|SSH/WebSocket| RS
        EH -->|LSP| LS
        EH -->|DAP| DA
    end
```

## 2. プロセスアーキテクチャ

```mermaid
graph LR
    subgraph "Main Process"
        MA[CodeApplication]
        WM[Window Manager]
        FS[File Service]
        LS[Lifecycle Service]
    end

    subgraph "Renderer Process"
        WB[Workbench]
        ED[Editor]
        SB[Sidebar]
        PN[Panel]
        STS[Status Bar]
    end

    subgraph "Extension Host"
        API[Extension API]
        EXT1[Extension 1]
        EXT2[Extension 2]
        EXTN[Extension N]
    end

    subgraph "Utility Process"
        PTY[Terminal PTY]
        SRCH[Search Worker]
    end

    MA --> WM
    WM -->|IPC| WB
    WB --> ED
    WB --> SB
    WB --> PN
    WB --> STS

    WB -->|MessagePort| API
    API --> EXT1
    API --> EXT2
    API --> EXTN

    MA --> PTY
    MA --> SRCH
```

## 3. レイヤーアーキテクチャ

```mermaid
graph TB
    subgraph "Application Layer"
        CODE[code<br/>electron-main / electron-browser / browser]
    end

    subgraph "Workbench Layer"
        WB_PARTS[Parts<br/>Editor, Sidebar, Panel, StatusBar]
        WB_SERVICES[Services<br/>90+ Services]
        WB_CONTRIB[Contributions<br/>60+ Features]
        WB_API[Extension API]
    end

    subgraph "Editor Layer"
        ED_COMMON[Editor Common<br/>TextModel, ViewModel]
        ED_BROWSER[Editor Browser<br/>EditorWidget, ViewLines]
        ED_CONTRIB[Editor Contrib<br/>Autocomplete, Snippets]
    end

    subgraph "Platform Layer"
        PL_INST[Instantiation<br/>DI Container]
        PL_CONFIG[Configuration]
        PL_FILES[Files]
        PL_STORAGE[Storage]
        PL_LOG[Log]
        PL_OTHER[90+ Platform Services]
    end

    subgraph "Base Layer"
        BASE_COMMON[Common<br/>Utilities, Types]
        BASE_BROWSER[Browser<br/>DOM, CSS]
        BASE_NODE[Node<br/>FS, Process]
        BASE_PARTS[Parts<br/>IPC, Sandbox]
    end

    CODE --> WB_PARTS
    CODE --> WB_SERVICES

    WB_PARTS --> ED_COMMON
    WB_PARTS --> ED_BROWSER
    WB_SERVICES --> PL_INST
    WB_CONTRIB --> WB_SERVICES
    WB_API --> WB_SERVICES

    ED_COMMON --> PL_CONFIG
    ED_BROWSER --> BASE_BROWSER
    ED_CONTRIB --> ED_COMMON

    PL_INST --> BASE_COMMON
    PL_CONFIG --> PL_FILES
    PL_FILES --> BASE_NODE
    PL_STORAGE --> BASE_NODE
    PL_LOG --> BASE_NODE
    PL_OTHER --> BASE_COMMON

    BASE_BROWSER --> BASE_COMMON
    BASE_NODE --> BASE_COMMON
    BASE_PARTS --> BASE_COMMON
```

## 4. 依存性注入（DI）構造

```mermaid
graph TB
    subgraph "DI Container"
        IS[InstantiationService]
        SC[ServiceCollection]
        SD[SyncDescriptor]
    end

    subgraph "Service Registration"
        REG[registerSingleton]
        DEC[createDecorator]
    end

    subgraph "Services"
        IFS[IFileService]
        ICS[IConfigurationService]
        ILS[ILogService]
        ISS[IStorageService]
    end

    subgraph "Implementations"
        FS[FileService]
        CS[ConfigurationService]
        LS[LogService]
        SS[StorageService]
    end

    DEC --> IFS
    DEC --> ICS
    DEC --> ILS
    DEC --> ISS

    REG --> SD
    SD --> SC
    SC --> IS

    IS -->|createInstance| FS
    IS -->|createInstance| CS
    IS -->|createInstance| LS
    IS -->|createInstance| SS

    IFS -.->|implements| FS
    ICS -.->|implements| CS
    ILS -.->|implements| LS
    ISS -.->|implements| SS
```

## 5. モジュール構成図

```mermaid
graph TB
    subgraph "src/vs"
        subgraph "base"
            BC[common<br/>Utilities]
            BB[browser<br/>DOM Utils]
            BN[node<br/>Node Utils]
            BP[parts<br/>IPC, Sandbox]
        end

        subgraph "platform"
            PI[instantiation]
            PC[configuration]
            PF[files]
            PS[storage]
            PL[log]
            PT[telemetry]
            PE[environment]
            PO[...90+ services]
        end

        subgraph "editor"
            ECC[common<br/>TextModel]
            ECB[browser<br/>EditorWidget]
            ECTR[contrib<br/>Features]
            ECS[standalone<br/>Monaco]
        end

        subgraph "workbench"
            WBB[browser<br/>Parts, Layout]
            WBS[services<br/>90+ services]
            WBC[contrib<br/>60+ features]
            WBA[api<br/>Extension Host]
        end

        subgraph "code"
            CEM[electron-main]
            CEB[electron-browser]
            CBR[browser]
            CNO[node]
        end
    end

    CEM --> PI
    CEB --> WBB
    CBR --> WBB

    WBB --> ECC
    WBB --> ECB
    WBS --> PI
    WBC --> WBS
    WBA --> WBS

    ECC --> PC
    ECB --> BB
    ECTR --> ECC

    PI --> BC
    PC --> PF
    PF --> BN
    PS --> BN
```

## 6. データフロー図

```mermaid
sequenceDiagram
    participant U as User
    participant UI as Workbench UI
    participant CMD as CommandService
    participant SVC as Service
    participant MP as Main Process
    participant FS as File System

    U->>UI: User Action (Keyboard/Mouse)
    UI->>CMD: Execute Command
    CMD->>SVC: Invoke Service Method

    alt Requires Main Process
        SVC->>MP: IPC Request
        MP->>FS: File Operation
        FS-->>MP: Result
        MP-->>SVC: IPC Response
    end

    SVC-->>CMD: Result
    CMD->>UI: Emit Event
    UI-->>U: Update View
```

## 7. 拡張機能通信図

```mermaid
sequenceDiagram
    participant EXT as Extension
    participant API as vscode.* API
    participant EH as ExtHost
    participant MQ as MessagePort
    participant MT as MainThread
    participant SVC as Workbench Service

    EXT->>API: API Call
    API->>EH: ExtHostCommand
    EH->>MQ: Serialize & Send
    MQ->>MT: Receive
    MT->>SVC: Execute
    SVC-->>MT: Result
    MT->>MQ: Serialize & Send
    MQ-->>EH: Receive
    EH-->>API: Deserialize
    API-->>EXT: Promise Resolve
```

## 8. ファイル操作フロー図

```mermaid
flowchart TB
    subgraph "Editor Layer"
        ES[EditorService]
        TM[TextModel]
        VM[ViewModel]
    end

    subgraph "Platform Layer"
        FS[FileService]
        FSP[FileSystemProvider]
        DFS[DiskFileSystemProvider]
    end

    subgraph "System Layer"
        NFS[Node.js fs]
        PW[Parcel Watcher]
    end

    ES -->|openEditor| FS
    FS -->|resolveProvider| FSP
    FSP -->|file://| DFS
    DFS -->|readFile| NFS
    NFS -->|content| DFS
    DFS -->|content| FS
    FS -->|TextBuffer| TM
    TM -->|Tokenize| VM
    VM -->|Render| ES

    PW -->|FileChange| FS
    FS -->|onDidChange| ES
```

## 9. コントリビューション構成図

```mermaid
graph TB
    subgraph "Workbench Contributions"
        subgraph "Editor"
            C_EDIT[editor.contribution]
            C_PREF[preferences.contribution]
        end

        subgraph "Version Control"
            C_SCM[scm.contribution]
            C_GIT[git extension]
        end

        subgraph "Debugging"
            C_DBG[debug.contribution]
            C_JSDBG[js-debug extension]
        end

        subgraph "Terminal"
            C_TERM[terminal.contribution]
        end

        subgraph "AI/Chat"
            C_CHAT[chat.contribution]
            C_INLINE[inlineChat.contribution]
            C_MCP[mcp.contribution]
        end

        subgraph "Search"
            C_SRCH[search.contribution]
        end

        subgraph "Extensions"
            C_EXT[extensions.contribution]
        end
    end

    subgraph "Registry"
        REG[WorkbenchContributionsRegistry]
    end

    C_EDIT --> REG
    C_PREF --> REG
    C_SCM --> REG
    C_DBG --> REG
    C_TERM --> REG
    C_CHAT --> REG
    C_SRCH --> REG
    C_EXT --> REG
```

## 10. プラットフォーム抽象化図

```mermaid
graph TB
    subgraph "Platform-Independent (common)"
        IFS[IFileService]
        ICS[IConfigurationService]
        ISS[IStorageService]
    end

    subgraph "Browser Implementation"
        BFS[BrowserFileService]
        BCS[BrowserConfigurationService]
        BSS[BrowserStorageService<br/>IndexedDB]
    end

    subgraph "Node Implementation"
        NFS[DiskFileSystemProvider]
        NCS[NodeConfigurationService]
        NSS[NodeStorageService<br/>SQLite]
    end

    subgraph "Electron Implementation"
        EFS[ElectronFileService]
        ECS[ElectronConfigurationService]
        ESS[ElectronStorageService]
    end

    IFS -.-> BFS
    IFS -.-> NFS
    IFS -.-> EFS

    ICS -.-> BCS
    ICS -.-> NCS
    ICS -.-> ECS

    ISS -.-> BSS
    ISS -.-> NSS
    ISS -.-> ESS
```
