---
generated_at: 2026-01-27 13:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **Azure Blob Storage のSLA・冗長性設定**：コードベースから直接確認不可
  2. **CDN のSLA**：コードベースから直接確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.devcontainer/Dockerfile`
- E-02: `.devcontainer/devcontainer.json`
- E-03: `.devcontainer/install-vscode.sh`
- E-04: `build/azure-pipelines/product-build.yml`
- E-05: `build/azure-pipelines/product-compile.yml`
- E-06: `build/azure-pipelines/product-publish.yml`
- E-07: `build/azure-pipelines/web/product-build-web.yml`
- E-08: `.github/workflows/pr.yml`
- E-09: `resources/linux/snap/snapcraft.yaml`
- E-10: `package.json`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Dev Container は Node.js 22 (typescript-node:22-bookworm) を使用 | E-01 | ○ |
| C-02 | Dev Container は VNC 対応 (desktop-lite) | E-02 | ○ |
| C-03 | Dev Container は Rust toolchain をサポート | E-02 | ○ |
| C-04 | Dev Container のメモリ要件は 9GB以上 | E-02 | ○ |
| C-05 | Dev Container はポート 6080, 5901 を公開 | E-02 | ○ |
| C-06 | npm キャッシュ用に vscode-dev ボリュームを使用 | E-02 | ○ |
| C-07 | Azure DevOps で Windows ビルドに 1es-windows-2022-x64 プールを使用 | E-04 | ○ |
| C-08 | Azure DevOps で Linux ビルドに 1es-ubuntu-22.04-x64 プールを使用 | E-04 | ○ |
| C-09 | Azure DevOps で macOS ビルドに AcesShared プールを使用 | E-04 | ○ |
| C-10 | Alpine ビルドに onebranch.azurecr.io/linux/ubuntu-2004-arm64 コンテナを使用 | E-04 | ○ |
| C-11 | GitHub Actions で self-hosted runner (1es-vscode-oss-ubuntu-22.04-x64) を使用 | E-08 | ○ |
| C-12 | Azure Key Vault (vscode-build-secrets) からシークレットを取得 | E-05, E-06, E-07 | ○ |
| C-13 | Azure Key Vault (vscode-esrp) からコード署名シークレットを取得 | E-06 | ○ |
| C-14 | Azure Blob Storage (vscodeesrp) をステージングに使用 | E-04 | ○ |
| C-15 | Azure Blob Storage (vscodeweb) を Web 版に使用 | E-05, E-07 | ○ |
| C-16 | Azure Cosmos DB (vscode.documents.azure.com) を使用 | E-04 | ○ |
| C-17 | PRSS CDN (vscode.download.prss.microsoft.com) を使用 | E-04 | ○ |
| C-18 | npm install は5回リトライ | E-05, E-07, E-08 | ○ |
| C-19 | publish タスクは3回リトライ | E-06 | ○ |
| C-20 | 定期ビルドは月〜金 7:00 と 19:00 に実行 | E-04 | ○ |
| C-21 | Electron バージョン 39.2.7 を使用 | E-10 | ○ |
| C-22 | TypeScript バージョン 6.0.0-dev を使用 | E-10 | ○ |
| C-23 | Playwright バージョン 1.56.1 を使用 | E-10 | ○ |
| C-24 | Snap パッケージの base は core20 | E-09 | ○ |
| C-25 | Snap パッケージの confinement は classic | E-09 | ○ |
| C-26 | セキュリティスキャンに TSA, BinSkim, CodeQL, CredScan, ESLint を使用 | E-04 | ○ |
| C-27 | Azure Blob Storage は 99.9% SLA、ZRS を使用 | **根拠なし** | △ |
| C-28 | CDN は 99.9% SLA を提供 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Azure Blob Storage および CDN の SLA・冗長性設定はコードベースから直接確認できない
  - 候補：Azure公式ドキュメント / Azure Portal設定 / 運用チームへの確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体として信頼度は高く、主要なインフラ構成はコードから直接確認可能
- **1: 中リスク** - SLA・可用性に関する具体的な数値は Azure サービスの設定に依存するため、運用チームへの確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Dev Container 設定 (Dockerfile, devcontainer.json) が最新のプロジェクト要件を反映しているか確認
- [ ] Azure DevOps パイプライン設定 (product-build.yml) のプール名が現行環境と一致しているか確認
- [ ] Azure Key Vault 名 (vscode-build-secrets, vscode-esrp) が実際の運用環境と一致しているか確認
- [ ] Azure Blob Storage アカウント名 (vscodeesrp, vscodeweb) が実際の運用環境と一致しているか確認
- [ ] CDN URL (vscode.download.prss.microsoft.com) が実際の配布 URL と一致しているか確認
- [ ] セキュリティスキャン設定が SDL 要件を満たしているか確認
- [ ] Azure サービスの SLA・冗長性設定を Azure Portal または運用ドキュメントで確認
