# インフラ構成図

## 全体構成図

```mermaid
flowchart TB
    subgraph DevEnv["開発環境"]
        LocalDev["ローカル開発環境<br/>(Windows/macOS/Linux)"]
        DevContainer["Dev Containers<br/>(GitHub Codespaces)"]
    end

    subgraph SourceControl["ソースコード管理"]
        GitHub["GitHub<br/>microsoft/vscode"]
    end

    subgraph CICD["CI/CD パイプライン"]
        subgraph GitHubActions["GitHub Actions"]
            PR_CI["PR検証"]
            TestRunner["テストランナー<br/>(Electron/Browser/Remote)"]
        end

        subgraph AzureDevOps["Azure DevOps Pipelines"]
            Compile["Compile Stage"]
            CompileCLI["CompileCLI Stage"]
            Windows["Windows Stage<br/>(x64/arm64)"]
            Linux["Linux Stage<br/>(x64/arm64/armhf)"]
            Alpine["Alpine Stage<br/>(x64/arm64)"]
            macOS["macOS Stage<br/>(x64/arm64/universal)"]
            Web["Web Stage"]
            Publish["Publish Stage"]
            Release["Release Stage"]
        end
    end

    subgraph BuildAgents["ビルドエージェント"]
        WinAgent["1es-windows-2022-x64"]
        LinuxAgent["1es-ubuntu-22.04-x64"]
        macOSAgent["AcesShared (macOS)"]
        AlpineContainer["Alpine Container<br/>(onebranch.azurecr.io)"]
    end

    subgraph SecretMgmt["シークレット管理"]
        KeyVault1["Azure Key Vault<br/>(vscode-build-secrets)"]
        KeyVault2["Azure Key Vault<br/>(vscode-esrp)"]
    end

    subgraph Artifacts["成果物管理"]
        BlobStorage1["Azure Blob Storage<br/>(vscodeesrp)"]
        BlobStorage2["Azure Blob Storage<br/>(vscodeweb)"]
        CosmosDB["Azure Cosmos DB<br/>(vscode.documents.azure.com)"]
    end

    subgraph Distribution["配布"]
        CDN["PRSS CDN<br/>(vscode.download.prss.microsoft.com)"]
        NPM["npm Registry"]
        Snap["Snap Store"]
    end

    subgraph ExternalServices["外部サービス"]
        ESRP["ESRP<br/>(コード署名)"]
        Telemetry["Microsoft 1DS<br/>(テレメトリ)"]
        AzureArtifacts["Azure Artifacts<br/>(npm/Cargo)"]
    end

    %% 接続
    LocalDev --> GitHub
    DevContainer --> GitHub
    GitHub --> PR_CI
    GitHub --> Compile

    PR_CI --> TestRunner

    Compile --> Windows
    Compile --> Linux
    Compile --> Alpine
    Compile --> macOS
    Compile --> Web
    CompileCLI --> Windows
    CompileCLI --> Linux
    CompileCLI --> Alpine
    CompileCLI --> macOS

    Windows --> WinAgent
    Linux --> LinuxAgent
    macOS --> macOSAgent
    Alpine --> AlpineContainer

    WinAgent --> KeyVault1
    LinuxAgent --> KeyVault1
    macOSAgent --> KeyVault1

    Windows --> Publish
    Linux --> Publish
    Alpine --> Publish
    macOS --> Publish
    Web --> Publish

    Publish --> KeyVault2
    Publish --> ESRP
    Publish --> BlobStorage1
    Publish --> Release

    Web --> BlobStorage2

    Release --> CDN
    BlobStorage1 --> CDN

    AzureArtifacts --> Compile
    Publish --> CosmosDB
```

## CI/CD パイプライン詳細

```mermaid
flowchart LR
    subgraph Trigger["トリガー"]
        Push["Push (main/release/*)"]
        Schedule["スケジュール<br/>(平日 7:00/19:00)"]
        PR["Pull Request"]
    end

    subgraph Stages["ステージ"]
        direction TB
        CompileStage["Compile<br/>(macOS Pool)"]
        CLIStage["CompileCLI<br/>(並列)"]
        APIScan["APIScan<br/>(Windows)"]
        NodeModules["node_modules<br/>(CI Build時)"]

        WinStage["Windows Stage"]
        LinuxStage["Linux Stage"]
        AlpineStage["Alpine Stage"]
        macOSStage["macOS Stage"]
        WebStage["Web Stage"]

        PublishStage["Publish Stage"]
        ReleaseStage["Release Stage"]
    end

    subgraph Jobs["主要ジョブ"]
        WinBuild["Windows Build<br/>(x64/arm64)"]
        WinCLISign["CLI Sign"]
        LinuxBuild["Linux Build<br/>(x64/arm64/armhf)"]
        SnapBuild["Snap Build"]
        macOSBuild["macOS Build<br/>(x64/arm64)"]
        UniversalBuild["Universal Build"]
        WebBuild["Web Build"]
    end

    Push --> CompileStage
    Schedule --> CompileStage
    PR --> CompileStage

    Push --> CLIStage

    CompileStage --> WinStage
    CompileStage --> LinuxStage
    CompileStage --> AlpineStage
    CompileStage --> macOSStage
    CompileStage --> WebStage

    CLIStage --> WinStage
    CLIStage --> LinuxStage
    CLIStage --> AlpineStage
    CLIStage --> macOSStage

    WinStage --> WinBuild
    WinStage --> WinCLISign
    LinuxStage --> LinuxBuild
    LinuxStage --> SnapBuild
    macOSStage --> macOSBuild
    macOSStage --> UniversalBuild
    WebStage --> WebBuild

    WinBuild --> PublishStage
    LinuxBuild --> PublishStage
    macOSBuild --> PublishStage
    WebBuild --> PublishStage

    PublishStage --> ReleaseStage
```

## 開発環境構成

```mermaid
flowchart TB
    subgraph DevContainer["Dev Container (GitHub Codespaces)"]
        BaseImage["Base Image<br/>mcr.microsoft.com/devcontainers/<br/>typescript-node:22-bookworm"]

        subgraph Features["Dev Container Features"]
            DesktopLite["ghcr.io/devcontainers/features/<br/>desktop-lite:1"]
            RustFeature["ghcr.io/devcontainers/features/<br/>rust:1"]
        end

        subgraph InstalledPackages["インストール済みパッケージ"]
            NodeGyp["node-gyp"]
            VscodeInsiders["code-insiders"]
            LibSecret["libsecret-1-dev"]
            LibXkb["libxkbfile-dev"]
            LibKrb5["libkrb5-dev"]
        end

        subgraph Ports["公開ポート"]
            VNCWeb["6080: VNC Web Client (noVNC)"]
            VNCTCP["5901: VNC TCP"]
        end

        subgraph Volumes["ボリューム"]
            VscodeDev["vscode-dev<br/>(npm キャッシュ共有)"]
        end
    end

    subgraph Requirements["ホスト要件"]
        Memory["メモリ: 9GB以上"]
    end

    BaseImage --> Features
    BaseImage --> InstalledPackages
    DevContainer --> Ports
    DevContainer --> Volumes
    Requirements --> DevContainer
```

## セキュリティスキャン構成

```mermaid
flowchart LR
    subgraph Source["ソースコード"]
        TS["TypeScript"]
        JS["JavaScript"]
        Rust["Rust (CLI)"]
    end

    subgraph Artifacts["ビルド成果物"]
        EXE["*.exe"]
        DLL["*.dll"]
        Node["*.node"]
    end

    subgraph Scans["セキュリティスキャン"]
        TSA["TSA<br/>(Trust Service Automation)"]
        BinSkim["BinSkim<br/>(バイナリ解析)"]
        CodeQL["CodeQL<br/>(ソースコード解析)"]
        CredScan["CredScan<br/>(認証情報検出)"]
        ESLint["ESLint<br/>(JSセキュリティ)"]
        ComponentDetection["Component Detection<br/>(依存関係)"]
    end

    subgraph Config["設定ファイル"]
        TSAConfig["build/azure-pipelines/<br/>config/tsaoptions.json"]
        CredScanConfig["build/azure-pipelines/<br/>config/CredScanSuppressions.json"]
        ESLintIgnore[".eslint-ignore"]
    end

    Source --> CodeQL
    Source --> CredScan
    Source --> ESLint
    Source --> ComponentDetection

    Artifacts --> TSA
    Artifacts --> BinSkim

    TSAConfig --> TSA
    CredScanConfig --> CredScan
    ESLintIgnore --> ESLint
```

## 成果物配布フロー

```mermaid
flowchart TB
    subgraph Build["ビルド成果物"]
        WinArtifact["Windows<br/>(exe/msi/zip)"]
        LinuxArtifact["Linux<br/>(deb/rpm/tar.gz)"]
        SnapArtifact["Snap<br/>(.snap)"]
        macOSArtifact["macOS<br/>(.dmg/zip)"]
        WebArtifact["Web<br/>(tar.gz)"]
    end

    subgraph Signing["署名"]
        ESRP["ESRP Service"]
        CodeSign["Windows Code Signing"]
        Notarization["macOS Notarization"]
    end

    subgraph Storage["ストレージ"]
        StagingBlob["Azure Blob Storage<br/>(vscodeesrp)<br/>ステージング"]
        WebBlob["Azure Blob Storage<br/>(vscodeweb)<br/>Web版"]
    end

    subgraph CDN_Dist["CDN配布"]
        PRSS["PRSS CDN<br/>https://vscode.download.<br/>prss.microsoft.com/dbazure/download"]
    end

    subgraph PackageManagers["パッケージマネージャー"]
        NPMPkg["npm<br/>(Monaco Editor等)"]
        SnapStore["Snap Store"]
    end

    WinArtifact --> ESRP
    macOSArtifact --> ESRP

    ESRP --> CodeSign
    ESRP --> Notarization

    CodeSign --> StagingBlob
    Notarization --> StagingBlob
    LinuxArtifact --> StagingBlob
    SnapArtifact --> SnapStore
    WebArtifact --> WebBlob

    StagingBlob --> PRSS
    WebBlob --> PRSS
```
