# インフラ設計書

## 概要

本ドキュメントは、Visual Studio Code（VS Code）プロジェクトのインフラストラクチャ設計について記載する。VS Codeはオープンソースのコードエディタであり、Microsoft社が開発・運用を行っている。本プロジェクトは、Windows、macOS、Linux、Webの各プラットフォーム向けにビルド・配布されるマルチプラットフォームアプリケーションである。

## システム構成

### 全体構成

VS Codeプロジェクトのインフラは、以下の主要コンポーネントで構成される:

1. **開発環境**: GitHub Codespaces / Dev Containers を利用した開発環境
2. **CI/CDパイプライン**: Azure DevOps Pipelines と GitHub Actions を組み合わせたビルド・テスト・デプロイ自動化
3. **成果物配布**: Azure Blob Storage、CDN、各種パッケージマネージャー

```
┌─────────────────────────────────────────────────────────────────────────┐
│                         開発者環境                                        │
│  ┌──────────────────┐  ┌───────────────────────────────────────────────┐│
│  │  ローカル開発      │  │  GitHub Codespaces / Dev Containers          ││
│  │  (Windows/Mac/    │  │  - Node.js 22 (typescript-node:22-bookworm)  ││
│  │   Linux)          │  │  - Rust toolchain                            ││
│  └──────────────────┘  │  - VNC対応 (desktop-lite)                     ││
│                        └───────────────────────────────────────────────┘│
└───────────────────────────────────────────────────────────────────────────┘
                                    │
                                    ▼
┌─────────────────────────────────────────────────────────────────────────┐
│                      ソースコード管理                                     │
│                  GitHub (microsoft/vscode)                              │
└───────────────────────────────────────────────────────────────────────────┘
                                    │
                    ┌───────────────┴───────────────┐
                    ▼                               ▼
┌─────────────────────────────┐     ┌─────────────────────────────────┐
│  GitHub Actions             │     │  Azure DevOps Pipelines         │
│  - PR検証                    │     │  - 本番ビルド                    │
│  - テスト自動化              │     │  - マルチプラットフォームビルド    │
│  - Monaco Editor公開         │     │  - 署名・公開                    │
└─────────────────────────────┘     └─────────────────────────────────────┘
                                                    │
                                    ┌───────────────┴───────────────┐
                                    ▼                               ▼
                    ┌──────────────────────────┐  ┌─────────────────────────┐
                    │  Azure Blob Storage      │  │  CDN (PRSS)             │
                    │  - vscodeesrp            │  │  - vscode.download.     │
                    │  - vscodeweb             │  │    prss.microsoft.com   │
                    └──────────────────────────┘  └─────────────────────────────┘
```

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Azure DevOps Agent (Windows) | Windows x64/arm64 ビルド | 1es-windows-2022-x64 プール | オートスケール |
| Azure DevOps Agent (Linux) | Linux x64/arm64/armhf ビルド | 1es-ubuntu-22.04-x64 プール | オートスケール |
| Azure DevOps Agent (macOS) | macOS x64/arm64/universal ビルド | AcesShared プール | オートスケール |
| Azure DevOps Agent (Alpine) | Alpine Linux ビルド | onebranch.azurecr.io/linux/ubuntu-2004-arm64 コンテナ | オンデマンド |
| GitHub Actions Runner | PR検証・テスト | 1es-vscode-oss-ubuntu-22.04-x64 (self-hosted) | オートスケール |

### ネットワーク構成

本プロジェクトはパブリッククラウドサービスを利用しており、専用のオンプレミスネットワークは存在しない。主要な通信経路は以下の通り:

1. **開発者 → GitHub**: HTTPS経由でのソースコード操作
2. **CI/CD → Azure Key Vault**: シークレット取得（azureSubscription: vscode）
3. **CI/CD → NPM Registry**: パッケージ取得（Azure Artifacts: monacotools/Monaco/_packaging/vscode）
4. **CI/CD → Azure Blob Storage**: 成果物アップロード
5. **エンドユーザー → CDN**: ダウンロード（PRSS CDN経由）

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Node.js | .nvmrc で指定（22系） | ビルド・テスト実行環境 |
| Electron | 39.2.7 | デスクトップアプリケーションフレームワーク |
| TypeScript | 6.0.0-dev | ソースコードコンパイル |
| Rust | 1.85 (GitHub Actions) | CLI ビルド |
| npm | 最新 | パッケージ管理 |
| Gulp | 4.0.0 | ビルドタスク自動化 |
| Mocha | 10.8.2 | ユニットテスト |
| Playwright | 1.56.1 | ブラウザテスト |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理・Issue管理・PR管理 | HTTPS/API |
| Azure DevOps | CI/CDパイプライン | Azure Service Connection |
| Azure Key Vault (vscode-build-secrets) | ビルドシークレット管理 | Azure AD認証 |
| Azure Key Vault (vscode-esrp) | コード署名シークレット | Azure AD認証 |
| Azure Blob Storage (vscodeesrp) | ビルド成果物ステージング | Azure AD認証 |
| Azure Blob Storage (vscodeweb) | Web版ソースマップ・CDNアップロード | Azure AD認証 |
| Azure Cosmos DB | ビルドメタデータ管理 | vscode.documents.azure.com |
| ESRP (Enterprise Services Release Pipeline) | コード署名・Notarization | ESRP Service Connection |
| Microsoft 1DS | テレメトリ収集 | @microsoft/1ds-core-js, @microsoft/1ds-post-js |
| npm Registry (Azure Artifacts) | プライベートパッケージ | NPM Authentication |
| Cargo Registry (Azure Artifacts) | Rust依存関係 | Cargo Authentication |

## スケーリング設計

### ビルドエージェントのスケーリング

Azure DevOps の 1ES (One Engineering System) プールを使用し、ビルド需要に応じた自動スケーリングを実現:

- **1es-windows-2022-x64**: Windowsビルド用
- **1es-ubuntu-22.04-x64**: Linuxビルド用
- **AcesShared (macOS)**: macOSビルド用

ビルドパイプラインは並列実行をサポートし、以下のステージを同時に実行可能:
- Compile
- CompileCLI
- node_modules
- APIScan

### CDN スケーリング

PRSS CDN (https://vscode.download.prss.microsoft.com) を使用し、グローバルなダウンロード配信を実現。Azure CDN のエッジサーバーにより自動スケーリング。

## 可用性設計

### CI/CDパイプラインの冗長性

1. **複数リージョン対応**: Azure DevOps エージェントプールは複数リージョンに分散
2. **リトライ機構**: npm install は5回リトライ、publish タスクは3回リトライ
3. **キャッシュ**: node_modules キャッシュにより、依存関係取得失敗時のフォールバック

### 配布システムの可用性

1. **Azure Blob Storage**: 99.9% SLA、ゾーン冗長ストレージ (ZRS)
2. **CDN**: 99.9% SLA、グローバルエッジキャッシュ

### スケジュールビルド

定期ビルドによる継続的な品質確認:
- 月〜金 7:00 (UTC+0 5:00)
- 月〜金 19:00 (UTC+0 17:00)

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git (GitHub) | コミット毎 | 無期限 |
| ビルド成果物 | Azure Blob Storage | ビルド毎 | リリースポリシーに準拠 |
| シークレット | Azure Key Vault | Azure管理 | Azure Key Vault ポリシーに準拠 |
| パイプライン定義 | Git (コードとして管理) | コミット毎 | 無期限 |

## 監視設計

### CI/CD監視

1. **Azure DevOps ダッシュボード**: ビルド成功率・実行時間の可視化
2. **GitHub Actions**: ワークフローステータス監視
3. **コンポーネント検出**: ComponentGovernanceComponentDetection によるセキュリティスキャン

### セキュリティスキャン

| ツール | 対象 | 実行タイミング |
| --- | --- | --- |
| TSA (Trust Service Automation) | セキュリティ問題検出 | 毎ビルド |
| BinSkim | Windows実行ファイル・DLL・node | 毎ビルド |
| CodeQL | ソースコード解析 | 設定に依存 |
| CredScan | 認証情報漏洩検出 | 毎ビルド |
| ESLint | JavaScriptセキュリティ | 毎ビルド |

### テレメトリ

- **Microsoft 1DS**: アプリケーションテレメトリ収集
- **テレメトリ抽出**: build/azure-pipelines/common/extract-telemetry.sh によるイベント一覧生成

## 備考

### 開発環境要件

Dev Containers を使用した開発環境は以下の要件を持つ:
- メモリ: 9GB以上
- ポート: 6080 (VNC web client), 5901 (VNC TCP)
- ボリューム: vscode-dev (npm キャッシュ共有)

### 対応プラットフォーム

本プロジェクトは以下のプラットフォーム向けにビルドを生成:
- Windows x64, arm64
- Linux x64, arm64, armhf
- Alpine x64, arm64
- macOS x64, arm64, universal
- Web (ブラウザ)

### Snap パッケージ

Linux 向けに Snap パッケージも提供:
- Base: core20
- Confinement: classic
- Compression: lzo
