---
generated_at: 2026-01-27 11:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **ログ保持期間**：運用設定に依存するため根拠不足
  2. **テレメトリのプライバシー設定詳細**：設定ファイルに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/base/common/oauth.ts`
- E-02: `src/vs/workbench/api/browser/mainThreadAuthentication.ts`
- E-03: `src/vs/base/node/crypto.ts`
- E-04: `src/vs/base/common/hash.ts`
- E-05: `src/vs/base/browser/domSanitize.ts`
- E-06: `src/vs/base/browser/dompurify/dompurify.js`
- E-07: `src/vs/base/common/validation.ts`
- E-08: `src/vs/code/electron-main/app.ts`
- E-09: `src/vs/server/node/webClientServer.ts`
- E-10: `src/vs/workbench/api/common/extHostWebview.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OAuth 2.0認証をサポート | E-01 | ○ |
| C-02 | OpenID Connect認証をサポート | E-01 | ○ |
| C-03 | Device Code Flow (RFC 8628)をサポート | E-01 | ○ |
| C-04 | Dynamic Client Registration (RFC 7591)をサポート | E-01 | ○ |
| C-05 | stateパラメータによるCSRF防止 | E-01 | ○ |
| C-06 | Cookie設定（SameSite=Lax, maxAge=7日） | E-09 | ○ |
| C-07 | 拡張機能のスコープベースアクセス制御 | E-02 | ○ |
| C-08 | Webviewの制限付きパーミッション | E-08 | ○ |
| C-09 | setPermissionRequestHandlerによるパーミッション制御 | E-08 | ○ |
| C-10 | setPermissionCheckHandlerによるパーミッション検証 | E-08 | ○ |
| C-11 | 認可サーバーとのHTTPS通信 | E-01 | ○ |
| C-12 | PRSS CDNに対するCORS許可 | E-08 | ○ |
| C-13 | SVGリクエストのフィルタリング | E-08 | ○ |
| C-14 | SHA-256によるファイルチェックサム | E-03 | ○ |
| C-15 | SHA-1によるハッシュ計算（StringSHA1） | E-04 | ○ |
| C-16 | JWTトークンのクレーム抽出 | E-01 | ○ |
| C-17 | DOMPurify 3.2.7によるHTMLサニタイズ | E-05, E-06 | ○ |
| C-18 | 許可タグ・属性のホワイトリスト | E-05 | ○ |
| C-19 | リンクプロトコルのバリデーション | E-05 | ○ |
| C-20 | 型ベースの入力バリデーション | E-07 | ○ |
| C-21 | WebviewのCSPソース生成 | E-10 | ○ |
| C-22 | CSP欠落時の警告出力 | E-10 | ○ |
| C-23 | 認証イベントのテレメトリ記録 | E-02 | ○ |
| C-24 | will-navigateイベントでのナビゲーション防止 | E-08 | ○ |
| C-25 | setWindowOpenHandlerによるウィンドウ制御 | E-08 | ○ |
| C-26 | UNCパスアクセス制御（Windows） | E-08 | ○ |
| C-27 | ログ保持期間の設定 | **根拠なし** | △ |
| C-28 | テレメトリのプライバシー設定詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **ログ保持期間**: コードベースにログローテーション設定が明示的に記載されていない
  - 候補：運用ドキュメント / Electronのログ設定 / OS側のログローテーション設定
- **テレメトリのプライバシー設定詳細**: ユーザー設定に依存するため、設定スキーマの確認が必要
  - 候補：settings.json スキーマ / package.json contributes / プライバシーポリシードキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証・認可の基本実装は十分に根拠あり
- 0: 低リスク - 入出力対策（XSS、サニタイズ）は明確な実装あり
- 0: 低リスク - 暗号化機能は標準ライブラリ使用
- 1: 中リスク - ログ保持期間が運用設定に依存
- 1: 中リスク - テレメトリ設定の詳細は外部ドキュメント参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth 2.0認証フローの実装が要件を満たしているか確認
- [ ] DOMPurifyの設定（許可タグ・属性）がセキュリティポリシーに適合しているか確認
- [ ] Electronセキュリティ設定がElectronセキュリティガイドラインに準拠しているか確認
- [ ] ログ保持期間について運用チームと確認
- [ ] テレメトリのプライバシー設定が法規制（GDPR等）に適合しているか確認
- [ ] UNCパスアクセス制御の設定がセキュリティポリシーに適合しているか確認
