---
generated_at: 2026-01-27 13:36:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な目標値がプロジェクト設定ファイルに見つからない
  2. **性能テストの詳細**：性能テストの具体的な基準・閾値が不明
  3. **受入テストの詳細プロセス**：Sanity Testの詳細な実行プロセスが不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - テストスクリプト定義、依存パッケージ
- E-02: `test/.mocharc.json` - Mocha設定（TDD UI、タイムアウト10秒）
- E-03: `test/monaco/.mocharc.json` - Monaco Mocha設定（BDD UI）
- E-04: `.github/workflows/pr.yml` - メインCIワークフロー定義
- E-05: `.github/workflows/pr-linux-test.yml` - Linuxテストワークフロー
- E-06: `.github/workflows/pr-darwin-test.yml` - macOSテストワークフロー
- E-07: `.github/workflows/pr-win32-test.yml` - Windowsテストワークフロー
- E-08: `test/README.md` - テストスイート概要
- E-09: `test/unit/README.md` - 単体テスト実行方法
- E-10: `test/smoke/README.md` - Smokeテスト実行方法・注意事項
- E-11: `test/smoke/package.json` - Smokeテスト依存関係
- E-12: `test/automation/package.json` - UI自動化ドライバー依存関係（axe-core含む）
- E-13: `src/vs/**/*.test.ts` - 単体テストファイル群（約800ファイル）
- E-14: `scripts/test.sh` - テスト実行スクリプト
- E-15: `scripts/test-integration.sh` - 結合テスト実行スクリプト
- E-16: `scripts/test-web-integration.sh` - Web結合テスト実行スクリプト
- E-17: `scripts/test-remote-integration.sh` - リモート結合テスト実行スクリプト
- E-18: `extensions/*/mocha.opts` - 拡張機能テスト設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テストフレームワークはMochaを使用 | E-01, E-02, E-03 | ○ |
| C-02 | Mochaバージョンは^10.8.2 | E-01 | ○ |
| C-03 | Playwrightをブラウザテストに使用 | E-01, E-05 | ○ |
| C-04 | Playwrightバージョンは^1.56.1 | E-01 | ○ |
| C-05 | Sinonをテストダブルに使用 | E-01 | ○ |
| C-06 | Sinonバージョンは^12.0.1 | E-01 | ○ |
| C-07 | Istanbulでカバレッジ測定 | E-01 | ○ |
| C-08 | axe-coreでアクセシビリティテスト | E-12 | ○ |
| C-09 | ESLintで静的解析 | E-01, E-04 | ○ |
| C-10 | tsecでセキュリティ静的解析 | E-01, E-04 | ○ |
| C-11 | mocha-junit-reporterでJUnit形式出力 | E-01 | ○ |
| C-12 | Mocha設定はTDD UI（test/） | E-02 | ○ |
| C-13 | Mocha設定はBDD UI（monaco/） | E-03 | ○ |
| C-14 | タイムアウト設定は10秒 | E-02, E-03 | ○ |
| C-15 | 単体テストはElectron環境で実行可能 | E-09, E-05 | ○ |
| C-16 | 単体テストはNode.js環境で実行可能 | E-01, E-05 | ○ |
| C-17 | 単体テストはブラウザ環境で実行可能 | E-09, E-05 | ○ |
| C-18 | ブラウザテストはChromiumで実行 | E-05, E-09 | ○ |
| C-19 | ブラウザテストはWebKitで実行 | E-06, E-09 | ○ |
| C-20 | GitHub Actionsでテスト自動化 | E-04, E-05, E-06, E-07 | ○ |
| C-21 | LinuxテストはUbuntu 22.04で実行 | E-05 | ○ |
| C-22 | macOSテストはmacos-14-xlargeで実行 | E-06 | ○ |
| C-23 | Windowsテストはself-hostedで実行 | E-07 | ○ |
| C-24 | 単体テストタイムアウトは15分 | E-05, E-06, E-07 | ○ |
| C-25 | ブラウザテストタイムアウトは30分 | E-05 | ○ |
| C-26 | 結合テストタイムアウトは20分 | E-05, E-06, E-07 | ○ |
| C-27 | Smokeテストタイムアウトは20分 | E-05, E-06, E-07 | ○ |
| C-28 | クラッシュダンプは失敗時に収集 | E-05, E-06, E-07 | ○ |
| C-29 | ログファイルは常時収集 | E-05, E-06, E-07 | ○ |
| C-30 | node_modulesキャッシュ機構が存在 | E-05, E-06, E-07 | ○ |
| C-31 | built-in extensionsキャッシュが存在 | E-05, E-06, E-07 | ○ |
| C-32 | テストは3 OS並列実行 | E-04 | ○ |
| C-33 | 各OSでElectron/Browser/Remote並列 | E-04 | ○ |
| C-34 | CLIテストはRust 1.85を使用 | E-04 | ○ |
| C-35 | 単体テストファイルは*.test.ts形式 | E-13 | ○ |
| C-36 | テストファイル数は約800以上 | E-13 | ○ |
| C-37 | test/unit/に単体テストランナー配置 | E-08 | ○ |
| C-38 | test/smoke/にSmokeテスト配置 | E-08, E-10 | ○ |
| C-39 | test/integration/に結合テスト配置 | E-08 | ○ |
| C-40 | test/sanity/にサニティテスト配置 | E-08 | ○ |
| C-41 | --coverageフラグでカバレッジ取得可能 | E-09 | ○ |
| C-42 | カバレッジ出力先は.build/coverage | E-09 | ○ |
| C-43 | カバレッジ目標値が明示的に設定されている | **根拠なし** | △ |
| C-44 | 性能テストの具体的な基準値 | **根拠なし** | △ |
| C-45 | 受入テストの詳細プロセスが定義されている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-43 カバレッジ目標値**: プロジェクト設定ファイル（package.json、CI設定等）に明示的なカバレッジ目標値の記載が見つからなかった
  - 候補：内部ドキュメント / CONTRIBUTING.md / チーム内規約
- **C-44 性能テストの基準値**: vscode-colorize-perf-testsの存在は確認できたが、具体的な閾値・基準の定義は未発見
  - 候補：パフォーマンステストコード内のアサーション / 内部ベンチマーク文書
- **C-45 受入テストプロセス**: Sanity Testの存在は確認できたが、詳細な実行プロセス・承認フローは未記載
  - 候補：リリースプロセス文書 / ENDGAME.md / 内部Wiki

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - テストツール・フレームワークの記述：package.jsonから直接抽出
- **0: 低リスク** - CI/CD設定の記述：GitHub Actionsワークフローファイルから直接抽出
- **0: 低リスク** - テストディレクトリ構成：実際のディレクトリ構造から確認
- **1: 中リスク** - カバレッジ目標：目標値が設定されていない可能性あり（要確認）
- **1: 中リスク** - 性能テスト基準：具体的な数値基準が不明（運用で確認要）
- **1: 中リスク** - 受入テストプロセス：詳細が不明確（リリースチームへの確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] テストツールのバージョンがpackage.jsonと一致しているか確認
- [ ] CI/CDワークフローのタイムアウト設定が最新のワークフローファイルと一致しているか確認
- [ ] カバレッジ目標について、プロジェクト内に別途定義がないか確認
- [ ] 性能テストの基準値について、vscode-colorize-perf-testsの実装を確認
- [ ] Sanity Test（受入テスト）の詳細プロセスについて、リリースチームに確認
- [ ] テストファイル数（約800）が最新のカウントと大きく乖離していないか確認
- [ ] 新しいテスト種別やツールがプロジェクトに追加されていないか確認
