# テスト方針書

## 概要

本ドキュメントは、Visual Studio Code（VS Code）プロジェクトのテスト方針を定義したものである。VS Codeはクロスプラットフォーム対応のコードエディタであり、Electron（デスクトップ）、ブラウザ、リモート環境の3つの実行環境をサポートしている。本方針は、これらすべての環境における品質保証を目的とし、テストレベル、テスト種別、テスト環境、テストツール、CI/CD連携について定義する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のモジュール・関数・クラスの動作検証。ビジネスロジック、ユーティリティ関数、データモデルの正確性を確認 | 開発者 |
| 結合テスト（Integration Tests） | 複数のモジュール・拡張機能間の連携動作検証。VS Code APIを介した拡張機能とコアの統合を確認 | 開発者/QAエンジニア |
| システムテスト（Smoke Tests） | エンドツーエンドでのアプリケーション全体の動作検証。主要なユーザーワークフローが正常に機能することを確認 | QAエンジニア |
| 受入テスト（Sanity Tests） | リリース前の健全性確認。リリースビルドが基本的な機能を満たしているかを最終確認 | QAエンジニア/リリースチーム |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | VS Codeの機能（エディタ、拡張機能、ターミナル、デバッガなど）が仕様通りに動作するかを検証 | 開発時・PR時・リリース前 |
| 回帰テスト | 既存機能がコード変更により影響を受けていないことを確認 | PR時・マージ後 |
| クロスプラットフォームテスト | Linux、macOS、Windowsの各OSで同一のテストが通過することを確認 | PR時（CI/CD） |
| クロスブラウザテスト | Chromium、WebKitでのブラウザ版VS Codeの動作を確認 | PR時（CI/CD） |
| 性能テスト | カラー化パフォーマンステストなど、特定の性能要件を満たすことを確認 | 定期的・リリース前 |
| セキュリティテスト | CodeQL、tsecによる静的解析でセキュリティ脆弱性を検出 | PR時（CI/CD） |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| Linux (Ubuntu 22.04 x64) | CI/CDでのElectron/Browser/Remote/CLIテスト実行 | Self-hosted runner (1es-vscode-oss-ubuntu-22.04-x64) |
| macOS 14 (ARM64) | CI/CDでのElectron/Browser/Remoteテスト実行 | GitHub Actions runner (macos-14-xlarge) |
| Windows Server 2022 (x64) | CI/CDでのElectron/Browser/Remoteテスト実行 | Self-hosted runner (1es-vscode-oss-windows-2022-x64) |
| ローカル開発環境 | 開発者による手動テスト実行 | Node.js + Electron + Playwright |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Mocha | 単体テスト・結合テストのテストランナー | ^10.8.2 |
| Playwright | ブラウザテスト自動化、Smoke/E2Eテスト | ^1.56.1 |
| Sinon | テストダブル（スタブ、モック、スパイ）の作成 | ^12.0.1 |
| Istanbul | コードカバレッジ測定 | ^3.2.0 (istanbul-lib-coverage) |
| axe-core | アクセシビリティテスト | ^4.10.2 |
| @vscode/test-electron | VS Code拡張機能のElectron環境テスト | ^2.4.0 |
| @vscode/test-web | VS Code拡張機能のWeb環境テスト | ^0.0.76 |
| @vscode/test-cli | VS Code拡張機能テストのCLIインターフェース | ^0.0.6 |
| ESLint | 静的コード解析 | ^9.36.0 |
| tsec | TypeScriptセキュリティ静的解析 | 0.2.7 |
| mocha-junit-reporter | JUnit形式でのテスト結果レポート出力 | ^2.2.1 |
| mocha-multi-reporters | 複数レポーター同時出力 | ^1.5.1 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値は設定されていない（--coverageフラグで計測可能） |
| 分岐カバレッジ | 明示的な目標値は設定されていない（Istanbulにより計測） |

**注記**: VS Codeプロジェクトでは、明示的なカバレッジ目標値は設定されていないが、`./scripts/test.sh --coverage`コマンドによりカバレッジレポートを生成し、`.build/coverage`ディレクトリに出力することが可能である。

## テストデータ

テストデータは以下の方法で準備される：

1. **インメモリファイルシステム**: `vs/platform/files/test/browser/inmemoryFileService.test.ts`などで使用される仮想ファイルシステム
2. **テストフィクスチャ**: 拡張機能テスト用のフィクスチャファイル（例: `extensions/css-language-features/server/test/linksTestFixtures/`）
3. **一時ディレクトリ**: `tmp`モジュールを使用した一時ファイル・ディレクトリの動的生成
4. **モックオブジェクト**: Sinonを使用したサービス・APIのモック化

## 不具合管理

1. **GitHub Issues**: すべての不具合はGitHub Issues（https://github.com/microsoft/vscode/issues）で管理
2. **クラッシュレポート**: テスト失敗時にクラッシュダンプが自動収集され、CI/CDアーティファクトとしてアップロード
3. **ログファイル**: テスト実行ログは`.build/logs`ディレクトリに保存され、失敗時にアーティファクトとして保存

## CI/CD連携

### GitHub Actions ワークフロー構成

VS Codeプロジェクトでは、以下のGitHub Actionsワークフローが構成されている：

| ワークフロー | トリガー | 内容 |
| --- | --- | --- |
| `pr.yml` | main/release/*へのPR | コンパイル、ハイジーン、各OS・環境でのテスト実行 |
| `pr-linux-test.yml` | pr.ymlから呼び出し | LinuxでのElectron/Browser/Remoteテスト |
| `pr-darwin-test.yml` | pr.ymlから呼び出し | macOSでのElectron/Browser/Remoteテスト |
| `pr-win32-test.yml` | pr.ymlから呼び出し | WindowsでのElectron/Browser/Remoteテスト |
| `pr-linux-cli-test.yml` | pr.ymlから呼び出し | Linux CLIテスト（Rust） |
| `monaco-editor.yml` | 関連 | Monaco Editorのテスト |

### テスト実行フロー

1. **Compile & Hygiene**: コードのコンパイル、ESLint、型チェック、ハイジーンチェック
2. **単体テスト（Electron）**: `./scripts/test.sh`でElectron環境内の単体テスト実行（タイムアウト: 15分）
3. **単体テスト（Node.js）**: `npm run test-node`でNode.js環境の単体テスト実行
4. **単体テスト（Browser）**: `npm run test-browser`でChromium/WebKit上の単体テスト実行（タイムアウト: 30分）
5. **結合テスト**: `./scripts/test-integration.sh`でAPI統合テスト実行（タイムアウト: 20分）
6. **Smokeテスト**: `npm run smoketest`でE2Eテスト実行（タイムアウト: 20分）

### 並列実行

- Linux/macOS/Windowsの各OSで並列にテストが実行される
- 各OS内でElectron/Browser/Remoteの3種類のテストが並列実行される
- キャッシュ機構（node_modules、built-in extensions）により実行時間を最適化

### アーティファクト管理

| アーティファクト | 保存条件 | 内容 |
| --- | --- | --- |
| クラッシュダンプ | テスト失敗時 | `.build/crashes`内のダンプファイル |
| Node Modules | テスト失敗時 | ネイティブモジュール（シンボル解析用） |
| ログファイル | 常時 | `.build/logs`内のテスト実行ログ |

## 備考

### テスト実行コマンド一覧

```bash
# 単体テスト（Electron環境）
./scripts/test.sh

# 単体テスト（Node.js環境）
npm run test-node

# 単体テスト（ブラウザ環境）
npm run test-browser -- --browser chromium --browser webkit

# 結合テスト
./scripts/test-integration.sh

# Web結合テスト
./scripts/test-web-integration.sh --browser chromium

# リモート結合テスト
./scripts/test-remote-integration.sh

# Smokeテスト
npm run smoketest

# カバレッジ付きテスト
./scripts/test.sh --coverage

# デバッグモードでのテスト
./scripts/test.sh --debug --glob "**/extHost*.test.js"
```

### テスト設定ファイル

- **Mocha設定**: `test/.mocharc.json`（TDD UI、タイムアウト10秒）
- **Monaco Mocha設定**: `test/monaco/.mocharc.json`（BDD UI、タイムアウト10秒）
- **拡張機能テスト設定**: 各拡張機能ディレクトリ内の`mocha.opts`

### テストファイル配置規則

- 単体テストファイルは`src/`内の各モジュールディレクトリに`*.test.ts`として配置
- テスト総数: 約800以上のテストファイル
- テストディレクトリ構成:
  - `test/unit/`: 単体テストランナー
  - `test/integration/`: 結合テスト
  - `test/smoke/`: Smokeテスト（E2E）
  - `test/sanity/`: サニティテスト
  - `test/automation/`: UI自動化ドライバー
  - `test/mcp/`: MCPテスト
  - `test/monaco/`: Monaco Editorテスト
