# ER図

## 概要

VS Codeのストレージシステムは、シンプルなKey-Value構造を採用しています。以下にSQLiteとIndexedDBそれぞれのER図を示します。

## SQLiteストレージ ER図

```mermaid
erDiagram
    ItemTable {
        TEXT key PK "ストレージキー（UNIQUE ON CONFLICT REPLACE）"
        BLOB value "ストレージ値"
    }
```

## IndexedDBストレージ ER図

```mermaid
erDiagram
    ItemTable_ObjectStore {
        String key PK "ストレージキー"
        String value "ストレージ値"
    }

    FileSystem_ObjectStore {
        String path PK "ファイルパス"
        Uint8Array content "ファイルコンテンツ"
    }
```

## ストレージアーキテクチャ全体図

```mermaid
flowchart TB
    subgraph Application["VS Code Application"]
        StorageService["IStorageService"]
    end

    subgraph Scopes["Storage Scopes"]
        AppScope["Application Scope<br/>-1"]
        ProfileScope["Profile Scope<br/>0"]
        WorkspaceScope["Workspace Scope<br/>1"]
    end

    subgraph Desktop["Desktop (Electron)"]
        SQLiteApp["SQLite DB<br/>state.vscdb<br/>(Application)"]
        SQLiteProfile["SQLite DB<br/>state.vscdb<br/>(Profile)"]
        SQLiteWorkspace["SQLite DB<br/>state.vscdb<br/>(Workspace)"]
    end

    subgraph Browser["Web Browser"]
        IDBApp["IndexedDB<br/>vscode-web-state-db-global"]
        IDBProfile["IndexedDB<br/>vscode-web-state-db-global-{profileId}"]
        IDBWorkspace["IndexedDB<br/>vscode-web-state-db-{workspaceId}"]
    end

    StorageService --> AppScope
    StorageService --> ProfileScope
    StorageService --> WorkspaceScope

    AppScope --> SQLiteApp
    AppScope --> IDBApp

    ProfileScope --> SQLiteProfile
    ProfileScope --> IDBProfile

    WorkspaceScope --> SQLiteWorkspace
    WorkspaceScope --> IDBWorkspace
```

## データフロー図

```mermaid
sequenceDiagram
    participant Client as クライアントコード
    participant StorageService as IStorageService
    participant Storage as Storage
    participant Cache as キャッシュ (Map)
    participant DB as Database<br/>(SQLite/IndexedDB)

    Note over Client,DB: データ書き込みフロー
    Client->>StorageService: store(key, value, scope, target)
    StorageService->>Storage: set(key, value)
    Storage->>Cache: cache.set(key, value)
    Storage->>Storage: pendingInserts.set(key, value)
    Note over Storage: 遅延書き込み (100ms後)
    Storage->>DB: updateItems({insert: pendingInserts})

    Note over Client,DB: データ読み取りフロー
    Client->>StorageService: get(key, scope)
    StorageService->>Storage: get(key)
    Storage->>Cache: cache.get(key)
    Cache-->>Storage: value
    Storage-->>StorageService: value
    StorageService-->>Client: value
```

## ストレージクラス階層図

```mermaid
classDiagram
    class IStorageDatabase {
        <<interface>>
        +onDidChangeItemsExternal Event
        +getItems() Promise~Map~
        +updateItems(request) Promise
        +optimize() Promise
        +close() Promise
    }

    class SQLiteStorageDatabase {
        -connection IDatabaseConnection
        -logger SQLiteStorageDatabaseLogger
        +getItems() Promise~Map~
        +updateItems(request) Promise
        +optimize() Promise
        +close() Promise
        +checkIntegrity(full) Promise
    }

    class IndexedDBStorageDatabase {
        -indexedDB IndexedDB
        -broadcastChannel BroadcastDataChannel
        +getItems() Promise~Map~
        +updateItems(request) Promise
        +optimize() Promise
        +close() Promise
        +clear() Promise
    }

    class InMemoryStorageDatabase {
        -items Map
        +getItems() Promise~Map~
        +updateItems(request) Promise
        +optimize() Promise
        +close() Promise
    }

    class Storage {
        -database IStorageDatabase
        -cache Map
        -pendingInserts Map
        -pendingDeletes Set
        +get(key) String
        +set(key, value) Promise
        +delete(key) Promise
        +flush() Promise
        +close() Promise
    }

    IStorageDatabase <|.. SQLiteStorageDatabase
    IStorageDatabase <|.. IndexedDBStorageDatabase
    IStorageDatabase <|.. InMemoryStorageDatabase
    Storage --> IStorageDatabase
```

## データベース物理配置図

```mermaid
flowchart LR
    subgraph UserDataDir["ユーザーデータディレクトリ"]
        subgraph GlobalStorage["globalStorageHome"]
            AppDB["state.vscdb<br/>(Application Storage)"]
            subgraph ProfileDir["profiles/{profileId}"]
                ProfileDB["state.vscdb<br/>(Profile Storage)"]
            end
        end

        subgraph WorkspaceStorage["workspaceStorageHome"]
            subgraph WorkspaceDir["{workspaceId}"]
                WorkspaceDB["state.vscdb<br/>(Workspace Storage)"]
                WorkspaceMeta["workspace.json<br/>(メタデータ)"]
            end
        end
    end
```

## 備考

- VS Codeのストレージは意図的にシンプルなKey-Value構造を採用しています
- 複雑なリレーションシップは存在せず、すべてのデータは単一テーブル/ObjectStoreに格納されます
- 値はJSON文字列としてシリアライズされることが多く、アプリケーション層で複雑なデータ構造を管理しています
