---
generated_at: 2026-01-27 11:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **ファイルシステムObjectStoreの詳細構造**：実装の詳細確認が必要
  2. **バックアップタイミングの正確性**：運用ドキュメントでの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/base/parts/storage/node/storage.ts` - SQLiteStorageDatabase実装
- E-02: `src/vs/base/browser/indexedDB.ts` - IndexedDBラッパークラス
- E-03: `src/vs/platform/files/browser/indexedDBFileSystemProvider.ts` - IndexedDBファイルシステム実装
- E-04: `src/vs/workbench/services/storage/browser/storageService.ts` - ブラウザストレージサービス
- E-05: `src/vs/platform/storage/common/storage.ts` - ストレージインターフェース定義
- E-06: `src/vs/base/parts/storage/common/storage.ts` - Storage基底クラス
- E-07: `src/vs/platform/storage/electron-main/storageMain.ts` - Electronメインプロセスストレージ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デスクトップ版はSQLite (@vscode/sqlite3) を使用 | E-01 (line 13, 318) | ○ |
| C-02 | Web版はIndexedDBを使用 | E-02, E-04 | ○ |
| C-03 | ItemTableのスキーマ (key TEXT UNIQUE, value BLOB) | E-01 (line 331) | ○ |
| C-04 | IndexedDBのObject Store名は「ItemTable」 | E-04 (line 320) | ○ |
| C-05 | 3つのストレージスコープ (APPLICATION, PROFILE, WORKSPACE) | E-05 (line 223-239) | ○ |
| C-06 | StorageScopeの値 (-1, 0, 1) | E-05 (line 223-239) | ○ |
| C-07 | StorageTargetの値 (USER=0, MACHINE=1) | E-05 (line 241-252) | ○ |
| C-08 | IS_NEW_KEY = `__$__isNewStorageMarker` | E-05 (line 16) | ○ |
| C-09 | TARGET_KEY = `__$__targetStorageMarker` | E-05 (line 17) | ○ |
| C-10 | SQLiteのINSERT文 (ON CONFLICT DO UPDATE) | E-01 (line 107) | ○ |
| C-11 | SQLiteのMAX_HOST_PARAMETERS = 256 | E-01 (line 39) | ○ |
| C-12 | SQLITE_BUSY_OPEN_TIMEOUT = 2000ms | E-01 (line 38) | ○ |
| C-13 | SQLiteのVACUUMコマンド対応 | E-01 (line 160) | ○ |
| C-14 | SQLiteの整合性チェック (PRAGMA integrity_check) | E-01 (line 246) | ○ |
| C-15 | IndexedDBデータベースプレフィックス「vscode-web-state-db-」 | E-04 (line 319) | ○ |
| C-16 | アプリケーションストレージID = 'global' | E-04 (line 295) | ○ |
| C-17 | プロファイルストレージID = `global-{profileId}` | E-04 (line 299) | ○ |
| C-18 | デフォルトフラッシュ間隔 60秒 (デスクトップ) | E-05 (line 319) | ○ |
| C-19 | ブラウザフラッシュ間隔 5秒 | E-04 (line 24) | ○ |
| C-20 | Storage.DEFAULT_FLUSH_DELAY = 100ms | E-06 (line 117) | ○ |
| C-21 | ストレージファイル名 = state.vscdb | E-07 (line 285, 353) | ○ |
| C-22 | ワークスペースメタデータファイル = workspace.json | E-07 (line 354) | ○ |
| C-23 | バックアップファイル拡張子 = .backup | E-01 (line 239) | ○ |
| C-24 | IndexedDBファイルシステムの詳細なデータ構造 | E-03 (部分的) | △ |
| C-25 | クロスウィンドウ同期にBroadcastChannel使用 | E-04 (line 340, 351-357) | ○ |

## 4) 不足情報（Unknown / Missing）
- **IndexedDBファイルシステムの完全な仕様**
  - ファイルシステムエミュレーション用のObjectStoreの詳細な仕様は、コードから推測した部分が含まれる
  - 候補：VS Code公式ドキュメント / 追加のソースコード調査

- **実際の運用におけるバックアップ動作**
  - コードベースからは正常クローズ時のバックアップ動作を確認
  - 実際の運用環境での動作確認が推奨される

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ストレージスコープ・ターゲットの定義
- **0（低リスク）**: SQLiteテーブルスキーマ
- **0（低リスク）**: IndexedDBストア名・命名規則
- **1（中リスク）**: IndexedDBファイルシステムの詳細構造（実装詳細の変更可能性）
- **1（中リスク）**: パフォーマンス関連パラメータ（将来のバージョンで変更の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] SQLiteテーブル定義 (ItemTable) がコードと一致しているか確認
- [ ] IndexedDB Object Store名が実際の実装と一致しているか確認
- [ ] ストレージスコープの値が正しいか確認
- [ ] ストレージファイルパス (state.vscdb) が実際の配置と一致するか確認
- [ ] フラッシュ間隔の値が現行バージョンと一致しているか確認
- [ ] BroadcastChannelによるクロスウィンドウ同期の動作確認
