---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **copilot-setup-steps.yml**：ワークフロー内容の詳細が不明
  2. **no-engineering-system-changes.yml**：具体的な検出ロジックが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/product-build.yml`
- E-02: `build/azure-pipelines/product-compile.yml`
- E-03: `build/azure-pipelines/product-publish.yml`
- E-04: `build/azure-pipelines/product-release.yml`
- E-05: `build/azure-pipelines/publish-types/publish-types.yml`
- E-06: `build/azure-pipelines/distro-build.yml`
- E-07: `.github/workflows/pr.yml`
- E-08: `.github/workflows/monaco-editor.yml`
- E-09: `.github/workflows/telemetry.yml`
- E-10: `.github/workflows/pr-linux-test.yml`
- E-11: `.github/workflows/pr-darwin-test.yml`
- E-12: `.github/workflows/pr-win32-test.yml`
- E-13: `.github/workflows/pr-linux-cli-test.yml`
- E-14: `.github/workflows/no-package-lock-changes.yml`
- E-15: `.github/workflows/no-engineering-system-changes.yml`
- E-16: `.github/workflows/copilot-setup-steps.yml`
- E-17: `build/gulpfile.ts`
- E-18: `build/gulpfile.compile.ts`
- E-19: `build/gulpfile.hygiene.ts`
- E-20: `build/gulpfile.extensions.ts`
- E-21: `build/gulpfile.editor.ts`
- E-22: `build/npm/postinstall.ts`
- E-23: `build/npm/preinstall.ts`
- E-24: `build/npm/update-all-grammars.ts`
- E-25: `build/lib/builtInExtensions.ts`
- E-26: `package.json` (scripts section)
- E-27: `scripts/test.sh`
- E-28: `scripts/test-integration.sh`
- E-29: `scripts/test-remote-integration.sh`
- E-30: `scripts/test-web-integration.sh`
- E-31: `build/azure-pipelines/upload-sourcemaps.ts`
- E-32: `build/azure-pipelines/upload-nlsmetadata.ts`
- E-33: `build/azure-pipelines/upload-cdn.ts`
- E-34: `build/azure-pipelines/common/codesign.ts`
- E-35: `build/azure-pipelines/win32/product-build-win32.yml`
- E-36: `build/azure-pipelines/linux/product-build-linux.yml`
- E-37: `build/azure-pipelines/darwin/product-build-darwin.yml`
- E-38: `build/azure-pipelines/alpine/product-build-alpine.yml`
- E-39: `build/azure-pipelines/web/product-build-web.yml`
- E-40: `build/azure-pipelines/win32/product-build-win32-cli.yml`
- E-41: `build/azure-pipelines/linux/product-build-linux-cli.yml`
- E-42: `build/azure-pipelines/darwin/product-build-darwin-cli.yml`
- E-43: `build/azure-pipelines/alpine/product-build-alpine-cli.yml`
- E-44: `build/azure-pipelines/win32/sdl-scan-win32.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | product-build: VSCode製品のフルビルドパイプライン | E-01 | ○ |
| C-02 | product-compile: ソースコードのコンパイルステージ | E-02 | ○ |
| C-03 | product-publish: ビルド成果物の公開処理 | E-03 | ○ |
| C-04 | product-release: リリースビルドの公開処理 | E-04 | ○ |
| C-05 | publish-types: @types/vscode の公開パイプライン | E-05 | ○ |
| C-06 | distro-build: ディストリビューションビルド | E-06 | ○ |
| C-07 | pr.yml: プルリクエスト検証ワークフロー | E-07 | ○ |
| C-08 | monaco-editor.yml: Monaco Editorチェック | E-08 | ○ |
| C-09 | telemetry.yml: テレメトリメタデータチェック | E-09 | ○ |
| C-10 | pr-linux-test.yml: Linux向けテスト実行 | E-10 | ○ |
| C-11 | pr-darwin-test.yml: macOS向けテスト実行 | E-11 | ○ |
| C-12 | pr-win32-test.yml: Windows向けテスト実行 | E-12 | ○ |
| C-13 | pr-linux-cli-test.yml: Linux CLIテスト実行 | E-13 | ○ |
| C-14 | no-package-lock-changes.yml: package-lock変更チェック | E-14 | ○ |
| C-15 | no-engineering-system-changes.yml: エンジニアリングシステム変更チェック | E-15 | △ |
| C-16 | copilot-setup-steps.yml: Copilotセットアップ | E-16 | △ |
| C-17 | compile: フルコンパイルタスク | E-17 | ○ |
| C-18 | watch: 開発時ウォッチタスク | E-17 | ○ |
| C-19 | compile-build-with-mangling: CIビルド用コンパイル | E-18 | ○ |
| C-20 | compile-build-without-mangling: ローカル/PRビルド用コンパイル | E-18 | ○ |
| C-21 | hygiene: コード品質チェック | E-19 | ○ |
| C-22 | transpile-client-esbuild: SWCによる高速トランスパイル | E-17 | ○ |
| C-23 | compile-extensions: 拡張機能コンパイル | E-20 | ○ |
| C-24 | watch-extensions: 拡張機能ウォッチ | E-20 | ○ |
| C-25 | editor-distro: Monaco Editorディストリビューション | E-21 | ○ |
| C-26 | postinstall: 依存関係インストール後処理 | E-22 | ○ |
| C-27 | preinstall: 依存関係インストール前処理 | E-23 | ○ |
| C-28 | update-grammars: 文法定義更新 | E-24 | ○ |
| C-29 | download-builtin-extensions: 組み込み拡張機能ダウンロード | E-25 | ○ |
| C-30 | smoketest: スモークテスト実行 | E-26 | ○ |
| C-31 | test-browser: ブラウザユニットテスト | E-26 | ○ |
| C-32 | test-node: Nodeユニットテスト | E-26 | ○ |
| C-33 | test.sh/test.bat: ユニットテスト実行 | E-27 | ○ |
| C-34 | test-integration.sh/test-integration.bat: 統合テスト実行 | E-28 | ○ |
| C-35 | test-remote-integration.sh/test-remote-integration.bat: リモート統合テスト | E-29 | ○ |
| C-36 | test-web-integration.sh/test-web-integration.bat: Web統合テスト | E-30 | ○ |
| C-37 | upload-sourcemaps.ts: ソースマップアップロード | E-31 | ○ |
| C-38 | upload-nlsmetadata.ts: NLSメタデータアップロード | E-32 | ○ |
| C-39 | upload-cdn.ts: CDNへのアップロード | E-33 | ○ |
| C-40 | codesign.ts: コード署名処理 | E-34 | ○ |
| C-41 | product-build-win32.yml: Windows x64/arm64 ビルド | E-35 | ○ |
| C-42 | product-build-linux.yml: Linux x64/arm64/armhf ビルド | E-36 | ○ |
| C-43 | product-build-darwin.yml: macOS x64/arm64 ビルド | E-37 | ○ |
| C-44 | product-build-alpine.yml: Alpine Linux ビルド | E-38 | ○ |
| C-45 | product-build-web.yml: Web版ビルド | E-39 | ○ |
| C-46 | product-build-win32-cli.yml: Windows CLI ビルド | E-40 | ○ |
| C-47 | product-build-linux-cli.yml: Linux CLI ビルド | E-41 | ○ |
| C-48 | product-build-darwin-cli.yml: macOS CLI ビルド | E-42 | ○ |
| C-49 | product-build-alpine-cli.yml: Alpine CLI ビルド | E-43 | ○ |
| C-50 | sdl-scan-win32.yml: SDLセキュリティスキャン | E-44 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-15 (no-engineering-system-changes.yml)**: ワークフローファイルは存在するが、具体的な変更検出ロジックの詳細が未確認
  - 候補：ワークフローファイルの詳細読み込み / 関連ドキュメント参照
- **C-16 (copilot-setup-steps.yml)**: Copilot関連のセットアップステップの詳細内容が不明
  - 候補：ワークフローファイルの詳細読み込み / Copilot関連ドキュメント参照

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のバッチ処理は明確なソースファイル（YAML/TypeScript）から直接確認可能
- **1: 中リスク** - 一部のGitHub Actionsワークフロー（copilot-setup-steps.yml、no-engineering-system-changes.yml）は内容の詳細確認が必要
- **0: 低リスク** - Azure Pipelinesの定義は構造化されており、スケジュール・トリガー情報も明確

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ処理のカテゴリ分類が適切か確認
- [ ] 定期実行スケジュール（cron設定）が正確に記載されているか確認
- [ ] 各プラットフォーム向けビルドパイプラインの網羅性を確認
- [ ] GitHub ActionsワークフローとAzure Pipelinesの役割分担が正しく理解されているか確認
- [ ] copilot-setup-steps.ymlとno-engineering-system-changes.ymlの詳細を確認
- [ ] テスト関連バッチ（ユニット/統合/スモーク）の分類が正確か確認
