# バッチ設計書 1-product-build

## 概要

本ドキュメントは、Visual Studio Code製品のフルビルドパイプライン「product-build」の設計仕様を定義するものです。Azure Pipelinesで実行され、VSCodeの全プラットフォーム向けビルドを統合的に管理します。

### 本バッチの処理概要

本バッチは、Visual Studio Codeのマルチプラットフォーム向け製品ビルドを一元的に実行するパイプラインです。Windows、Linux、macOS、Alpine Linux、Webの各プラットフォーム向けに、コンパイル、テスト、パッケージング、署名、公開までの一連のビルドプロセスを自動化します。

**業務上の目的・背景**：VSCodeは複数のOS・アーキテクチャ(Windows x64/arm64、Linux x64/arm64/armhf、macOS x64/arm64/Universal、Alpine、Web)をサポートしており、各プラットフォーム向けのビルド成果物を一貫した品質で効率的に生成する必要があります。本バッチにより、開発者は単一のトリガーで全プラットフォーム向けのビルドを実行でき、リリースプロセスの自動化と品質保証を実現します。

**バッチの実行タイミング**：月曜日から金曜日の7:00(UTC 5:00)と19:00(UTC 17:00)に定期実行されます。また、main及びrelease/*ブランチへのコミット時に自動トリガーされます。手動実行も可能です。

**主要な処理内容**：
1. ソースコードのコンパイルとHygieneチェック（Compileステージ）
2. Rust製CLIのビルド（CompileCLIステージ）
3. 各プラットフォーム向けnode_modulesの準備
4. Windows向けビルド・テスト・署名
5. Linux向けビルド・テスト（deb/rpm/snap/tarパッケージ生成）
6. macOS向けビルド・テスト・署名（Universal Binary含む）
7. Alpine Linux向けビルド
8. Web版ビルド
9. ビルド成果物の公開（Publishステージ）
10. リリースビルドの承認と公開（Releaseステージ）

**前後の処理との関連**：本バッチは「VS Code 7PM Kick-Off」パイプラインからトリガーされることがあります。また、Compileステージの成果物は後続の各プラットフォームビルドステージで使用されます。Publishステージ完了後、Releaseステージでビルドの公開が行われます。

**影響範囲**：builds.code.visualstudio.com、Azure Blob Storage、各種パッケージリポジトリ（npm、DefinitelyTyped等）、CDN（vscode.download.prss.microsoft.com）に影響します。

## バッチ種別

CI/CDパイプライン（ビルド・テスト・デプロイ統合）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（平日2回）+ イベントトリガー |
| 実行時刻 | 7:00 / 19:00 (JST相当) |
| 実行曜日 | 月曜日〜金曜日 |
| 実行日 | - |
| トリガー | cron / ブランチコミット / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ブランチ | main または release/* ブランチであること |
| 認証情報 | Azure Key Vault にアクセス可能であること |
| ビルドエージェント | AcesShared (macOS)、1es-windows-2022-x64、1es-ubuntu-22.04-x64 が利用可能であること |
| ネットワーク | NPM Registry、Cargo Registry へのアクセスが可能であること |

### 実行可否判定

- VSCODE_CIBUILD: IndividualCI または BatchedCI の場合、CIビルドモードで実行
- VSCODE_COMPILE_ONLY: true の場合、Compileステージのみ実行
- VSCODE_STEP_ON_IT: true の場合、テストをスキップ
- 各プラットフォームビルドフラグ（VSCODE_BUILD_WIN32等）により対象プラットフォームを制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_QUALITY | string | No | insider | ビルド品質（exploration/insider/stable） |
| NPM_REGISTRY | string | No | Azure DevOps NPM | カスタムNPMレジストリURL |
| CARGO_REGISTRY | string | No | Azure DevOps Cargo | カスタムCargoレジストリURL |
| VSCODE_BUILD_WIN32 | boolean | No | true | Windows x64 ビルド有効化 |
| VSCODE_BUILD_WIN32_ARM64 | boolean | No | true | Windows arm64 ビルド有効化 |
| VSCODE_BUILD_LINUX | boolean | No | true | Linux x64 ビルド有効化 |
| VSCODE_BUILD_LINUX_SNAP | boolean | No | true | Linux Snap ビルド有効化 |
| VSCODE_BUILD_LINUX_ARM64 | boolean | No | true | Linux arm64 ビルド有効化 |
| VSCODE_BUILD_LINUX_ARMHF | boolean | No | true | Linux armhf ビルド有効化 |
| VSCODE_BUILD_ALPINE | boolean | No | true | Alpine x64 ビルド有効化 |
| VSCODE_BUILD_ALPINE_ARM64 | boolean | No | true | Alpine arm64 ビルド有効化 |
| VSCODE_BUILD_MACOS | boolean | No | true | macOS x64 ビルド有効化 |
| VSCODE_BUILD_MACOS_ARM64 | boolean | No | true | macOS arm64 ビルド有効化 |
| VSCODE_BUILD_MACOS_UNIVERSAL | boolean | No | true | macOS Universal ビルド有効化 |
| VSCODE_BUILD_WEB | boolean | No | true | Web版ビルド有効化 |
| VSCODE_PUBLISH | boolean | No | true | builds.code.visualstudio.comへの公開 |
| VSCODE_RELEASE | boolean | No | false | 成功時のリリースビルド |
| VSCODE_COMPILE_ONLY | boolean | No | false | Compileステージのみ実行 |
| VSCODE_STEP_ON_IT | boolean | No | false | テストスキップ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub microsoft/vscode | Git Repository | ソースコードリポジトリ |
| Azure Key Vault (vscode-build-secrets) | Secret Store | github-distro-mixin-password等の認証情報 |
| Azure Key Vault (vscode-esrp) | Secret Store | ESRP署名用認証情報 |
| NPM Registry | Package Registry | Node.js依存パッケージ |
| Cargo Registry | Package Registry | Rust依存パッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Azure Pipeline Artifacts | tar.gz | コンパイル成果物（Compilation） |
| builds.code.visualstudio.com | 各種バイナリ | 公開ビルド成果物 |
| Azure Blob Storage | バイナリファイル | ステージング用成果物 |
| CDN (vscode.download.prss.microsoft.com) | バイナリファイル | 配信用成果物 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | compilation.tar.gz（Compileステージ） |
| 出力先 | $(Build.ArtifactStagingDirectory) |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Compileステージ
   └─ ソースコードチェックアウト、依存関係インストール、コンパイル、Hygieneチェック
2. CompileCLIステージ（並列実行）
   └─ 各プラットフォーム向けRust CLIのビルド
3. node_modulesステージ（CIビルド時のみ）
   └─ 各プラットフォーム向けnode_modulesの準備
4. APIScanステージ（非CIビルド時）
   └─ Windows向けセキュリティスキャン
5. Windowsステージ
   └─ Windows x64/arm64 ビルド、テスト、署名
6. Linuxステージ
   └─ Linux x64/arm64/armhf ビルド、テスト、パッケージング
7. Alpineステージ
   └─ Alpine x64/arm64 ビルド
8. macOSステージ
   └─ macOS x64/arm64/Universal ビルド、テスト、署名
9. Webステージ
   └─ Web版ビルド
10. Publishステージ
    └─ ビルド成果物の公開処理
11. ApproveReleaseステージ（オプション）
    └─ リリース承認
12. Releaseステージ（オプション）
    └─ リリースビルドの公開
```

### フローチャート

```mermaid
flowchart TD
    A[パイプライン開始] --> B[Compile]
    A --> C[CompileCLI]
    A --> D[APIScan]
    B --> E{プラットフォーム選択}
    C --> E
    E -->|Windows| F[Windows Build]
    E -->|Linux| G[Linux Build]
    E -->|Alpine| H[Alpine Build]
    E -->|macOS| I[macOS Build]
    E -->|Web| J[Web Build]
    F --> K[Publish]
    G --> K
    H --> K
    I --> K
    J --> K
    K --> L{Release?}
    L -->|Yes| M[ApproveRelease]
    M --> N[Release]
    L -->|No| O[完了]
    N --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| createBuild | Azure Cosmos DB | INSERT | ビルドメタデータの登録 |
| releaseBuild | Azure Cosmos DB | UPDATE | リリースステータスの更新 |

### テーブル別操作詳細

#### Azure Cosmos DB (vscode.documents.azure.com)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | build metadata | バージョン、ビルドID、タイムスタンプ | ビルド作成時 |
| UPDATE | release status | released: true | リリース時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NPM_INSTALL_FAILED | 依存関係エラー | npm ci が5回連続失敗 | NPMレジストリの接続を確認、手動でリトライ |
| COMPILATION_FAILED | コンパイルエラー | TypeScriptコンパイルエラー | ソースコードを修正して再実行 |
| TEST_FAILED | テストエラー | ユニット/統合テスト失敗 | テスト失敗の原因を調査し修正 |
| SIGNING_FAILED | 署名エラー | ESRP署名処理失敗 | ESRP認証情報を確認 |
| PUBLISH_FAILED | 公開エラー | 成果物アップロード失敗 | ネットワーク接続を確認、手動でリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回、成果物処理: 3回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | ネットワーク関連エラー、一時的な認証エラー |

### 障害時対応

1. パイプライン失敗時は、Azure DevOpsのビルドログを確認
2. 特定ステージの失敗の場合、該当ステージのみ再実行可能
3. 認証関連エラーの場合、Azure Key Vaultのシークレットを確認
4. 継続的な失敗の場合、#vscode-build Slackチャンネルに報告

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ステージ単位 |
| コミットタイミング | 各ステージ完了時 |
| ロールバック条件 | ステージ失敗時は成果物を公開しない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | Compileステージ: 60分以内、全体: 180分以内 |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

- batch: true 設定により、同一ブランチへの複数コミットは1つのビルドにバッチ処理
- 同時実行は可能だが、Publishステージでの成果物の整合性はartifacts_processedファイルで管理

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ステージ開始時 | ステージ名、パラメータ |
| 進捗ログ | 各ステップ実行時 | ステップ名、実行結果 |
| 終了ログ | 各ステージ完了時 | 成功/失敗ステータス、所要時間 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | Compileステージ: 60分超過 | Azure DevOps通知 |
| ビルド失敗 | 連続3回失敗 | #vscode-build Slack |
| テスト失敗率 | 10%超過 | 開発チーム |

## 備考

- 1ESPipelineTemplates/1ESPipelineTemplatesを使用したセキュリティコンプライアンス対応
- SDL (Security Development Lifecycle) スキャンが有効化されている
- Component Governanceによる依存関係の脆弱性チェックを実施
- VSCODE_PRIVATE_BUILDフラグにより、プライベートフォークでのビルドを識別
