# バッチ設計書 10-pr-linux-test.yml

## 概要

本ドキュメントは、Linux向けテスト実行ワークフロー「pr-linux-test.yml」の設計仕様を定義するものです。GitHub Actionsの再利用可能ワークフローとして実装され、Electron/Browser/Remoteの各種テストをLinux環境で実行します。

### 本バッチの処理概要

本バッチは、VSCodeのLinux向けテストを実行する再利用可能なGitHub Actionsワークフローです。pr.ymlやその他のワークフローから呼び出され、ユニットテスト、統合テスト、スモークテストをElectron/Browser/Remoteの各環境で実行します。

**業務上の目的・背景**：VSCodeはLinuxを主要なターゲットプラットフォームの1つとしてサポートしています。本バッチにより、PRがLinux環境で正しく動作することを検証し、Linux固有の問題を早期に検出します。テストはElectron（デスクトップ）、Browser（Web）、Remote（リモート開発）の3つの実行環境をカバーし、VSCodeの全ての利用形態での品質を保証します。

**バッチの実行タイミング**：pr.yml等の親ワークフローからworkflow_callで呼び出されて実行されます。

**主要な処理内容**：
1. システムサービスのセットアップ（X server等）
2. Node.js依存関係のインストールとキャッシュ
3. 組み込み拡張機能のキャッシュ/ダウンロード
4. クライアントと拡張機能のトランスパイル
5. ElectronとPlaywrightのダウンロード
6. ユニットテスト実行（Electron/Browser）
7. 統合テストのビルドと実行
8. スモークテストのコンパイルと実行
9. 失敗時のクラッシュダンプ・ログのアップロード

**前後の処理との関連**：本バッチはpr.ymlワークフローから呼び出されます。workflow_callイベントにより、パラメータ（electron_tests, browser_tests, remote_tests）に応じて実行するテストを切り替えます。

**影響範囲**：GitHub PRステータス、GitHub Actions Artifacts（クラッシュダンプ、ログ）に影響します。

## バッチ種別

GitHub Actions（再利用可能ワークフロー）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 親ワークフローから呼び出し時 |
| 実行時刻 | 親ワークフロー依存 |
| 実行曜日 | 任意 |
| 実行日 | - |
| トリガー | workflow_call |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 呼び出し元 | workflow_callイベントで呼び出されること |
| ビルドエージェント | 1es-vscode-oss-ubuntu-22.04-x64（self-hosted） |
| GITHUB_TOKEN | シークレットとして設定されていること |

### 実行可否判定

- electron_tests: true の場合、Electronテストを実行
- browser_tests: true の場合、Browserテストを実行
- remote_tests: true の場合、Remoteテストを実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| job_name | string | Yes | - | ジョブの表示名 |
| electron_tests | boolean | No | false | Electronテスト実行フラグ |
| browser_tests | boolean | No | false | Browserテスト実行フラグ |
| remote_tests | boolean | No | false | Remoteテスト実行フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Repository | Git | ソースコード |
| GitHub Secrets | Secret | GITHUB_TOKEN |
| node_modulesキャッシュ | tar.gz | 以前のビルドからのキャッシュ |
| builtInExtensionsキャッシュ | ディレクトリ | 組み込み拡張機能キャッシュ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub PR Status | ステータス | テスト結果 |
| GitHub Actions Artifacts | 各種 | クラッシュダンプ、ログ、node_modules（失敗時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | crash-dump-linux-*, logs-linux-*, node-modules-linux-* |
| 出力先 | GitHub Actions Artifacts |
| 文字コード | バイナリ/UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. チェックアウト
   └─ actions/checkout@v6
2. Node.jsセットアップ
   └─ .nvmrcからバージョン指定
3. システムサービスセットアップ
   └─ apt-get install: xvfb, libgtk-3-0, libxkbfile-dev, libkrb5-dev, libgbm1, rpm
   └─ xvfb.init設定、service xvfb start
4. node_modulesキャッシュキー計算
   └─ computeNodeModulesCacheKey.ts linux $VSCODE_ARCH
5. node_modulesキャッシュ復元
   └─ actions/cache/restore@v5
6. キャッシュミス時: npm ci（build/とルート）
   └─ 5回リトライ
7. node_modulesアーカイブ作成（キャッシュミス時）
   └─ listNodeModules.ts → tar圧縮
8. 組み込み拡張機能キャッシュキー計算
   └─ computeBuiltInDepsCacheKey.ts
9. 組み込み拡張機能キャッシュ復元
   └─ actions/cache/restore@v5（enableCrossOsArchive: true）
10. キャッシュミス時: 組み込み拡張機能ダウンロード
    └─ builtInExtensions.ts
11. クライアント・拡張機能トランスパイル
    └─ npm run gulp transpile-client-esbuild transpile-extensions
12. Electron/Playwrightダウンロード（3回リトライ）
    └─ npm-run-all2 electron playwright-install
13. Electronユニットテスト実行（electron_tests時）
    └─ ./scripts/test.sh --tfs "Unit Tests"（15分タイムアウト）
14. Node.jsユニットテスト実行（electron_tests時）
    └─ npm run test-node（15分タイムアウト）
15. Browserユニットテスト実行（browser_tests時）
    └─ npm run test-browser-no-install --browser chromium（30分タイムアウト）
16. 統合テストビルド
    └─ npm run gulp compile-extension:*（複数拡張機能）
17. Electron統合テスト実行（electron_tests時）
    └─ ./scripts/test-integration.sh --tfs "Integration Tests"（20分タイムアウト）
18. Browser統合テスト実行（browser_tests時）
    └─ ./scripts/test-web-integration.sh --browser chromium（20分タイムアウト）
19. Remote統合テスト実行（remote_tests時）
    └─ ./scripts/test-remote-integration.sh（20分タイムアウト）
20. スモークテストコンパイル
    └─ test/smoke: npm run compile
21. 拡張機能メディアコンパイル
    └─ npm run gulp compile-extension-media
22. 診断情報出力（前後）
    └─ ps -ef, max_user_watches, lsof
23. Electronスモークテスト実行（electron_tests時）
    └─ npm run smoketest-no-compile -- --tracing（20分タイムアウト）
24. Browserスモークテスト実行（browser_tests時）
    └─ npm run smoketest-no-compile -- --web --tracing --headless（20分タイムアウト）
25. Remoteスモークテスト実行（remote_tests時）
    └─ npm run smoketest-no-compile -- --remote --tracing（20分タイムアウト）
26. 診断情報出力（後）
27. 失敗時: クラッシュダンプ、node_modules、ログをArtifactとしてアップロード
```

### フローチャート

```mermaid
flowchart TD
    A[workflow_call] --> B[チェックアウト]
    B --> C[Node.jsセットアップ]
    C --> D[システムサービスセットアップ]
    D --> E[キャッシュ復元]
    E --> F[トランスパイル]
    F --> G[Electron/Playwrightダウンロード]
    G --> H{electron_tests?}
    H -->|Yes| I[Electronユニットテスト]
    I --> J[Node.jsユニットテスト]
    H -->|No| K{browser_tests?}
    J --> K
    K -->|Yes| L[Browserユニットテスト]
    K -->|No| M[統合テストビルド]
    L --> M
    M --> N{electron_tests?}
    N -->|Yes| O[Electron統合テスト]
    N -->|No| P{browser_tests?}
    O --> P
    P -->|Yes| Q[Browser統合テスト]
    P -->|No| R{remote_tests?}
    Q --> R
    R -->|Yes| S[Remote統合テスト]
    R -->|No| T[スモークテスト準備]
    S --> T
    T --> U{electron_tests?}
    U -->|Yes| V[Electronスモークテスト]
    U -->|No| W{browser_tests?}
    V --> W
    W -->|Yes| X[Browserスモークテスト]
    W -->|No| Y{remote_tests?}
    X --> Y
    Y -->|Yes| Z[Remoteスモークテスト]
    Y -->|No| AA[完了]
    Z --> AA
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチではデータベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NPM_INSTALL_FAILED | 依存関係エラー | npm ci 5回失敗 | ネットワーク確認、package-lock確認 |
| ELECTRON_DOWNLOAD_FAILED | ダウンロードエラー | 3回失敗 | ネットワーク確認、再実行 |
| UNIT_TEST_FAILED | テストエラー | ユニットテスト失敗 | テストログ確認、コード修正 |
| INTEGRATION_TEST_FAILED | テストエラー | 統合テスト失敗 | テストログ確認 |
| SMOKE_TEST_FAILED | テストエラー | スモークテスト失敗 | クラッシュダンプ分析 |
| TIMEOUT | タイムアウト | 各テストのタイムアウト超過 | テスト最適化、インフラ確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回、Electron DL: 3回 |
| リトライ間隔 | 即時（npm ci）、5秒（Electron DL） |
| リトライ対象エラー | ネットワーク関連の一時的エラー |

### 障害時対応

1. クラッシュ発生時は、アップロードされたcrash-dump Artifactを分析
2. テスト失敗時は、logs Artifactでログを確認
3. シンボル化が必要な場合は、node-modules Artifactを使用
4. DISPLAY: ":10"でX serverに接続していることを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ジョブ全体 |
| コミットタイミング | ジョブ完了時 |
| ロールバック条件 | テスト失敗時もArtifactはアップロード |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1テストスイート/実行 |
| 目標処理時間 | ユニット: 15-30分、統合: 20分、スモーク: 20分 |
| メモリ使用量上限 | self-hostedランナー依存 |

## 排他制御

- 同一ワークフローの並列実行は許可
- 各実行は独立したワークスペースで実行
- DISPLAY=":10"で共通のX serverを使用

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| キャッシュログ | キャッシュ処理時 | ヒット/ミス情報 |
| テストログ | テスト実行時 | テスト結果、--tfsオプションでTFS形式 |
| 診断ログ | スモークテスト前後 | プロセス一覧、inotify設定、ファイルハンドル数 |
| デバッグログ | Browserテスト時 | DEBUG="*browser*"で詳細ログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ユニットテストタイムアウト | 15分（Electron/Node）、30分（Browser） | GitHub Actions |
| 統合テストタイムアウト | 20分 | GitHub Actions |
| スモークテストタイムアウト | 20分 | GitHub Actions |

## 備考

- ARTIFACT_NAMEは条件に応じて'electron', 'browser', 'remote', 'unknown'のいずれかに設定
- NPM_ARCH, VSCODE_ARCHは'x64'に設定
- xvfbサービスを使用してヘッドレスでGUIテストを実行
- enableCrossOsArchive: trueにより、他OSでキャッシュされた組み込み拡張機能も使用可能
- --tracingオプションでスモークテストの詳細トレースを取得
- --headlessオプションでBrowserスモークテストをヘッドレス実行
- continue-on-error: trueで診断ステップの失敗を無視
- if-no-files-found: ignoreでArtifactアップロード時のエラーを無視
