# バッチ設計書 12-pr-win32-test.yml

## 概要

本ドキュメントは、VSCode プロジェクトにおける Windows 向けテスト実行ワークフロー（pr-win32-test.yml）の設計を記述します。

### 本バッチの処理概要

このワークフローは、Windows環境でのVSCode関連テストを自動実行するための再利用可能なGitHub Actionsワークフローです。プルリクエスト時のコード品質を検証するために、Electron環境でのユニットテスト、ブラウザ（Chromium）環境でのテスト、リモート環境でのテストを包括的に実行します。

**業務上の目的・背景**：Windows環境でのVSCode動作保証を確保するため、PRマージ前に自動テストを実行することで、プラットフォーム固有の不具合を早期発見し、リリース品質を維持します。Windowsは最も利用者が多いプラットフォームであり、安定性確保は極めて重要です。

**バッチの実行タイミング**：他のワークフロー（pr.ymlなど）から`workflow_call`で呼び出されるときに実行されます。主にプルリクエストのCI/CDパイプライン内で自動実行されます。

**主要な処理内容**：
1. リポジトリのチェックアウトとNode.js環境セットアップ
2. node_modulesキャッシュの復元（7z形式）または依存関係のインストール
3. 組み込み拡張機能のキャッシュ復元またはダウンロード
4. クライアントと拡張機能のトランスパイル
5. ElectronとPlaywrightのダウンロード
6. ユニットテスト（Electron/Node.js/Browser）の実行
7. 統合テスト（Electron/Browser/Remote）の実行
8. スモークテスト（Electron/Browser/Remote）の実行
9. クラッシュレポートとログの収集・公開

**前後の処理との関連**：pr.ymlワークフローから呼び出され、他プラットフォーム（macOS/Linux）のテストワークフローと並行して実行されます。テスト失敗時はPRのマージがブロックされます。

**影響範囲**：Windows向けVSCodeビルド、組み込み拡張機能、Electron/Browser/Remote機能全般

## バッチ種別

テスト自動実行 / CI/CD品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（workflow_call時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | workflow_call（他ワークフローからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows環境 | 1es-vscode-oss-windows-2022-x64 プールが利用可能 |
| Node.js | .nvmrcで指定されたバージョンがインストール可能 |
| GitHub Token | GITHUB_TOKENシークレットが設定されていること |
| 7-Zip | キャッシュ圧縮・解凍に使用 |

### 実行可否判定

workflow_callの入力パラメータに基づき、実行するテストの種類（electron_tests/browser_tests/remote_tests）を決定します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| job_name | string | Yes | - | ジョブ表示名 |
| electron_tests | boolean | No | false | Electronテストを実行するか |
| browser_tests | boolean | No | false | ブラウザテストを実行するか |
| remote_tests | boolean | No | false | リモートテストを実行するか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .nvmrc | テキスト | Node.jsバージョン指定 |
| package-lock.json | JSON | 依存関係定義 |
| tsconfig.json | JSON | TypeScriptコンパイル設定 |
| product.json | JSON | 組み込み拡張機能定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Artifacts | ZIP | クラッシュダンプ、ログファイル |
| GitHub Actions UI | テキスト | テスト結果サマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | crash-dump-windows-{arch}-{type}-{run_attempt}.zip, logs-windows-{arch}-{type}-{run_attempt}.zip |
| 出力先 | GitHub Artifacts |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Checkout
   └─ microsoft/vscodeリポジトリをチェックアウト
2. Setup Node.js
   └─ .nvmrcに基づくNode.jsバージョン設定
3. Prepare node_modules cache key
   └─ キャッシュキー用ハッシュ生成（PowerShell）
4. Restore/Install dependencies
   └─ 7zキャッシュ復元またはnpm ciでインストール（最大5回リトライ）
5. Restore/Download built-in extensions
   └─ 組み込み拡張機能のキャッシュまたはダウンロード
6. Transpile
   └─ Gulpでクライアント・拡張機能をトランスパイル
7. Download Electron/Playwright
   └─ テスト実行に必要なバイナリをダウンロード（最大3回リトライ）
8. Run tests
   └─ 条件に基づきユニット/統合/スモークテスト実行
9. Publish artifacts
   └─ 失敗時にクラッシュレポートとログを公開
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Checkout]
    B --> C[Setup Node.js]
    C --> D{node_modules cache hit?}
    D -->|Yes| E[7z Extract cache]
    D -->|No| F[npm ci install]
    E --> G[Restore built-in extensions]
    F --> G
    G --> H[Transpile client & extensions]
    H --> I[Download Electron/Playwright]
    I --> J{electron_tests?}
    J -->|Yes| K[Run Electron tests]
    J -->|No| L{browser_tests?}
    K --> L
    L -->|Yes| M[Run Browser tests - Chromium]
    L -->|No| N{remote_tests?}
    M --> N
    N -->|Yes| O[Run Remote tests]
    N -->|No| P[Publish artifacts]
    O --> P
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しないCI/CDワークフロー）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 依存関係インストール失敗 | npm ci失敗時 | 最大5回リトライ後、終了 |
| - | Electronダウンロード失敗 | ネットワークエラー | 最大3回リトライ後、終了 |
| - | テスト失敗 | テストケース失敗 | クラッシュレポート・ログを収集し、ジョブ失敗 |
| - | タイムアウト | 処理時間超過 | ジョブ終了（15-20分制限） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回、Electronダウンロード: 3回 |
| リトライ間隔 | 2秒（npm ci/Electronダウンロード時） |
| リトライ対象エラー | ネットワーク関連エラー |

### 障害時対応

失敗時はGitHub Actionsの自動アーティファクトアップロードにより、クラッシュダンプとログファイルが保存されます。listprocesses.batで診断情報も収集されます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークフロー実行/PR |
| 目標処理時間 | 30-60分 |
| メモリ使用量上限 | ランナーのシステムメモリに依存 |

## 排他制御

同一PRに対する複数の並行実行は、GitHub Actionsのワークフロー同時実行制御に依存します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、入力パラメータ |
| 進捗ログ | 各ステップ実行時 | ステップ名、実行結果 |
| 診断ログ | テスト前後 | listprocesses.batの出力 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | スタックトレース、環境情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1回 | PRステータスチェック |
| タイムアウト | 各テスト15-20分 | GitHub Actions UI |

## 備考

- Self-hostedランナープール（1es-vscode-oss-windows-2022-x64）を使用
- PowerShellスクリプトでWindows固有の処理を実行
- 7-Zipを使用してキャッシュを圧縮・展開（tarではなく7z形式）
- Chromiumブラウザでブラウザテストを実行（macOSのWebkitとは異なる）
- npm_config_foreground_scripts=trueでスクリプト出力を可視化
