# バッチ設計書 13-pr-linux-cli-test.yml

## 概要

本ドキュメントは、VSCode プロジェクトにおける Linux CLI テスト実行ワークフロー（pr-linux-cli-test.yml）の設計を記述します。

### 本バッチの処理概要

このワークフローは、Linux環境でのVSCode CLI（Rust製コマンドラインツール）のテストを自動実行するための再利用可能なGitHub Actionsワークフローです。Rustツールチェーンを使用してCLIコードの品質検証を行い、Clippy静的解析とユニットテストを実行します。

**業務上の目的・背景**：VSCode CLIはRustで実装されており、コード品質と安全性を確保するためにClippy（Rustの静的解析ツール）とユニットテストを実行します。CLIはリモート開発やトンネル機能の基盤となる重要なコンポーネントであり、その品質はユーザー体験に直結します。

**バッチの実行タイミング**：他のワークフロー（pr.ymlなど）から`workflow_call`で呼び出されるときに実行されます。主にプルリクエストのCI/CDパイプライン内で自動実行されます。

**主要な処理内容**：
1. リポジトリのチェックアウト
2. Rustツールチェーンのインストールと設定
3. 指定されたRustバージョンへの切り替え
4. Clippyコンポーネントの追加
5. Clippy静的解析の実行（警告をエラーとして扱う）
6. cargo testによるユニットテスト実行

**前後の処理との関連**：pr.ymlワークフローから呼び出され、他のプラットフォーム向けCLIテスト（macOS/Windows）と並行して実行されます。テスト失敗時はPRのマージがブロックされます。

**影響範囲**：VSCode CLI（cliディレクトリ）、リモート開発機能、トンネル接続機能

## バッチ種別

テスト自動実行 / Rust品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（workflow_call時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | workflow_call（他ワークフローからの呼び出し） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | 1es-vscode-oss-ubuntu-22.04-x64 プールが利用可能 |
| Rustインストール可能 | rustup.rsからRustをインストール可能なネットワーク環境 |

### 実行可否判定

workflow_callの入力パラメータ（rustup_toolchain）に基づき、使用するRustバージョンが決定されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| job_name | string | Yes | - | ジョブ表示名 |
| rustup_toolchain | string | Yes | - | 使用するRustツールチェーンバージョン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| cli/Cargo.toml | TOML | Rust依存関係定義 |
| cli/Cargo.lock | TOML | Rust依存関係ロックファイル |
| cli/src/**/*.rs | Rust | CLIソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions UI | テキスト | Clippy解析結果、テスト結果 |

### 出力ファイル仕様

該当なし（テスト結果はGitHub Actions UIに出力）

## 処理フロー

### 処理シーケンス

```
1. Checkout
   └─ microsoft/vscodeリポジトリをチェックアウト
2. Install Rust
   └─ rustup.shでRustをインストール（minimal profile）
3. Set Rust version
   └─ 指定されたツールチェーンをデフォルトに設定
4. Add Clippy component
   └─ rustup component add clippy
5. Check Rust versions
   └─ rustc --version, cargo --versionでバージョン確認
6. Clippy lint
   └─ cargo clippy -- -D warnings（警告をエラーとして扱う）
7. Run unit tests
   └─ cargo test
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Checkout]
    B --> C[Install Rust via rustup.sh]
    C --> D[Set default Rust toolchain]
    D --> E[Update toolchain]
    E --> F[Add Clippy component]
    F --> G[Verify Rust versions]
    G --> H[Run Clippy lint]
    H --> I{Clippy warnings?}
    I -->|Yes| J[Build failed]
    I -->|No| K[Run cargo test]
    K --> L{Tests passed?}
    L -->|Yes| M[バッチ終了 - 成功]
    L -->|No| N[バッチ終了 - 失敗]
    J --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しないCI/CDワークフロー）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Rustインストール失敗 | ネットワークエラー | ワークフロー再実行 |
| - | Clippy警告 | コード品質問題 | 警告箇所を修正してPR更新 |
| - | テスト失敗 | テストケース失敗 | テスト失敗箇所を修正してPR更新 |
| - | コンパイルエラー | Rustコードエラー | コンパイルエラーを修正してPR更新 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Clippy警告やテスト失敗が発生した場合は、GitHub Actions UIで詳細を確認し、該当箇所を修正してPRを更新してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークフロー実行/PR |
| 目標処理時間 | 5-15分 |
| メモリ使用量上限 | ランナーのシステムメモリに依存 |

## 排他制御

同一PRに対する複数の並行実行は、GitHub Actionsのワークフロー同時実行制御に依存します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、Rustバージョン |
| バージョンログ | バージョン確認時 | rustc/cargoバージョン |
| Clippyログ | 静的解析時 | 警告・エラーメッセージ |
| テストログ | テスト実行時 | テスト結果詳細 |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1回 | PRステータスチェック |
| Clippy警告 | 1件 | ビルド失敗 |

## 備考

- Rust製CLIはcliディレクトリに格納されています
- Clippy実行時の`-D warnings`オプションにより、すべての警告がエラーとして扱われます
- minimal profileでRustをインストールし、必要に応じてコンポーネントを追加するアプローチを採用
- RUSTUP_TOOLCHAIN環境変数で使用するRustバージョンを制御
