# バッチ設計書 15-no-engineering-system-changes.yml

## 概要

本ドキュメントは、VSCode プロジェクトにおけるエンジニアリングシステム変更チェックワークフロー（no-engineering-system-changes.yml）の設計を記述します。

### 本バッチの処理概要

このワークフローは、プルリクエストにおいてビルドシステムやCI/CDパイプラインへの不正な変更を検出・防止するためのセキュリティ・品質管理ワークフローです。`.github/workflows/`、`build/`フォルダ、`package.json`への変更を検知し、権限のない貢献者からの変更をブロックします。

**業務上の目的・背景**：エンジニアリングシステム（CI/CDワークフロー、ビルドスクリプト、package.json）は、プロジェクトのビルドとリリースの基盤です。これらへの不正な変更は、サプライチェーン攻撃やビルドの破壊につながる可能性があります。外部貢献者による意図しない、または悪意のある変更を防ぐことで、プロジェクトのセキュリティと安定性を確保します。

**バッチの実行タイミング**：プルリクエストが作成または更新されるたびに自動実行されます。

**主要な処理内容**：
1. PR内の変更ファイル一覧を取得
2. `.github/workflows/`、`build/`、`package.json`が変更されているかチェック
3. CopilotによるPRの場合、エンジニアリングシステム変更を即座に拒否
4. その他のユーザーの場合、リポジトリ権限を確認
5. write/maintain/admin権限またはdependabot以外のユーザーからの変更を拒否

**前後の処理との関連**：すべてのPRに対して実行される独立したワークフローです。他のテストワークフローとは並行して実行されます。

**影響範囲**：.github/workflows/、build/フォルダ、package.json、CI/CDパイプライン全体

## バッチ種別

セキュリティチェック / 品質ゲート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（pull_request時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | pull_request |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub Token | GITHUB_TOKENシークレットが設定されていること |
| プルリクエスト | pull_requestイベントで実行されること |

### 実行可否判定

すべてのプルリクエストに対して実行されます。変更されたファイルにエンジニアリングシステムファイルが含まれていない場合は、早期終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| (なし) | - | - | - | pull_requestイベントから自動取得 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PR変更ファイル一覧 | JSON | trilom/file-changes-actionで取得 |
| ユーザー権限情報 | JSON | GitHub API経由で取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions UI | テキスト | チェック結果（成功/失敗） |
| PRステータス | ステータス | 合格/不合格 |

### 出力ファイル仕様

該当なし（ステータスチェックのみ）

## 処理フロー

### 処理シーケンス

```
1. Get file changes
   └─ PRで変更されたファイル一覧を取得
2. Check if engineering systems were modified
   └─ .github/workflows/、build/、package.jsonが含まれるか確認
3. Check PR author
   └─ PRの作成者を確認
4. If Copilot
   └─ 即座に拒否（エンジニアリングシステム変更は許可されない）
5. If not Copilot
   └─ GitHub APIでユーザーのリポジトリ権限を取得
6. Check permissions
   └─ admin/maintain/write権限またはdependabotか確認
7. Block if unauthorized
   └─ 権限がない場合はエラーで終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Get file changes]
    B --> C{engineering systems modified?}
    C -->|No| D[成功 - 終了]
    C -->|Yes| E{PR author is Copilot?}
    E -->|Yes| F[エラー - Copilot禁止]
    E -->|No| G[Get user permissions via API]
    G --> H{Has admin/maintain/write?}
    H -->|Yes| I[成功 - 終了]
    H -->|No| J{Is dependabot?}
    J -->|Yes| I
    J -->|No| K[エラー - 権限不足]
    F --> L[バッチ終了 - 失敗]
    K --> L
    I --> M[バッチ終了 - 成功]
    D --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しないCI/CDワークフロー）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Exit 1 | Copilot禁止 | CopilotがPR作成者でエンジニアリングシステム変更あり | 手動でPRを作成 |
| Exit 1 | 権限不足 | write権限のないユーザーがエンジニアリングシステム変更 | メンテナーに依頼 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

権限不足でブロックされた場合は、メンテナー（admin/maintain/write権限保持者）にビルドシステム変更を依頼してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/PR |
| 目標処理時間 | 1分未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一PRに対する複数の並行実行は、GitHub Actionsのワークフロー同時実行制御に依存します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 変更ファイルログ | ファイル確認時 | エンジニアリングシステム変更の有無 |
| ユーザー情報ログ | 権限確認時 | ユーザー名、ロール、dependabot判定 |
| 判定ログ | 判定時 | should_run判定結果 |
| エラーログ | 拒否時 | 拒否理由メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1回 | PRステータスチェック |

## 備考

- permissions: {}で最小権限を設定（セキュリティ上の理由）
- trilom/file-changes-action v1.2.4で変更ファイルを取得
- octokit/request-action v2.4.0でGitHub APIを呼び出し
- 対象パターン：`^\.github\/workflows\/`、`^build\/`、`package\.json$`
- Copilotは特別扱いで、エンジニアリングシステム変更を一切許可しない
- dependabotはpackage.json更新の正規手段として許可
- jqを使用してJSONからパターンをマッチング
