# バッチ設計書 16-copilot-setup-steps.yml

## 概要

本ドキュメントは、VSCode プロジェクトにおける Copilot セットアップワークフロー（copilot-setup-steps.yml）の設計を記述します。

### 本バッチの処理概要

このワークフローは、GitHub Copilotエージェントがコード作業を行う前に必要な環境セットアップを実行するためのワークフローです。VSCodeプロジェクトのビルドとテストに必要な依存関係をインストールし、Copilotが作業を開始できる状態を準備します。

**業務上の目的・背景**：GitHub Copilotはコードの自動生成や修正を支援するAIツールですが、VSCodeのような大規模プロジェクトで作業するためには、適切な開発環境が必要です。このワークフローは、Copilotが効果的に作業できるよう、Node.js環境、依存関係、Electron、Playwrightなどをセットアップします。

**バッチの実行タイミング**：
- 手動実行（workflow_dispatch）
- copilot-setup-steps.ymlファイル自体の変更時（push/pull_request）
- Copilotがリポジトリで作業を開始するときに自動的に呼び出される

**主要な処理内容**：
1. リポジトリのチェックアウト
2. Node.js環境のセットアップ
3. Linux向けシステムサービス（X server等）のセットアップ
4. node_modulesキャッシュの復元または依存関係のインストール
5. 組み込み拡張機能のキャッシュ復元またはダウンロード
6. ElectronとPlaywrightのダウンロード

**前後の処理との関連**：このワークフローはCopilotエージェントの前提条件として実行されます。セットアップ完了後、Copilotは独自のトークンでコード作業を開始します。

**影響範囲**：Copilot統合、開発環境セットアップ、CI/CD自動化

## バッチ種別

環境セットアップ / Copilot統合

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（workflow_dispatch/push/pull_request） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | workflow_dispatch、push（paths制限）、pull_request（paths制限） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | vscode-large-runnersランナーが利用可能 |
| GitHub Token | GITHUB_TOKENシークレットが設定されていること |
| ネットワーク | npm、Electron、Playwrightのダウンロードが可能 |

### 実行可否判定

- workflow_dispatch: 手動実行時は常に実行
- push/pull_request: copilot-setup-steps.ymlファイルが変更された場合のみ実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| (なし) | - | - | - | 自動取得 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .nvmrc | テキスト | Node.jsバージョン指定 |
| package-lock.json | JSON | 依存関係定義 |
| product.json | JSON | 組み込み拡張機能定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| セットアップ済み環境 | - | Copilotが作業可能な状態 |
| キャッシュ | tar.gz | node_modulesキャッシュ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | .build/node_modules_cache/cache.tgz |
| 出力先 | GitHub Actions キャッシュ |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Checkout
   └─ microsoft/vscodeリポジトリをチェックアウト
2. Setup Node.js
   └─ .nvmrcに基づくNode.jsバージョン設定
3. Setup system services
   └─ X server、必要なLinuxパッケージのインストール
4. Prepare node_modules cache key
   └─ キャッシュキー用ハッシュ生成
5. Restore/Install build dependencies
   └─ buildディレクトリの依存関係インストール
6. Restore/Install dependencies
   └─ キャッシュ復元またはnpm ciでインストール（最大5回リトライ）
7. Restore/Download built-in extensions
   └─ 組み込み拡張機能のキャッシュまたはダウンロード
8. Download Electron/Playwright
   └─ テスト実行に必要なバイナリをダウンロード（最大3回リトライ）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Checkout]
    B --> C[Setup Node.js]
    C --> D[Setup system services - apt-get]
    D --> E[Configure xvfb service]
    E --> F{node_modules cache hit?}
    F -->|Yes| G[Extract cache]
    F -->|No| H[Install build deps]
    H --> I[npm ci install]
    G --> J[Restore built-in extensions]
    I --> K[Create cache archive]
    K --> J
    J --> L[Download Electron/Playwright]
    L --> M[バッチ終了 - セットアップ完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しないCI/CDワークフロー）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | apt-get失敗 | パッケージインストール失敗 | apt-retry.shで自動リトライ |
| - | 依存関係インストール失敗 | npm ci失敗時 | 最大5回リトライ後、終了 |
| - | Electronダウンロード失敗 | ネットワークエラー | 最大3回リトライ後、終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回、Electronダウンロード: 3回 |
| リトライ間隔 | 5秒（Electronダウンロード時） |
| リトライ対象エラー | ネットワーク関連エラー |

### 障害時対応

セットアップ失敗時は、GitHub Actions UIでエラーログを確認し、ネットワーク問題やパッケージ依存関係の問題を特定してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/Copilotセッション |
| 目標処理時間 | 10-20分 |
| メモリ使用量上限 | ランナーのシステムメモリに依存 |

## 排他制御

ジョブ名が`copilot-setup-steps`でなければCopilotに認識されません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ワークフロー開始 |
| apt-getログ | パッケージインストール時 | インストール結果 |
| npm ciログ | 依存関係インストール時 | インストール結果 |
| キャッシュログ | キャッシュ操作時 | キャッシュヒット/ミス |
| 終了ログ | ジョブ終了時 | 成功/失敗ステータス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ失敗 | 1回 | GitHub Actions UI |
| セットアップ時間 | 30分超過 | 要調査 |

## 備考

- ジョブ名は必ず`copilot-setup-steps`である必要があります（Copilotが認識するため）
- permissions: contents: readで最小権限を設定
- Copilotは独自のトークンで操作を行うため、このワークフローのpermissionsは最小限
- コードをチェックアウトしない場合、Copilotが自動的にチェックアウトを行います
- xvfbはLinuxでGUIテストを実行するために必要なX virtual framebuffer
- 現在、transpileとテスト実行ステップはコメントアウトされています（Copilotセットアップには不要）
- vscode-large-runnersを使用して十分なリソースを確保
