# バッチ設計書 17-compile

## 概要

本ドキュメントは、VSCode プロジェクトにおけるフルコンパイルタスク（compile）の設計を記述します。

### 本バッチの処理概要

このGulpタスクは、VSCodeプロジェクト全体のTypeScriptコンパイルを実行するフルビルドタスクです。クライアントコード（src/）、組み込み拡張機能、拡張機能メディアを並列でコンパイルし、開発時の完全なビルド環境を構築します。

**業務上の目的・背景**：VSCodeは大規模なTypeScriptプロジェクトであり、開発者がローカル環境で完全なビルドを実行し、すべてのコンポーネントが正しくコンパイルされることを確認する必要があります。このタスクは、コード変更後の検証や、新しい開発環境のセットアップ時に使用されます。

**バッチの実行タイミング**：
- 開発者が`npm run gulp compile`または`npm run gulp`を実行したとき
- 新しいブランチをチェックアウトした後
- 依存関係を更新した後
- CI/CDパイプラインでのビルド検証時

**主要な処理内容**：
1. Monaco Editor型チェック（monacoTypecheckTask）
2. クライアントコードコンパイル（compile-client）
   - outディレクトリのクリーンアップ
   - API提案名の生成
   - src/からout/へのTypeScriptコンパイル
3. 拡張機能コンパイル（compile-extensions）
   - すべての組み込み拡張機能を並列コンパイル
4. 拡張機能メディアコンパイル（compile-extension-media）
   - Webpackによる拡張機能メディアのビルド

**前後の処理との関連**：このタスクはdefaultタスクとしても登録されており、`gulp`コマンドだけで実行可能です。watch タスクの前に完全なコンパイルを行う場合に使用されます。

**影響範囲**：src/、extensions/、out/ディレクトリ、monaco.d.ts

## バッチ種別

ビルド / コンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 手動実行（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | gulp compile / gulp / npm run compile |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | .nvmrcで指定されたバージョンがインストール済み |
| npm依存関係 | npm ciまたはnpm installが完了していること |
| メモリ | 4GB以上のRAM（コンパイルに必要） |

### 実行可否判定

- メモリが4GB未満の場合、エラーで終了します
- outディレクトリは自動的にクリーンアップされます

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| (なし) | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/**/*.ts | TypeScript | クライアントソースコード |
| extensions/**/src/**/*.ts | TypeScript | 拡張機能ソースコード |
| tsconfig.json | JSON | TypeScriptコンパイル設定 |
| src/vscode-dts/*.d.ts | TypeScript | API提案定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out/ | JavaScript | コンパイル済みクライアントコード |
| extensions/*/out/ | JavaScript | コンパイル済み拡張機能コード |
| src/vs/monaco.d.ts | TypeScript | Monaco API定義 |
| src/vs/platform/extensions/common/extensionsApiProposals.ts | TypeScript | API提案名定義 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | *.js, *.js.map |
| 出力先 | out/, extensions/*/out/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. compile（並列実行）
   ├─ monacoTypecheckTask
   │   └─ Monaco Editor APIの型チェック
   ├─ compile-client（直列実行）
   │   ├─ rimraf('out')
   │   │   └─ outディレクトリのクリーンアップ
   │   ├─ compile-api-proposal-names
   │   │   └─ API提案名の生成
   │   └─ compileTask('src', 'out', false)
   │       └─ TypeScriptコンパイル
   ├─ compile-extensions（並列実行）
   │   └─ 各拡張機能のコンパイルタスク
   └─ compile-extension-media
       └─ 拡張機能メディアのビルド
```

### フローチャート

```mermaid
flowchart TD
    A[gulp compile 開始] --> B[並列実行開始]
    B --> C[monacoTypecheckTask]
    B --> D[compile-client]
    B --> E[compile-extensions]
    B --> F[compile-extension-media]

    D --> D1[rimraf out/]
    D1 --> D2[compile-api-proposal-names]
    D2 --> D3[compileTask src -> out]

    E --> E1[compile-extension:config-editing]
    E --> E2[compile-extension:css-features]
    E --> E3[compile-extension:...]

    C --> G{すべて完了?}
    D3 --> G
    E1 --> G
    E2 --> G
    E3 --> G
    F --> G

    G -->|Yes| H[gulp compile 終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しないビルドタスク）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | メモリ不足 | RAMが4GB未満 | メモリを増設またはスワップを設定 |
| - | TypeScriptエラー | コード構文エラー | エラー箇所を修正 |
| - | monaco.d.ts生成エラー | API定義の不整合 | gulp watchを実行してmonaco.d.tsを更新 |
| - | 拡張機能コンパイルエラー | 拡張機能コードエラー | 該当拡張機能のエラーを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

コンパイルエラーが発生した場合は、エラーメッセージを確認し、該当ファイルを修正してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 2-5分（マシン性能に依存） |
| メモリ使用量上限 | 4GB以上必須 |

## 排他制御

同時に複数のcompileタスクを実行することは推奨されません。outディレクトリの競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名 |
| コンパイルログ | コンパイル中 | ファイル名、エラー/警告 |
| monaco.d.tsログ | API生成時 | 変更の有無、処理時間 |
| 終了ログ | タスク終了時 | 成功/失敗、処理時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| コンパイルエラー | 1件 | コンソール出力 |
| 警告 | 多数 | コンソール出力 |

## 備考

- `gulp`コマンドのみでも実行可能（defaultタスクとして登録）
- 並列実行により、複数CPUコアを活用してビルド時間を短縮
- monaco.d.tsが最新でない場合、エラーメッセージが表示されます（watch実行を推奨）
- compileTask関数はbuild/lib/compilation.tsで定義されています
- ソースマップ（.js.map）も同時に生成されます
- inlineSourceMapオプションは開発ビルドでtrueに設定されます
