# バッチ設計書 18-watch

## 概要

本ドキュメントは、VSCode プロジェクトにおける開発時ウォッチタスク（watch）の設計を記述します。

### 本バッチの処理概要

このGulpタスクは、VSCode開発時にファイル変更を監視し、変更されたファイルのみを自動的に再コンパイルするインクリメンタルビルドタスクです。クライアントコードと拡張機能の両方を監視し、開発者の生産性を向上させます。

**業務上の目的・背景**：VSCodeの開発では、コードを頻繁に変更してテストする必要があります。変更のたびにフルビルドを実行すると時間がかかるため、変更されたファイルのみを再コンパイルするウォッチモードが必要です。これにより、開発者は素早くコード変更を確認でき、開発サイクルが大幅に短縮されます。

**バッチの実行タイミング**：
- 開発者が`npm run gulp watch`または`npm run watch`を実行したとき
- VSCode開発セッション開始時

**主要な処理内容**：
1. クライアントウォッチ（watch-client）
   - outディレクトリのクリーンアップ
   - ファイル変更監視の開始
   - API提案名の監視と再生成
   - 変更ファイルのインクリメンタルコンパイル
2. 拡張機能ウォッチ（watch-extensions）
   - すべての組み込み拡張機能の変更監視
   - 変更された拡張機能のみ再コンパイル

**前後の処理との関連**：通常、compileタスク後またはクリーンな状態から開始します。開発セッション中は継続的に実行され、ファイル変更を検知します。

**影響範囲**：src/、extensions/、out/ディレクトリ、monaco.d.ts、API提案定義

## バッチ種別

ファイル監視 / インクリメンタルビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 継続実行（手動開始） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | gulp watch / npm run watch |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | .nvmrcで指定されたバージョンがインストール済み |
| npm依存関係 | npm ciまたはnpm installが完了していること |
| ファイルシステム | ファイル監視機能がサポートされていること |

### 実行可否判定

- 依存関係がインストールされていれば実行可能
- 継続実行のため、手動でCtrl+Cなどで停止するまで動作します

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| (なし) | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/**/*.ts | TypeScript | クライアントソースコード |
| extensions/**/src/**/*.ts | TypeScript | 拡張機能ソースコード |
| src/vscode-dts/*.d.ts | TypeScript | API提案定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out/ | JavaScript | コンパイル済みクライアントコード |
| extensions/*/out/ | JavaScript | コンパイル済み拡張機能コード |
| src/vs/monaco.d.ts | TypeScript | Monaco API定義（変更時） |
| src/vs/platform/extensions/common/extensionsApiProposals.ts | TypeScript | API提案名定義（変更時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | *.js, *.js.map |
| 出力先 | out/, extensions/*/out/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. watch（並列実行）
   ├─ watch-client（直列実行）
   │   ├─ rimraf('out')
   │   │   └─ outディレクトリのクリーンアップ
   │   └─ 並列実行
   │       ├─ watchTask('out', false)
   │       │   └─ src/**の監視と再コンパイル
   │       └─ watch-api-proposal-names
   │           └─ vscode-dts/**の監視と再生成
   └─ watch-extensions（並列実行）
       └─ 各拡張機能のウォッチタスク
           └─ extensions/*/src/**の監視と再コンパイル
```

### フローチャート

```mermaid
flowchart TD
    A[gulp watch 開始] --> B[並列実行開始]
    B --> C[watch-client]
    B --> D[watch-extensions]

    C --> C1[rimraf out/]
    C1 --> C2[並列実行]
    C2 --> C3[watchTask - src監視]
    C2 --> C4[watch-api-proposal-names]

    D --> D1[watch-extension:config-editing]
    D --> D2[watch-extension:css-features]
    D --> D3[watch-extension:...]

    C3 --> E[ファイル変更検知]
    E --> F{変更あり?}
    F -->|Yes| G[インクリメンタルコンパイル]
    G --> E
    F -->|No| E

    style E fill:#f9f,stroke:#333
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しないビルドタスク）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | TypeScriptエラー | コード構文エラー | エラー箇所を修正（watchは継続） |
| - | ファイルアクセスエラー | ファイルがロック中 | ファイルを閉じて再保存 |
| - | inotify上限エラー | Linux: ウォッチャー数超過 | max_user_watchesを増加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライ（継続監視） |
| リトライ間隔 | N/A |
| リトライ対象エラー | コンパイルエラー（監視は継続） |

### 障害時対応

コンパイルエラーが発生してもウォッチは継続します。エラーを修正して保存すると、自動的に再コンパイルされます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 継続的なファイル変更監視 |
| 目標処理時間 | 変更検知から再コンパイル完了まで1-3秒 |
| メモリ使用量上限 | 継続実行のため、メモリリークに注意 |

## 排他制御

- 同時に複数のwatchタスクを実行することは推奨されません
- VSCodeの自動保存機能と組み合わせて使用可能

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名 |
| 変更検知ログ | ファイル変更時 | 変更されたファイル名 |
| コンパイルログ | コンパイル中 | ファイル名、エラー/警告 |
| monaco.d.tsログ | API変更時 | 変更の有無、処理時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| コンパイルエラー | 1件 | コンソール出力 |
| 警告 | 多数 | コンソール出力 |

## 備考

- readDelay: 200ms でファイル変更をデバウンスし、連続した変更をまとめて処理
- MonacoGeneratorはウォッチモードでファイル監視を行い、monaco.d.tsを自動更新
- util.incremental()関数でインクリメンタルコンパイルを実現
- emitError: falseに設定されているため、エラーがあってもウォッチは継続
- Linuxでは`/proc/sys/fs/inotify/max_user_watches`の値を増やす必要がある場合があります
- watch-api-proposal-namesはvscode-dts/**を監視し、API提案が追加/変更されたら自動的にextensionsApiProposals.tsを再生成
