# バッチ設計書 19-compile-build-with-mangling

## 概要

本ドキュメントは、VSCode プロジェクトにおける CIビルド用コンパイルタスク（compile-build-with-mangling）の設計を記述します。

### 本バッチの処理概要

このGulpタスクは、CIビルド環境向けにTypeScriptコードを本番品質でコンパイルするタスクです。難読化（mangling）を有効にし、NLS（国際化）処理、ソースマップのインライン化、ミニフィケーションを行い、製品リリース用のビルドを生成します。

**業務上の目的・背景**：VSCodeの製品ビルドでは、コードサイズの削減とリバースエンジニアリングの防止のために、プライベートフィールドやエクスポートの名前を短い名前に置き換える「難読化（mangling）」を適用します。これにより、配布されるコードサイズが小さくなり、パフォーマンスが向上します。

**バッチの実行タイミング**：
- CI/CDパイプラインでの製品ビルド時
- Azure Pipelinesでの定期ビルド（月〜金 7:00/19:00）
- main/release/*ブランチへのプッシュ時

**主要な処理内容**：
1. out-buildディレクトリのクリーンアップ
2. ISO日付のタイムスタンプ書き込み
3. API提案名の生成
4. TypeScriptコンパイル（難読化有効）
   - Manglerによるプライベートフィールド/エクスポートの名前変換
   - NLS処理（国際化対応）
   - ソースマップのインライン化
   - ミニフィケーション

**前後の処理との関連**：product-buildパイプラインの一部として実行され、後続のパッケージング・署名・公開処理の入力となります。

**影響範囲**：out-build/ディレクトリ、製品ビルド成果物

## バッチ種別

ビルド / プロダクションコンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CD時（定期: 月〜金 7:00/19:00、トリガー時） |
| 実行時刻 | 7:00 / 19:00（定期） |
| 実行曜日 | 月〜金 |
| 実行日 | N/A |
| トリガー | main/release/*ブランチへのプッシュ、手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | .nvmrcで指定されたバージョンがインストール済み |
| npm依存関係 | npm ciが完了していること |
| メモリ | 4GB以上のRAM（コンパイルとmanglingに必要） |
| CI環境 | Azure Pipelinesまたは同等の環境 |

### 実行可否判定

- メモリが4GB未満の場合、エラーで終了します
- out-buildディレクトリは自動的にクリーンアップされます

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| (なし) | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/**/*.ts | TypeScript | クライアントソースコード |
| tsconfig.json | JSON | TypeScriptコンパイル設定 |
| src/vscode-dts/*.d.ts | TypeScript | API提案定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out-build/ | JavaScript | 難読化済みコンパイルコード |
| out-build/date | テキスト | ISO日付タイムスタンプ |
| out-build/**/*.js.map | JSON | ソースマップ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | *.js, *.js.map |
| 出力先 | out-build/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. compile-build-with-mangling（直列実行）
   ├─ rimraf('out-build')
   │   └─ out-buildディレクトリのクリーンアップ
   ├─ writeISODate('out-build')
   │   └─ タイムスタンプの書き込み
   ├─ compileApiProposalNamesTask
   │   └─ API提案名の生成
   └─ compileTask('src', 'out-build', true, { disableMangle: false })
       ├─ Mangler初期化
       │   └─ mangleExports: true, manglePrivateFields: true
       ├─ TypeScriptファイル読み込み
       ├─ Manglerで名前変換
       │   └─ プライベートフィールド、エクスポートの短縮
       ├─ TypeScriptコンパイル
       ├─ NLS処理
       │   └─ preserveEnglish: false
       └─ ソースマップ書き込み
           └─ inlineSources: true
```

### フローチャート

```mermaid
flowchart TD
    A[gulp compile-build-with-mangling 開始] --> B[rimraf out-build/]
    B --> C[writeISODate]
    C --> D[compile-api-proposal-names]
    D --> E[compileTask with mangling]

    E --> E1[メモリチェック >= 4GB]
    E1 -->|OK| E2[Mangler初期化]
    E1 -->|NG| F[エラー終了]

    E2 --> E3[computeNewFileContents]
    E3 --> E4[TypeScript読み込み]
    E4 --> E5[名前変換 - mangleStream]
    E5 --> E6[MonacoGenerator]
    E6 --> E7[TypeScriptコンパイル]
    E7 --> E8[NLS処理]
    E8 --> E9[ソースマップ書き込み]
    E9 --> E10[gulp.dest out-build/]

    E10 --> G[gulp compile-build-with-mangling 終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しないビルドタスク）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | メモリ不足 | RAMが4GB未満 | メモリを増設またはスワップを設定 |
| - | TypeScriptエラー | コード構文エラー | エラー箇所を修正 |
| - | Manglerエラー | 難読化処理失敗 | Manglerログを確認して修正 |
| - | monaco.d.ts生成エラー | API定義の不整合 | API定義を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

コンパイルエラーが発生した場合は、エラーメッセージを確認し、該当ファイルを修正してください。Manglerエラーの場合は、`[mangler]`プレフィックスのログを確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 5-15分（CI環境、マシン性能に依存） |
| メモリ使用量上限 | 4GB以上必須 |

## 排他制御

CI/CDパイプラインで順次実行されるため、通常は排他制御の問題は発生しません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名 |
| Manglerログ | 名前変換時 | [mangler] プレフィックス付きログ |
| コンパイルログ | コンパイル中 | ファイル名、エラー/警告 |
| monaco.d.tsログ | API生成時 | 変更の有無、処理時間 |
| 終了ログ | タスク終了時 | 成功/失敗、処理時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド失敗 | 1回 | Azure Pipelines通知 |
| ビルド時間 | 30分超過 | 要調査 |

## 備考

- disableMangle: falseで難読化が有効化されます（makeCompileBuildTask関数で制御）
- Manglerはbuild/lib/mangle/index.tsで定義されています
- mangleExports: trueでエクスポート名を短縮
- manglePrivateFields: trueでプライベートフィールド名を短縮
- saveStateは難読化対象から除外されています（Set(['saveState'])）
- build: trueにより、NLS処理とinlineSourcesが有効化されます
- product-buildパイプラインから呼び出されます
- compile-build-without-manglingとの違いは、disableMangleの値のみです
