# バッチ設計書 2-product-compile

## 概要

本ドキュメントは、Visual Studio Codeのソースコードコンパイルステージ「product-compile」の設計仕様を定義するものです。product-buildパイプラインの一部として実行され、TypeScriptコンパイル、拡張機能ビルド、コード品質チェックを担当します。

### 本バッチの処理概要

本バッチは、VSCodeのソースコードをコンパイルし、後続のプラットフォーム別ビルドステージで使用可能な成果物を生成します。依存関係のインストール、TypeScriptトランスパイル、拡張機能コンパイル、Hygieneチェック、ESLintによるコード品質検証を一括で実行します。

**業務上の目的・背景**：VSCodeは大規模なTypeScriptプロジェクトであり、数百のソースファイルと多数の組み込み拡張機能で構成されています。本バッチにより、コードの整合性と品質を検証しながら、効率的にコンパイル成果物を生成します。コンパイル結果は圧縮されてArtifactとして保存され、後続の各プラットフォームビルドで再利用されることで、ビルド全体の効率化を実現しています。

**バッチの実行タイミング**：product-buildパイプラインのCompileステージとして実行されます。単独では実行されず、必ず親パイプラインからトリガーされます。

**主要な処理内容**：
1. ソースコードのチェックアウト（distroリポジトリ含む）
2. Node.jsバージョンの設定（.nvmrcから）
3. node_modulesキャッシュの復元または依存関係インストール
4. distro品質設定のミックスイン
5. 組み込み拡張機能のインストール
6. コアコンパイル、拡張機能コンパイル、Hygiene、ESLint、各種検証の並列実行
7. コンパイル結果フォルダの検証
8. スモークテスト/統合テストスイートのコンパイル
9. ソースマップのAzureへのアップロード
10. テレメトリイベントリスト生成
11. コンパイル成果物の圧縮とArtifact公開
12. Component Governanceによる依存関係チェック

**前後の処理との関連**：本バッチはproduct-buildパイプラインの最初のステージとして実行されます。生成されたcompilation.tar.gz成果物は、Windows/Linux/macOS/Alpine/Webの各ビルドステージでダウンロードされ、プラットフォーム固有のバイナリ生成に使用されます。

**影響範囲**：Azure Pipeline Artifacts、Azure Blob Storage（ソースマップ）、後続の全プラットフォームビルドステージに影響します。

## バッチ種別

CI/CDパイプライン（コンパイル処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | product-buildパイプライン実行時 |
| 実行時刻 | 親パイプラインに依存 |
| 実行曜日 | 親パイプラインに依存 |
| 実行日 | - |
| トリガー | product-buildパイプラインからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルドエージェント | AcesShared (macOS) プールが利用可能であること |
| Node.js | .nvmrcで指定されたバージョンが利用可能 |
| Azure Key Vault | vscode-build-secretsへのアクセス権限 |
| NPM Registry | 設定されたレジストリへのアクセス |
| distroリポジトリ | microsoft/vscode-distroへのアクセス権限 |

### 実行可否判定

- 常にproduct-buildパイプラインのCompileステージとして実行
- VSCODE_COMPILE_ONLY=trueの場合、本ステージのみ実行して終了
- VSCODE_STEP_ON_IT=trueの場合、スモークテスト/統合テストコンパイルをスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NPM_REGISTRY | string | No | Azure DevOps NPM | カスタムNPMレジストリURL |
| VSCODE_QUALITY | string | No | insider | ビルド品質設定 |
| VSCODE_STEP_ON_IT | boolean | No | false | テストコンパイルスキップフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub microsoft/vscode | Git Repository | メインソースコードリポジトリ |
| GitHub microsoft/vscode-distro | Git Repository | プライベートdistroリポジトリ |
| Azure Key Vault | Secret Store | github-distro-mixin-password |
| NPM Registry | Package Registry | Node.js依存パッケージ |
| node_modulesキャッシュ | tar.gz | 以前のビルドからのキャッシュ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Pipeline Artifact: Compilation | tar.gz | コンパイル成果物 |
| Azure Blob Storage (vscodeweb) | JSON | ソースマップ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | compilation.tar.gz |
| 出力先 | $(Build.ArtifactStagingDirectory) |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

含まれるディレクトリ：
- `.build/` - ビルド中間成果物（node_modulesキャッシュ除く）
- `out-build/` - コンパイル済みメインコード
- `out-vscode-*/` - 品質別出力ディレクトリ
- `test/integration/browser/out/` - 統合テストコンパイル結果
- `test/smoke/out/` - スモークテストコンパイル結果
- `test/automation/out/` - 自動化テストコンパイル結果

## 処理フロー

### 処理シーケンス

```
1. ソースコードチェックアウト
   └─ common/checkout.ymlテンプレート使用
2. Node.jsセットアップ
   └─ .nvmrcからバージョン指定
3. distroダウンロード
   └─ distro/download-distro.ymlテンプレート使用
4. Azure Key Vaultシークレット取得
   └─ github-distro-mixin-password
5. NPMレジストリ設定
   └─ build/setup-npm-registry.ts実行
6. node_modulesキャッシュキー計算
   └─ build/azure-pipelines/common/computeNodeModulesCacheKey.ts
7. node_modulesキャッシュ復元
   └─ Cache@2タスク使用
8. キャッシュヒット時: tarアーカイブ展開
   └─ tar -xzf .build/node_modules_cache/cache.tgz
9. キャッシュミス時: npm ci実行（5回リトライ）
   └─ ELECTRON_SKIP_BINARY_DOWNLOAD=1
10. distro node_modulesミックスイン
    └─ build/azure-pipelines/distro/mixin-npm.ts
11. node_modulesアーカイブ作成
    └─ listNodeModules.ts → tar圧縮
12. distro品質ミックスイン
    └─ build/azure-pipelines/distro/mixin-quality.ts
13. 組み込み拡張機能インストール
    └─ common/install-builtin-extensions.yml
14. コンパイル&Hygiene（並列実行）
    └─ npm-run-all2: core-ci, extensions-ci, hygiene, eslint等
15. コンパイルフォルダ検証
    └─ out-build, out-vscode-*の存在確認
16. スモークテストコンパイル
    └─ test/smoke: npm run compile
17. 統合テストコンパイル
    └─ test/integration/browser: npm run compile
18. Azureシークレット取得
    └─ AzureCLI@2でIDトークン取得
19. ソースマップアップロード
    └─ build/azure-pipelines/upload-sourcemaps.ts
20. テレメトリイベントリスト生成
    └─ build/azure-pipelines/common/extract-telemetry.sh
21. 成果物圧縮
    └─ tar -cz → compilation.tar.gz
22. 組み込み拡張機能CGデータダウンロード
    └─ npm run download-builtin-extensions-cg
23. Component Detection実行
    └─ ComponentGovernanceComponentDetection@0
```

### フローチャート

```mermaid
flowchart TD
    A[ジョブ開始] --> B[チェックアウト]
    B --> C[Node.jsセットアップ]
    C --> D[distroダウンロード]
    D --> E[Key Vaultシークレット取得]
    E --> F[NPMレジストリ設定]
    F --> G[キャッシュキー計算]
    G --> H{キャッシュヒット?}
    H -->|Yes| I[キャッシュ展開]
    H -->|No| J[npm ci実行]
    J --> K[node_modulesアーカイブ作成]
    I --> L[distroミックスイン]
    K --> L
    L --> M[拡張機能インストール]
    M --> N[コンパイル & Hygiene]
    N --> O{結果検証}
    O -->|OK| P[テストコンパイル]
    O -->|NG| X[失敗終了]
    P --> Q[ソースマップアップロード]
    Q --> R[テレメトリ抽出]
    R --> S[成果物圧縮]
    S --> T[Artifact公開]
    T --> U[Component Detection]
    U --> V[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチではデータベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。全ての入出力はファイルシステムとAzure Pipeline Artifactsを介して行われます。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NPM_CI_FAILED | 依存関係エラー | npm ci が5回連続失敗 | NPMレジストリ接続確認、package-lock.json確認 |
| COMPILE_ERROR | コンパイルエラー | TypeScriptコンパイル失敗 | エラーメッセージに従いソースコード修正 |
| HYGIENE_FAILED | コード品質エラー | package.json整合性/コードスタイル違反 | npm run hygieneでローカル確認、修正 |
| ESLINT_ERROR | Lintエラー | ESLint違反 | npm run eslintでローカル確認、修正 |
| OUT_BUILD_MISSING | 検証エラー | out-buildフォルダが存在しない | コンパイルログ確認、再実行 |
| SOURCEMAP_UPLOAD_FAILED | アップロードエラー | Azureへの接続失敗 | Azure認証確認、ネットワーク確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | npm ci: 5回 |
| リトライ間隔 | 即時 |
| リトライ対象エラー | npm ci の一時的なネットワークエラー |

### 障害時対応

1. コンパイルエラーの場合、ビルドログで具体的なエラー箇所を特定
2. Hygieneエラーの場合、`npm run hygiene`をローカルで実行して問題を特定
3. 依存関係エラーの場合、package-lock.jsonの整合性を確認
4. キャッシュ関連の問題が疑われる場合、キャッシュをクリアして再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ジョブ全体 |
| コミットタイミング | ジョブ正常完了時にArtifact公開 |
| ロールバック条件 | 任意のステップ失敗時、Artifact公開せず終了 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1コンパイル/実行 |
| 目標処理時間 | 60分以内（timeoutInMinutes: 60） |
| メモリ使用量上限 | エージェント依存（macOSエージェント） |

## 排他制御

- ジョブレベルでの排他制御はなし
- 同一ビルド内で1回のみ実行（Compileステージは1ジョブ）
- node_modulesキャッシュは複数ビルドで共有される可能性あり

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、パラメータ |
| キャッシュログ | キャッシュ処理時 | キャッシュヒット/ミス情報 |
| コンパイルログ | npm run実行時 | TypeScriptコンパイル出力 |
| Hygieneログ | Hygiene実行時 | 検証結果 |
| 検証ログ | フォルダ検証時 | out-build, out-vscode-*の存在確認結果 |
| エラーログ | エラー発生時 | エラーメッセージ、終了コード |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60分超過 | Azure DevOps（タイムアウト） |
| コンパイル失敗 | 1回 | Azure DevOps通知 |
| キャッシュミス率 | 継続的なミス | パフォーマンス調査トリガー |

## 備考

- macOSエージェント（AcesShared）で実行される理由は、一部のビルドスクリプトがmacOS環境を前提としているため
- ELECTRON_SKIP_BINARY_DOWNLOAD=1とPLAYWRIGHT_SKIP_BROWSER_DOWNLOAD=1により、不要なバイナリダウンロードをスキップしてビルド時間を短縮
- npm-run-all2を使用した並列実行（-lp: 並列実行+ラベル付きログ）により、コンパイルとHygieneチェックを効率的に実行
- isProduction: falseの設定により、コンパイル成果物は本番SBOMに含まれない
