# バッチ設計書 20-compile-build-without-mangling

## 概要

本ドキュメントは、VSCode プロジェクトにおけるローカル/PRビルド用コンパイルタスク（compile-build-without-mangling）の設計を記述します。

### 本バッチの処理概要

このGulpタスクは、ローカル開発およびプルリクエスト検証向けにTypeScriptコードをコンパイルするタスクです。難読化（mangling）を無効にし、NLS（国際化）処理、ソースマップのインライン化を行いますが、コードの可読性を維持します。

**業務上の目的・背景**：ローカル開発やPR検証では、デバッグのしやすさが重要です。難読化を無効にすることで、生成されるJavaScriptコードが読みやすくなり、問題の特定が容易になります。また、ビルド時間も短縮されます。CIの初期検証フェーズでも使用され、コンパイルエラーの早期検出に役立ちます。

**バッチの実行タイミング**：
- ローカル開発でのビルド確認時
- PRパイプラインでのコンパイル検証時
- `gulp compile-build-without-mangling`コマンド実行時

**主要な処理内容**：
1. out-buildディレクトリのクリーンアップ
2. ISO日付のタイムスタンプ書き込み
3. API提案名の生成
4. TypeScriptコンパイル（難読化無効）
   - NLS処理（国際化対応）
   - ソースマップのインライン化
   - ミニフィケーション

**前後の処理との関連**：PRパイプラインの一部として実行され、コンパイルエラーがないことを確認します。compile-build-with-manglingの軽量版として位置づけられます。

**影響範囲**：out-build/ディレクトリ、開発/検証用ビルド成果物

## バッチ種別

ビルド / 開発用コンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動/PR時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | gulp compile-build-without-mangling / PRパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | .nvmrcで指定されたバージョンがインストール済み |
| npm依存関係 | npm ciまたはnpm installが完了していること |
| メモリ | 4GB以上のRAM（コンパイルに必要） |

### 実行可否判定

- メモリが4GB未満の場合、エラーで終了します
- out-buildディレクトリは自動的にクリーンアップされます

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| (なし) | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/**/*.ts | TypeScript | クライアントソースコード |
| tsconfig.json | JSON | TypeScriptコンパイル設定 |
| src/vscode-dts/*.d.ts | TypeScript | API提案定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out-build/ | JavaScript | コンパイル済みコード（難読化なし） |
| out-build/date | テキスト | ISO日付タイムスタンプ |
| out-build/**/*.js.map | JSON | ソースマップ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | *.js, *.js.map |
| 出力先 | out-build/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. compile-build-without-mangling（直列実行）
   ├─ rimraf('out-build')
   │   └─ out-buildディレクトリのクリーンアップ
   ├─ writeISODate('out-build')
   │   └─ タイムスタンプの書き込み
   ├─ compileApiProposalNamesTask
   │   └─ API提案名の生成
   └─ compileTask('src', 'out-build', true, { disableMangle: true })
       ├─ TypeScriptファイル読み込み
       ├─ mangleStream = es.through()（スルー）
       │   └─ 難読化処理をスキップ
       ├─ TypeScriptコンパイル
       ├─ NLS処理
       │   └─ preserveEnglish: false
       └─ ソースマップ書き込み
           └─ inlineSources: true
```

### フローチャート

```mermaid
flowchart TD
    A[gulp compile-build-without-mangling 開始] --> B[rimraf out-build/]
    B --> C[writeISODate]
    C --> D[compile-api-proposal-names]
    D --> E[compileTask without mangling]

    E --> E1[メモリチェック >= 4GB]
    E1 -->|OK| E2[mangleStream = es.through]
    E1 -->|NG| F[エラー終了]

    E2 --> E3[TypeScript読み込み]
    E3 --> E4[mangleStreamスルー - 難読化スキップ]
    E4 --> E5[MonacoGenerator]
    E5 --> E6[TypeScriptコンパイル]
    E6 --> E7[NLS処理]
    E7 --> E8[ソースマップ書き込み]
    E8 --> E9[gulp.dest out-build/]

    E9 --> G[gulp compile-build-without-mangling 終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しないビルドタスク）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | メモリ不足 | RAMが4GB未満 | メモリを増設またはスワップを設定 |
| - | TypeScriptエラー | コード構文エラー | エラー箇所を修正 |
| - | monaco.d.ts生成エラー | API定義の不整合 | API定義を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

コンパイルエラーが発生した場合は、エラーメッセージを確認し、該当ファイルを修正してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 3-10分（難読化なしのため高速） |
| メモリ使用量上限 | 4GB以上必須 |

## 排他制御

同時に複数のcompile-build-without-manglingタスクを実行することは推奨されません。out-buildディレクトリの競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名 |
| コンパイルログ | コンパイル中 | ファイル名、エラー/警告 |
| monaco.d.tsログ | API生成時 | 変更の有無、処理時間 |
| 終了ログ | タスク終了時 | 成功/失敗、処理時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| コンパイルエラー | 1件 | コンソール出力 / PRステータス |
| 警告 | 多数 | コンソール出力 |

## 備考

- disableMangle: trueで難読化が無効化されます（makeCompileBuildTask(true)で呼び出し）
- 難読化なしのため、compile-build-with-manglingより高速です
- 生成されるコードは可読性が高く、デバッグに適しています
- PRパイプラインでは、このタスクでコンパイルエラーを早期検出します
- compile-build-with-manglingとの違いは、disableMangleの値のみです
- mangleStream変数はes.through()（空のストリーム）として初期化され、難読化処理をスキップします
- build: trueにより、NLS処理とinlineSourcesは有効です（本番ビルドと同じ設定）
- out-buildディレクトリはcompile-build-with-manglingと共有されるため、両方を同時に実行しないでください
