# バッチ設計書 21-hygiene

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるコード品質チェックバッチ「hygiene」の設計内容を記載する。このバッチはGulpタスクとして実装されており、ソースコードの品質を自動的に検証する。

### 本バッチの処理概要

hygieneバッチは、VSCodeプロジェクト全体のコード品質を維持するための自動検証ツールである。開発者がコミット前に実行することで、コーディング規約違反や潜在的な問題を早期に検出できる。

**業務上の目的・背景**：大規模なオープンソースプロジェクトであるVSCodeでは、多数の開発者が同時に作業するため、コードの一貫性と品質を維持することが重要である。hygieneバッチは、コピーライトヘッダーの欠落、不正なインデント、禁止された文字の使用、コードスタイル違反などを自動検出し、コードベースの品質を高いレベルで維持する。

**バッチの実行タイミング**：開発者によるコミット前（precommitフック）、プルリクエスト時のCI/CDパイプライン、および手動実行時に実行される。

**主要な処理内容**：
1. package.json整合性チェック（ルートと各サブディレクトリ間の依存関係バージョン一致確認）
2. コピーライトヘッダーの存在・形式確認
3. Unicode文字の使用制限チェック（ASCII以外の文字検出）
4. インデントの検証（タブ文字使用の強制）
5. TypeScriptフォーマッティングチェック
6. ESLintによる静的解析
7. Stylelintによるスタイルシートの検証

**前後の処理との関連**：compileタスクの前に実行されることが推奨される。CI/CDパイプラインでは、core-ciタスクの一部として実行される。

**影響範囲**：VSCodeリポジトリ内のすべてのソースファイル（TypeScript、JavaScript、CSS、JSON等）が対象となる。検証に失敗した場合、ビルドプロセスが中断される。

## バッチ種別

コード品質検証 / 静的解析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（コミット前、PR時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | gitフック（precommit）/ CI/CD / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| 依存関係 | npm installが完了していること |
| Gitリポジトリ | VSCodeのGitリポジトリ内で実行されること |

### 実行可否判定

- Gitステージングエリアに変更がある場合に実行（precommitフック時）
- 手動実行時は常に全ファイルを対象とする
- BUILD_SOURCEVERSION環境変数が設定されている場合、product.jsonの検証をスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| some | string[] / NodeJS.ReadWriteStream | No | undefined | 検証対象ファイルのパス配列またはストリーム |
| runEslint | boolean | No | true | ESLintを実行するかどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースファイル | .ts, .js, .css, .json等 | 検証対象のソースコード |
| package.json | JSON | プロジェクト設定ファイル |
| product.json | JSON | VSCode製品設定ファイル |
| .git/index | Git Index | ステージングされたファイル情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証結果メッセージ |
| 標準エラー出力 | テキスト | エラー・警告メッセージ |

### 出力ファイル仕様

ファイル出力は行わない。すべての結果はコンソールに出力される。

## 処理フロー

### 処理シーケンス

```
1. 入力ソースの決定
   └─ 引数指定がなければGitステージングエリアからファイル一覧を取得
2. フィルタリング
   └─ 各検証タイプに応じたファイルフィルタを適用
3. product.json検証
   └─ extensionsGalleryフィールドの存在をチェック
4. Unicode文字検証
   └─ 許可されていないUnicode文字を検出
5. インデント検証
   └─ タブ以外のインデントを検出
6. コピーライトヘッダー検証
   └─ Microsoftコピーライトヘッダーの存在と形式を確認
7. TypeScriptフォーマット検証
   └─ formatterによるコードスタイルチェック
8. ESLint実行（オプション）
   └─ 静的解析によるコード品質チェック
9. Stylelint実行
   └─ CSSスタイルシートの検証
10. 結果集計
    └─ エラー件数をカウントし、0件以外はエラーとして終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数指定あり?}
    B -->|あり| C[指定ファイルを使用]
    B -->|なし| D[Gitステージングファイル取得]
    C --> E[ファイルフィルタリング]
    D --> E
    E --> F[product.json検証]
    F --> G[Unicode文字検証]
    G --> H[インデント検証]
    H --> I[コピーライトヘッダー検証]
    I --> J[TypeScriptフォーマット検証]
    J --> K{ESLint実行?}
    K -->|Yes| L[ESLint実行]
    K -->|No| M[Stylelint実行]
    L --> M
    M --> N{エラーあり?}
    N -->|あり| O[エラー終了]
    N -->|なし| P[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Unicode違反 | 禁止Unicode文字検出 | // allow-any-unicode-next-lineコメントを追加 |
| - | インデント違反 | タブ以外のインデント | タブ文字に修正 |
| - | コピーライト違反 | ヘッダー欠落/不正 | 正しいコピーライトヘッダーを追加 |
| - | フォーマット違反 | コードスタイル不正 | 'Format Document'コマンドを実行 |
| - | ESLintエラー | 静的解析違反 | ESLintルールに従って修正 |
| - | Stylelintエラー | CSSスタイル違反 | Stylelintルールに従って修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時は標準エラー出力にメッセージが表示される。開発者は指摘された問題を修正してから再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用処理） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千ファイル |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 8192MB（--max-old-space-size設定） |

## 排他制御

同時実行は可能だが、同一ファイルに対する変更操作と並行して実行すると予期しない結果になる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Starting hygiene..." |
| 進捗ログ | TRAVIS環境で10ファイルごと | "." |
| エラーログ | 違反検出時 | ファイルパス、行番号、エラー内容 |
| 終了ログ | バッチ終了時 | エラー件数（エラー時のみ） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | 1件以上 | CI/CDパイプライン失敗通知 |

## 備考

- precommitフックとして使用する場合は`npm run precommit`で実行される
- Gulpタスクとして実行する場合は`npm run hygiene`を使用
- product.jsonの検証はCI/CD環境（BUILD_SOURCEVERSION設定時）ではスキップされる
