# バッチ設計書 22-transpile-client-esbuild

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるSWC/esbuildを使用した高速トランスパイルバッチ「transpile-client-esbuild」の設計内容を記載する。このバッチはGulpタスクとして実装されており、開発時の高速ビルドを実現する。

### 本バッチの処理概要

transpile-client-esbuildバッチは、VSCodeのクライアントサイドTypeScriptソースコードを高速にJavaScriptへトランスパイルするためのタスクである。esbuildを使用することで、従来のTypeScriptコンパイラより大幅に高速な変換を実現する。

**業務上の目的・背景**：VSCodeの開発では、ソースコードの変更を素早く確認できることが重要である。従来のTypeScriptコンパイラは正確な型チェックを行うが、大規模コードベースでは時間がかかる。transpile-client-esbuildは型チェックをスキップしてトランスパイルのみを行うことで、開発時のイテレーション速度を大幅に向上させる。

**バッチの実行タイミング**：開発者がローカル環境で高速ビルドを必要とする際に手動で実行される。watchタスクの初期ビルドとしても使用可能。

**主要な処理内容**：
1. 出力ディレクトリ（out）のクリーンアップ
2. srcディレクトリからTypeScriptファイルを読み込み
3. esbuildを使用した高速トランスパイル（型チェックなし）
4. ソースマップの生成
5. outディレクトリへの出力

**前後の処理との関連**：watchタスクの高速な初期ビルドとして使用される。完全なビルドが必要な場合はcompileタスクを使用する。CI/CDパイプラインでは通常compile-build-with/without-manglingタスクが使用される。

**影響範囲**：src/ディレクトリ配下のすべてのTypeScriptファイルがトランスパイル対象となり、out/ディレクトリに出力される。型チェックをスキップするため、型エラーは検出されない。

## バッチ種別

トランスパイル処理 / 開発ビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| 依存関係 | npm installが完了していること |
| ソースコード | src/ディレクトリにTypeScriptソースが存在すること |

### 実行可否判定

- 常に実行可能
- 出力先ディレクトリは実行時にクリーンアップされる

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| src | string | Yes（内部固定） | "src" | ソースディレクトリパス |
| out | string | Yes（内部固定） | "out" | 出力ディレクトリパス |
| esbuild | boolean | Yes（内部固定） | true | esbuildを使用するかどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/**/*.ts | TypeScript | トランスパイル対象のソースファイル |
| src/**/*.js | JavaScript | そのままコピーされるファイル |
| src/tsconfig.json | JSON | TypeScript設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out/**/*.js | JavaScript | トランスパイルされたJavaScriptファイル |
| out/**/*.js.map | SourceMap | デバッグ用ソースマップ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元ファイル名の拡張子を.jsに変更 |
| 出力先 | out/ディレクトリ（srcと同じ構造） |
| 文字コード | UTF-8 |
| ソースマップ | 外部ファイル（.js.map） |

## 処理フロー

### 処理シーケンス

```
1. 出力ディレクトリのクリーンアップ
   └─ rimrafでout/ディレクトリを削除
2. コンパイルパイプラインの作成
   └─ createCompile関数でトランスパイル専用パイプライン構築
3. ソースファイルの読み込み
   └─ gulp.srcでsrc/**のファイルを読み込み
4. トランスパイル処理
   └─ esbuildを使用した高速変換
5. 出力処理
   └─ gulp.destでout/へ出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[out/ディレクトリ削除]
    B --> C[コンパイルパイプライン作成]
    C --> D[src/**ファイル読み込み]
    D --> E{TypeScriptファイル?}
    E -->|Yes| F[esbuildでトランスパイル]
    E -->|No| G[そのままコピー]
    F --> H[ソースマップ生成]
    G --> I[out/へ出力]
    H --> I
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 構文エラー | TypeScript構文エラー | ソースコードを修正 |
| - | ファイル読み込みエラー | ソースファイルが存在しない | ファイルパスを確認 |
| - | 出力エラー | 出力先への書き込み失敗 | ディスク容量・権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はエラーメッセージがコンソールに出力される。構文エラーの場合は該当ファイルを修正して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千ファイル |
| 目標処理時間 | 数十秒（従来のtsc比で大幅短縮） |
| メモリ使用量上限 | 8192MB（--max-old-space-size設定） |

## 排他制御

watchタスクと同時実行すると競合する可能性がある。開発時はwatchタスクを使用することを推奨。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名表示 |
| 進捗ログ | 処理中 | Gulp標準の進捗表示 |
| エラーログ | エラー発生時 | エラー詳細（ファイル名、行番号等） |
| 終了ログ | タスク終了時 | 処理時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | - | コンソール出力のみ |
| エラー件数 | 1件以上 | コンソール出力のみ |

## 備考

- 型チェックを行わないため、完全な検証にはcompileタスクを使用すること
- esbuildのバージョンはdevDependenciesで管理される
- VSCODE_NO_SOURCEMAP環境変数を設定するとソースマップ生成をスキップ可能
- 開発時の高速ビルドを目的としており、本番ビルドには使用しない
