# バッチ設計書 23-compile-extensions

## 概要

本ドキュメントは、VSCodeプロジェクトにおける組み込み拡張機能コンパイルバッチ「compile-extensions」の設計内容を記載する。このバッチはGulpタスクとして実装されており、VSCodeに同梱される各種拡張機能のTypeScriptコードをコンパイルする。

### 本バッチの処理概要

compile-extensionsバッチは、VSCodeに組み込まれている約40以上の拡張機能のTypeScriptソースコードを一括でコンパイルするタスクである。各拡張機能は個別のtsconfig.jsonを持ち、それぞれ独立してコンパイルされる。

**業務上の目的・背景**：VSCodeには多数の組み込み拡張機能（言語サポート、Git連携、デバッグ機能等）が含まれている。これらの拡張機能は独立したTypeScriptプロジェクトとして管理されており、効率的なコンパイルプロセスが必要である。compile-extensionsは全拡張機能を並列でコンパイルし、開発効率を向上させる。

**バッチの実行タイミング**：開発時のフルビルド時、CI/CDパイプラインでの検証時、リリースビルド前の検証時に実行される。

**主要な処理内容**：
1. 各拡張機能の出力ディレクトリ（out）のクリーンアップ
2. 拡張機能ごとのtsconfig.jsonに基づくコンパイル
3. tsbを使用したTypeScriptコンパイル
4. ソースマップの生成
5. 各拡張機能のout/ディレクトリへの出力
6. すべての拡張機能の並列コンパイル

**前後の処理との関連**：compileタスクの一部として実行される。watch-extensionsタスクは同様の構造で監視モードでの増分コンパイルを提供する。CI/CDではextensions-ciタスクとして実行される。

**影響範囲**：extensions/ディレクトリ配下の約40以上の組み込み拡張機能すべてがコンパイル対象となる。

## バッチ種別

コンパイル処理 / ビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| 依存関係 | npm installが完了していること（ルート及び各拡張機能） |
| 拡張機能ソース | extensions/ディレクトリに拡張機能が存在すること |

### 実行可否判定

- 常に実行可能
- 各拡張機能の出力先ディレクトリは実行時にクリーンアップされる

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータは受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| extensions/*/tsconfig.json | JSON | 各拡張機能のTypeScript設定 |
| extensions/*/src/**/*.ts | TypeScript | コンパイル対象のソースファイル |
| extensions/*/package.json | JSON | 拡張機能のメタデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| extensions/*/out/**/*.js | JavaScript | コンパイルされたJavaScriptファイル |
| extensions/*/out/**/*.js.map | SourceMap | デバッグ用ソースマップ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元ファイル名の拡張子を.jsに変更 |
| 出力先 | 各拡張機能のout/ディレクトリ |
| 文字コード | UTF-8 |
| ソースマップ | 外部ファイル（.js.map） |

## 処理フロー

### 処理シーケンス

```
1. コンパイル対象拡張機能の列挙
   └─ 定義済みの拡張機能tsconfig.jsonリストを取得
2. 各拡張機能に対して並列実行:
   a. 出力ディレクトリのクリーンアップ
      └─ rimrafで拡張機能のout/ディレクトリを削除
   b. コンパイルパイプラインの作成
      └─ tsbを使用したTypeScriptコンパイラ設定
   c. ソースファイルの読み込み
      └─ src/**/*.ts及び非TypeScriptファイルを読み込み
   d. TypeScriptコンパイル
      └─ tsbによるコンパイル実行
   e. ソースマップ生成・出力
      └─ gulp-sourcemapsで.mapファイル生成
   f. 出力処理
      └─ gulp.destでout/へ出力
3. 全拡張機能の完了を待機
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[拡張機能リスト取得]
    B --> C[並列処理開始]
    C --> D1[拡張機能1: clean]
    C --> D2[拡張機能2: clean]
    C --> DN[拡張機能N: clean]
    D1 --> E1[コンパイル]
    D2 --> E2[コンパイル]
    DN --> EN[コンパイル]
    E1 --> F1[出力]
    E2 --> F2[出力]
    EN --> FN[出力]
    F1 --> G[全タスク完了待機]
    F2 --> G
    FN --> G
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | TypeScriptエラー | 型エラー・構文エラー | ソースコードを修正 |
| - | 依存関係エラー | node_modules不足 | npm installを実行 |
| - | 設定エラー | tsconfig.json不正 | 設定ファイルを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はreporterを通じてエラー詳細がコンソールに出力される。該当する拡張機能のソースコードまたは設定を修正して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約40拡張機能 |
| 目標処理時間 | 数分（並列処理による短縮） |
| メモリ使用量上限 | 8192MB（--max-old-space-size設定） |

## 排他制御

watch-extensionsタスクと同時実行すると競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名表示 |
| 進捗ログ | 各拡張機能コンパイル完了時 | 拡張機能名 |
| エラーログ | コンパイルエラー発生時 | ファイル名、行番号、エラー内容 |
| 終了ログ | タスク終了時 | 処理時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| コンパイルエラー | 1件以上 | CI/CDパイプライン失敗通知 |

## 備考

- 対象拡張機能リストはgulpfile.extensions.ts内にハードコードされている
- EventEmitter.defaultMaxListenersは100に設定（並列処理対応）
- esbuildによるトランスパイルオプションあり（transpileWithEsbuild）
- CDN用のsourceMappingURLが設定される（ビルド時）
- コンパイル対象の拡張機能例：
  - css-language-features
  - git
  - github-authentication
  - html-language-features
  - json-language-features
  - markdown-language-features
  - typescript-language-features
  - 等
