# バッチ設計書 24-watch-extensions

## 概要

本ドキュメントは、VSCodeプロジェクトにおける拡張機能ファイル監視・自動再コンパイルバッチ「watch-extensions」の設計内容を記載する。このバッチはGulpタスクとして実装されており、開発時にファイル変更を検知して自動的に再コンパイルを行う。

### 本バッチの処理概要

watch-extensionsバッチは、VSCodeの組み込み拡張機能のソースファイルを監視し、変更を検知した際に該当ファイルのみを自動的に再コンパイルする増分ビルドタスクである。開発者はこのタスクを起動しておくことで、コード変更後の手動ビルドを省略できる。

**業務上の目的・背景**：VSCode拡張機能の開発では、頻繁なコード修正とテストのサイクルが発生する。watch-extensionsは変更されたファイルのみを即座に再コンパイルすることで、開発者の待ち時間を最小化し、開発効率を大幅に向上させる。従来のフルビルドと比較して、増分コンパイルにより数秒での反映が可能になる。

**バッチの実行タイミング**：開発者がローカル環境で拡張機能を開発する際に、バックグラウンドで継続実行される。通常、開発セッションの開始時に一度起動し、終了まで実行し続ける。

**主要な処理内容**：
1. 各拡張機能の出力ディレクトリ（out）の初期クリーンアップ
2. ファイルシステムウォッチャーの設定
3. ソースファイル変更の検知（readDelay: 200ms）
4. 変更されたファイルのみの増分コンパイル
5. 出力ディレクトリへの書き出し
6. すべての拡張機能を並列で監視

**前後の処理との関連**：watch-clientタスクと並行して実行されることが多い。npm run watchコマンドで両方が同時に起動される。compile-extensionsは同様の処理を一度だけ実行する。

**影響範囲**：extensions/ディレクトリ配下の組み込み拡張機能すべてが監視対象。ファイル変更時に該当拡張機能のoutディレクトリが更新される。

## バッチ種別

ファイル監視 / 増分コンパイル / 開発ビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 開発時に継続実行 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動起動 / ファイル変更イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| 依存関係 | npm installが完了していること（ルート及び各拡張機能） |
| 拡張機能ソース | extensions/ディレクトリに拡張機能が存在すること |

### 実行可否判定

- 常に実行可能
- 初回起動時に各拡張機能の出力先ディレクトリがクリーンアップされる

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータは受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| extensions/*/tsconfig.json | JSON | 各拡張機能のTypeScript設定 |
| extensions/*/src/**/*.ts | TypeScript | 監視対象のソースファイル |
| extensions/*/src/**/* | 各種 | 非TypeScriptファイル（そのままコピー） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| extensions/*/out/**/*.js | JavaScript | コンパイルされたJavaScriptファイル |
| extensions/*/out/**/*.js.map | SourceMap | デバッグ用ソースマップ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元ファイル名の拡張子を.jsに変更 |
| 出力先 | 各拡張機能のout/ディレクトリ |
| 文字コード | UTF-8 |
| ソースマップ | 外部ファイル（.js.map） |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   a. 各拡張機能の出力ディレクトリをクリーンアップ
   b. コンパイルパイプラインを作成
2. ファイルウォッチャーの起動
   └─ chokidarベースのウォッチャーを各拡張機能に設定
3. 初期コンパイル
   └─ 全ソースファイルの初回コンパイル
4. ファイル変更イベントのループ（継続実行）
   a. ファイル変更を検知
   b. readDelay（200ms）待機
   c. 変更ファイルのみを増分コンパイル
   d. 出力ディレクトリへ書き出し
   e. 次の変更を待機
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[出力ディレクトリクリーンアップ]
    B --> C[ファイルウォッチャー起動]
    C --> D[初期コンパイル実行]
    D --> E[ファイル変更待機]
    E --> F{変更検知?}
    F -->|No| E
    F -->|Yes| G[200ms待機]
    G --> H[変更ファイルの増分コンパイル]
    H --> I[出力ディレクトリへ書き出し]
    I --> E
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | TypeScriptエラー | 型エラー・構文エラー | ソースコードを修正（タスクは継続） |
| - | ファイル監視エラー | ウォッチャー制限超過 | ulimit設定を確認 |
| - | 出力エラー | 出力先への書き込み失敗 | ディスク容量・権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動（次回変更時に再試行） |
| リトライ間隔 | 変更検知時 |
| リトライ対象エラー | コンパイルエラー |

### 障害時対応

コンパイルエラーが発生してもウォッチャーは継続動作する。開発者がソースコードを修正すると、次の変更検知時に再コンパイルが試行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変更ファイルのみ（増分） |
| 目標処理時間 | 変更検知から数秒以内 |
| メモリ使用量上限 | 8192MB（--max-old-space-size設定） |

## 排他制御

compile-extensionsタスクと同時実行すると競合する可能性がある。watchタスク実行中は手動コンパイルを避けることを推奨。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名表示 |
| 変更検知ログ | ファイル変更時 | 変更されたファイルパス |
| コンパイルログ | コンパイル完了時 | 処理結果 |
| エラーログ | コンパイルエラー時 | ファイル名、行番号、エラー内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| コンパイルエラー | - | コンソール出力のみ（タスク継続） |

## 備考

- npm run watch-extensionsで単独実行可能
- npm run watchでwatch-clientと並行実行
- readDelayは200msに設定（連続する変更をまとめる）
- EventEmitter.defaultMaxListenersは100に設定（並列監視対応）
- ウォッチャーはCtrl+Cで停止
- util.incremental関数で増分コンパイルを実現
- ビルドモードはfalse（開発用設定）
