# バッチ設計書 25-editor-distro

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるMonaco Editorディストリビューションビルドバッチ「editor-distro」の設計内容を記載する。このバッチはGulpタスクとして実装されており、VSCodeのエディタコア部分をスタンドアロンの「monaco-editor-core」パッケージとして配布可能な形式にビルドする。

### 本バッチの処理概要

editor-distroバッチは、VSCodeの中核であるエディタコンポーネントを抽出し、Monaco Editorとして独立して使用できるnpmパッケージを生成する。これにより、Webアプリケーションやその他のプロジェクトでVSCodeのエディタ機能を利用可能にする。

**業務上の目的・背景**：Monaco Editorは、VSCodeのエディタ部分を独立したライブラリとして提供するプロジェクトである。多くのWeb IDEやオンラインエディタで採用されており、VSCodeと同等のエディタ体験を他のアプリケーションに組み込むことができる。editor-distroはこのMonaco Editorの配布パッケージを生成する重要なビルドプロセスである。

**バッチの実行タイミング**：Monaco Editorのリリース時、VSCodeの新バージョンリリース時、またはエディタコア部分の変更を配布パッケージに反映する際に実行される。

**主要な処理内容**：
1. out-editor-srcディレクトリとout-monaco-editor-coreディレクトリのクリーンアップ
2. VSCodeソースからエディタ関連コードの抽出（Tree Shaking）
3. ESモジュール形式へのコンパイル
4. NLS（ローカライゼーション）ファイルの処理
5. 型定義ファイル（monaco.d.ts）の生成
6. package.json、README、LICENSE等のリソースファイル配置
7. 依存関係（marked、dompurify）のバージョン設定

**前後の処理との関連**：extract-editor-srcタスクで抽出、compile-editor-esmでコンパイル、final-editor-resourcesでリソース配置という順序で実行される。npm publishでnpmレジストリへの公開が可能。

**影響範囲**：out-editor-src/とout-monaco-editor-core/ディレクトリに出力される。monaco-editor-coreパッケージとしてnpmに公開される。

## バッチ種別

パッケージビルド / ディストリビューション生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリース時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / リリースパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| 依存関係 | npm installが完了していること |
| monaco.d.ts | src/vs/monaco.d.tsが最新であること |
| cgmanifest.json | marked及びdompurifyのバージョン情報が正しく設定されていること |

### 実行可否判定

- 常に実行可能
- 出力先ディレクトリは実行時にクリーンアップされる

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータは受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/vs/editor/**/*.ts | TypeScript | エディタコアソースコード |
| src/vs/monaco.d.ts | TypeScript定義 | Monaco API型定義 |
| build/monaco/monaco.usage.recipe | テキスト | API使用箇所の定義 |
| build/monaco/package.json | JSON | パッケージメタデータ |
| build/monaco/LICENSE | テキスト | ライセンスファイル |
| build/monaco/ThirdPartyNotices.txt | テキスト | サードパーティ通知 |
| src/vs/base/common/marked/cgmanifest.json | JSON | markedバージョン情報 |
| src/vs/base/browser/dompurify/cgmanifest.json | JSON | dompurifyバージョン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out-editor-src/ | TypeScript | 抽出されたエディタソース（中間成果物） |
| out-monaco-editor-core/esm/ | ESモジュール | コンパイル済みESモジュール |
| out-monaco-editor-core/package.json | JSON | npmパッケージ設定 |
| out-monaco-editor-core/monaco.d.ts | TypeScript定義 | 型定義ファイル |
| out-monaco-editor-core/LICENSE | テキスト | ライセンスファイル |
| out-monaco-editor-core/README.md | Markdown | READMEファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| パッケージ名 | monaco-editor-core |
| 出力先 | out-monaco-editor-core/ |
| モジュール形式 | ESM（ESモジュール） |
| 型定義 | 同梱（editor.api.d.ts） |

## 処理フロー

### 処理シーケンス

```
1. クリーンアップ（並列実行）
   a. out-editor-src/ディレクトリ削除
   b. out-monaco-editor-core/ディレクトリ削除
2. エディタソース抽出（extractEditorSrcTask）
   a. monaco-api.tsでAPI使用箇所を分析
   b. standalone.extractEditorでTree Shaking
   c. エントリポイント設定（editor.main.ts等）
   d. out-editor-src/へ出力
3. ESモジュールコンパイル（compileEditorESMTask）
   a. TypeScriptコンパイル
   b. NLS処理（多言語対応）
   c. out-monaco-editor-core/esm/へ出力
4. リソースファイル配置（finalEditorResourcesTask）
   a. LICENSE、ThirdPartyNotices.txtをコピー
   b. monaco.d.tsをコピー
   c. editor.api.d.tsを生成（外部向け型定義）
   d. package.jsonを生成（依存関係バージョン含む）
   e. version.txtを生成
   f. README.mdを配置
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[並列クリーンアップ]
    B --> B1[out-editor-src削除]
    B --> B2[out-monaco-editor-core削除]
    B1 --> C[エディタソース抽出]
    B2 --> C
    C --> D[API使用箇所分析]
    D --> E[Tree Shaking実行]
    E --> F[中間ソース出力]
    F --> G[ESモジュールコンパイル]
    G --> H[NLS処理]
    H --> I[ESM出力]
    I --> J[リソースファイル配置]
    J --> K[package.json生成]
    K --> L[型定義ファイル配置]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | TypeScriptエラー | 型エラー・構文エラー | ソースコードを修正 |
| - | cgmanifestエラー | バージョン情報読み取り失敗 | cgmanifest.jsonを確認 |
| - | 依存関係エラー | marked/dompurifyバージョン未設定 | cgmanifest.jsonを更新 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時は該当するソースファイルまたは設定ファイルを修正して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | エディタコア全ファイル |
| 目標処理時間 | 数分 |
| メモリ使用量上限 | 8192MB（--max-old-space-size設定） |

## 排他制御

同時実行は想定されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名表示 |
| 進捗ログ | 各サブタスク完了時 | サブタスク名 |
| エラーログ | エラー発生時 | エラー詳細 |
| 終了ログ | タスク終了時 | 処理時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルドエラー | 1件以上 | リリースパイプライン失敗通知 |

## 備考

- gulp editor-distroで実行
- Tree ShakingのshakeLevelは2（ClassMembersレベル）
- エントリポイント：
  - vs/editor/editor.main.ts
  - vs/editor/editor.worker.start.ts
  - vs/editor/common/services/editorWebWorkerMain.ts
- 追加コピーファイル：
  - vs/base/browser/dompurify/dompurify.js
  - vs/base/common/marked/marked.js
- 多言語対応：defaultLanguages + extraLanguages
- バージョン情報はbuild/monaco/package.jsonで管理
- npm publish前にmonacodtsタスクでmonaco.d.tsを更新することを推奨
