# バッチ設計書 26-postinstall

## 概要

本ドキュメントは、VSCodeプロジェクトにおける依存関係インストール後処理バッチ「postinstall」の設計内容を記載する。このバッチはnpmスクリプトとして実装されており、npm install完了後に自動的に実行される。

### 本バッチの処理概要

postinstallバッチは、VSCodeプロジェクトのルートでnpm installが完了した後に自動的に実行され、各サブディレクトリ（build、extensions、remote等）のnode_modulesをインストールする。これにより、複雑なモノレポ構造のVSCodeプロジェクト全体の依存関係が一括でセットアップされる。

**業務上の目的・背景**：VSCodeは多数のサブプロジェクト（ビルドツール、拡張機能、リモート開発サーバー等）で構成されるモノレポ構造を採用している。各サブプロジェクトは独自のpackage.jsonを持ち、個別の依存関係を必要とする。postinstallは開発者が単一のnpm installコマンドで全プロジェクトの依存関係をインストールできるようにし、セットアップの手間を大幅に削減する。

**バッチの実行タイミング**：ルートディレクトリでnpm install（またはnpm ci）が完了した直後に自動的に実行される。

**主要な処理内容**：
1. 対象ディレクトリリスト（dirs）の読み込み
2. 各ディレクトリに対してnpm install（またはnpm ci）を実行
3. build、remoteディレクトリでは.npmrc設定の適用
4. リモートディレクトリではDocker環境でのインストール対応
5. @parcel/watcherプレビルドモジュールの削除
6. Git設定の更新（pull.rebase、blame.ignoreRevsFile）

**前後の処理との関連**：preinstallスクリプトが先に実行される。postinstall完了後、開発者はビルドやテストを実行可能になる。

**影響範囲**：約60以上のサブディレクトリのnode_modulesがインストールされる。Git設定も更新される。

## バッチ種別

依存関係インストール / セットアップ処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | npm install実行時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | npm postinstallフック（自動） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| npm | npmがインストールされていること |
| preinstall完了 | preinstallスクリプトが正常終了していること |
| ネットワーク接続 | npmレジストリへのアクセスが可能であること |

### 実行可否判定

- npm install/ci実行時に自動的に実行される
- 環境変数npm_commandでinstall/ciの判定を行う

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| npm_command | 環境変数 | No | "install" | 実行するnpmコマンド（install/ci） |
| VSCODE_REMOTE_DEPENDENCIES_CONTAINER_NAME | 環境変数 | No | なし | Dockerコンテナ名（リモートビルド時） |
| npm_config_arch | 環境変数 | No | なし | ターゲットアーキテクチャ |
| VSCODE_REMOTE_CC | 環境変数 | No | なし | リモート用Cコンパイラ |
| VSCODE_REMOTE_CXX | 環境変数 | No | なし | リモート用C++コンパイラ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| build/npm/dirs.ts | TypeScript | 対象ディレクトリリスト |
| */package.json | JSON | 各サブプロジェクトの依存関係定義 |
| */.npmrc | テキスト | npm設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| */node_modules/ | ディレクトリ | インストールされた依存関係 |
| .git/config | Git設定 | pull.rebase、blame.ignoreRevsFile設定 |

### 出力ファイル仕様

各サブディレクトリにnode_modulesディレクトリが作成される。

## 処理フロー

### 処理シーケンス

```
1. 対象ディレクトリリストの読み込み
   └─ build/npm/dirs.tsからdirsを取得
2. 各ディレクトリに対してループ処理
   a. ルートディレクトリ（空文字）の場合
      └─ @parcel/watcherプレビルドモジュールの削除のみ
   b. buildディレクトリの場合
      └─ 環境変数設定（CC、CXX等）
      └─ .npmrc設定の適用
      └─ npm install実行
   c. remoteディレクトリの場合
      └─ Docker環境判定
      └─ Docker内またはローカルでnpm install実行
      └─ .npmrc設定の適用
   d. その他のディレクトリの場合
      └─ npm install実行
   e. @parcel/watcherプレビルドモジュールの削除
3. Git設定の更新
   └─ git config pull.rebase merges
   └─ git config blame.ignoreRevsFile .git-blame-ignore-revs
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ディレクトリリスト読み込み]
    B --> C[ディレクトリループ開始]
    C --> D{ルートディレクトリ?}
    D -->|Yes| E[parcelモジュール削除]
    D -->|No| F{buildディレクトリ?}
    F -->|Yes| G[環境変数設定]
    G --> H[.npmrc適用]
    H --> I[npm install実行]
    F -->|No| J{remoteディレクトリ?}
    J -->|Yes| K{Docker環境?}
    K -->|Yes| L[Docker内でnpm install]
    K -->|No| M[ローカルnpm install]
    J -->|No| N[npm install実行]
    E --> O[次のディレクトリ]
    I --> P[parcelモジュール削除]
    L --> P
    M --> P
    N --> P
    P --> O
    O --> C
    C --> Q[全ディレクトリ完了]
    Q --> R[Git設定更新]
    R --> S[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | npm installエラー | 依存関係解決失敗 | package-lock.jsonを削除して再試行 |
| - | ネットワークエラー | npmレジストリ接続失敗 | ネットワーク接続を確認 |
| - | 権限エラー | ファイル書き込み失敗 | ディレクトリ権限を確認 |
| - | Docker起動エラー | コンテナ起動失敗 | Docker環境を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（npm自体のリトライに依存） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はプロセスがexit code 1で終了する。エラーメッセージに従って問題を修正し、npm installを再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約60ディレクトリ |
| 目標処理時間 | 数分〜10分（ネットワーク速度依存） |
| メモリ使用量上限 | npmデフォルト |

## 排他制御

npm installは通常排他的に実行される。同時実行は推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ディレクトリ処理開始時 | [ディレクトリ名] Installing dependencies... |
| 進捗ログ | npm install出力 | npmの標準出力 |
| 削除ログ | parcelモジュール削除時 | Removed @parcel/watcher prebuilt module |
| エラーログ | エラー発生時 | ERRメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| インストールエラー | 1件以上 | コンソール出力 |

## 備考

- 対象ディレクトリはbuild/npm/dirs.tsで定義（約60以上）
- 主要ディレクトリ：
  - build（ビルドツール）
  - extensions（各拡張機能）
  - remote（リモート開発サーバー）
  - test/smoke、test/automation等（テスト関連）
- .build/distro/npm/が存在する場合、追加ディレクトリが対象に含まれる
- macOSのbuild/remoteディレクトリではnpm_config_force_process_config=trueを設定
- @parcel/watcherプレビルドモジュールはプラットフォーム互換性のため削除される
- node-gypのパスはbuild/npm/gyp/node_modules/.bin/node-gypに設定
