# バッチ設計書 27-preinstall

## 概要

本ドキュメントは、VSCodeプロジェクトにおける依存関係インストール前処理バッチ「preinstall」の設計内容を記載する。このバッチはnpmスクリプトとして実装されており、npm install実行前に自動的に実行される。

### 本バッチの処理概要

preinstallバッチは、VSCodeプロジェクトのnpm install実行前に開発環境のチェックとNode.jsヘッダーファイルのインストールを行う。これにより、ビルドに必要な前提条件が満たされていることを確認し、ネイティブモジュールのビルドに必要なヘッダーファイルを事前に準備する。

**業務上の目的・背景**：VSCodeはネイティブモジュール（C/C++で実装されたNode.jsアドオン）を多用しており、これらのビルドには適切なNode.jsバージョン、C/C++コンパイラ（Windowsの場合はVisual Studio）、およびNode.jsヘッダーファイルが必要である。preinstallは開発者の環境がこれらの要件を満たしているかを検証し、問題がある場合は早期にエラーを報告する。これにより、後続のインストール・ビルド工程での失敗を防止する。

**バッチの実行タイミング**：ルートディレクトリでnpm install（またはnpm ci）が開始される直前に自動的に実行される。

**主要な処理内容**：
1. Node.jsバージョンチェック（.nvmrcとの比較）
2. yarn使用の禁止チェック
3. Windows環境でのVisual Studioバージョンチェック
4. Node.jsヘッダーファイルのインストール（node-gyp install）
5. アーキテクチャミスマッチの警告
6. Linux環境でのv8-source-location.patchの適用

**前後の処理との関連**：npm installの最初に実行され、成功後にpostinstallが実行される。失敗した場合はnpm install全体が中止される。

**影響範囲**：開発環境の検証とNode.jsヘッダーファイルのインストールのみ。ファイルの変更はnode-gypキャッシュディレクトリに限定される。

## バッチ種別

環境チェック / セットアップ処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | npm install実行時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | npm preinstallフック（自動） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.jsがインストールされていること |
| npm | npmがインストールされていること |

### 実行可否判定

- npm install/ci実行時に自動的に実行される
- VSCODE_SKIP_NODE_VERSION_CHECK環境変数でバージョンチェックをスキップ可能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_SKIP_NODE_VERSION_CHECK | 環境変数 | No | なし | Node.jsバージョンチェックをスキップ |
| vs2022_install | 環境変数 | No | なし | Visual Studio 2022のインストールパス |
| vs2019_install | 環境変数 | No | なし | Visual Studio 2019のインストールパス |
| npm_command | 環境変数 | No | "ci" | 実行するnpmコマンド |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .nvmrc | テキスト | 必要なNode.jsバージョン |
| .npmrc | テキスト | npm設定（disturl、target） |
| remote/.npmrc | テキスト | リモート用npm設定 |
| build/npm/gyp/package.json | JSON | node-gypパッケージ設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ~/.cache/node-gyp/ | ディレクトリ | Node.jsヘッダーファイル（Linux/macOS） |
| %LOCALAPPDATA%/node-gyp/Cache/ | ディレクトリ | Node.jsヘッダーファイル（Windows） |

### 出力ファイル仕様

Node.jsヘッダーファイルがnode-gypキャッシュディレクトリにインストールされる。

## 処理フロー

### 処理シーケンス

```
1. Node.jsバージョンチェック（VSCODE_SKIP_NODE_VERSION_CHECKが未設定の場合）
   a. 現在のNode.jsバージョンを取得
   b. .nvmrcから必要バージョンを読み込み
   c. バージョン比較（メジャー.マイナー.パッチ）
   d. 不足の場合はエラー終了
2. yarn使用チェック
   └─ npm_execpathにyarnが含まれている場合はエラー終了
3. Windows環境チェック（Windows環境の場合のみ）
   a. Visual Studio 2022または2019の存在確認
   b. 環境変数またはデフォルトパスを検索
   c. 見つからない場合はエラー終了
4. Node.jsヘッダーファイルのインストール
   a. build/npm/gyp/でnpm ci実行（node-gypインストール）
   b. .npmrcからdisturl、targetを読み込み
   c. node-gyp installを実行（ローカル用）
   d. node-gyp installを実行（リモート用）
5. Linux環境でのパッチ適用（Linux環境の場合のみ）
   └─ v8-source-location.patchを適用
6. アーキテクチャミスマッチ警告
   └─ process.archとos.arch()が異なる場合に警告
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{バージョンチェックスキップ?}
    B -->|No| C[Node.jsバージョン取得]
    B -->|Yes| D{yarn使用?}
    C --> E[.nvmrc読み込み]
    E --> F{バージョン十分?}
    F -->|No| G[エラー終了]
    F -->|Yes| D
    D -->|Yes| H[エラー終了: yarn禁止]
    D -->|No| I{Windows環境?}
    I -->|Yes| J{VS存在?}
    J -->|No| K[エラー終了: VS必要]
    J -->|Yes| L[ヘッダーインストール]
    I -->|No| L
    L --> M[node-gyp install実行]
    M --> N{Linux環境?}
    N -->|Yes| O[パッチ適用]
    N -->|No| P[アーキテクチャチェック]
    O --> P
    P --> Q{ミスマッチ?}
    Q -->|Yes| R[警告出力]
    Q -->|No| S[バッチ終了]
    R --> S
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バージョン不足エラー | Node.jsバージョンが.nvmrc未満 | 指定バージョン以上のNode.jsをインストール |
| - | yarn使用エラー | yarnでインストールを試行 | npm iを使用 |
| - | VS未検出エラー | Visual Studioが見つからない | VS 2019/2022をインストール |
| - | .nvmrc解析エラー | .nvmrcの形式が不正 | .nvmrcを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はthrow new Error()でプロセスが終了する。エラーメッセージに従って環境を修正し、npm installを再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の検証 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | npmデフォルト |

## 排他制御

同時実行は想定されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | バージョン不足時 | Please use Node.js vX.X.X or later |
| エラーログ | yarn使用時 | Seems like you are using yarn which is not supported |
| エラーログ | VS未検出時 | Invalid C/C++ Compiler Toolchain |
| 警告ログ | アーキテクチャミスマッチ時 | ARCHITECTURE MISMATCH警告 |
| 進捗ログ | パッチ適用時 | Applying v8-source-location.patch |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| チェックエラー | 1件以上 | コンソール出力（赤色） |

## 備考

- 出力メッセージはANSIエスケープコードで赤色表示
- Visual Studioの検索パス：
  - 環境変数 vs2022_install / vs2019_install
  - C:\Program Files\Microsoft Visual Studio\2022\{Edition}
  - C:\Program Files (x86)\Microsoft Visual Studio\2022\{Edition}
  - 2019も同様
- 対応VS Edition: Enterprise, Professional, Community, Preview, BuildTools, IntPreview
- Linux環境ではv8-source-location.patchを適用（GCC 11+依存を回避）
- node-gypはbuild/npm/gypディレクトリにローカルインストール
- disturl/targetは.npmrcから読み取り（セキュリティ上の理由で固定値を使用）
