# バッチ設計書 28-update-grammars

## 概要

本ドキュメントは、VSCodeプロジェクトにおける文法定義更新バッチ「update-grammars」の設計内容を記載する。このバッチはnpmスクリプトとして実装されており、すべての拡張機能の文法ファイル（TextMate grammar）を最新の状態に更新する。

### 本バッチの処理概要

update-grammarsバッチは、VSCodeに組み込まれた言語サポート拡張機能の文法定義ファイルを外部ソース（主にGitHubリポジトリ）から取得して更新する。これにより、各プログラミング言語のシンタックスハイライトや言語機能が最新の仕様に対応できる。

**業務上の目的・背景**：VSCodeは多数のプログラミング言語のシンタックスハイライトをサポートしており、各言語の文法定義はTextMate grammar形式で管理されている。これらの文法定義は外部プロジェクト（各言語のコミュニティ）で開発・更新されており、定期的にVSCodeリポジトリに取り込む必要がある。update-grammarsはこの更新作業を自動化し、手動での更新ミスを防止する。

**バッチの実行タイミング**：文法定義の更新が必要な際に開発者が手動で実行する。通常、新しいバージョンのVSCodeリリース準備時や、言語サポートの改善時に実行される。

**主要な処理内容**：
1. extensionsディレクトリでnpm ciを実行（依存関係インストール）
2. 各拡張機能のpackage.jsonを走査
3. update-grammarスクリプトを持つ拡張機能を特定
4. 各対象拡張機能でnpm run update-grammarを実行
5. 更新後、統合テストを実行

**前後の処理との関連**：更新後は通常、変更内容をレビューしてコミットする。compile-extensionsタスクで拡張機能をビルドする必要がある場合がある。

**影響範囲**：extensions/ディレクトリ配下の文法定義ファイル（*.tmLanguage.json等）が更新される。

## バッチ種別

データ更新 / 外部リソース同期

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（必要時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| npm | npmがインストールされていること |
| ネットワーク接続 | 外部リソース（GitHub等）へのアクセスが可能であること |

### 実行可否判定

- 常に実行可能
- ネットワーク接続が必要

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータは受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| extensions/*/package.json | JSON | 各拡張機能の設定（update-grammarスクリプト有無） |
| 外部リポジトリ | 各種 | 文法定義の取得元（GitHub等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| extensions/*/syntaxes/*.tmLanguage.json | JSON | 更新された文法定義ファイル |
| extensions/*/syntaxes/*.tmLanguage | XML/PLIST | 更新された文法定義ファイル（XML形式） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | TextMate grammar（JSON/XML） |
| 出力先 | 各拡張機能のsyntaxes/ディレクトリ |
| 文字コード | UTF-8 |

## 処理フロー

### 処理シーケンス

```
1. 依存関係のインストール
   └─ extensionsディレクトリでnpm ciを実行
2. 拡張機能のスキャン
   └─ extensions/配下のディレクトリを列挙
3. 各拡張機能に対してループ処理
   a. package.jsonを読み込み
   b. scriptsにupdate-grammarが定義されているか確認
   c. 定義されていない場合はスキップ
   d. npm run update-grammarを実行
4. 統合テストの実行
   └─ scripts/test-integration.sh（またはtest-integration.bat）を実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[npm ci 実行]
    B --> C[拡張機能ディレクトリ列挙]
    C --> D[拡張機能ループ開始]
    D --> E{package.json存在?}
    E -->|No| F[次の拡張機能]
    E -->|Yes| G[package.json読み込み]
    G --> H{update-grammarスクリプト?}
    H -->|No| F
    H -->|Yes| I[npm run update-grammar実行]
    I --> F
    F --> D
    D --> J[全拡張機能完了]
    J --> K{Windows環境?}
    K -->|Yes| L[test-integration.bat実行]
    K -->|No| M[test-integration.sh実行]
    L --> N[バッチ終了]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークエラー | 外部リソース取得失敗 | ネットワーク接続を確認 |
| - | npm ciエラー | 依存関係インストール失敗 | package-lock.jsonを確認 |
| - | update-grammarエラー | 個別の文法更新失敗 | 該当拡張機能のスクリプトを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はexit code 1で終了する。エラーメッセージを確認し、該当する拡張機能のupdate-grammarスクリプトを個別に調査する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十の拡張機能 |
| 目標処理時間 | 数分〜数十分（ネットワーク速度依存） |
| メモリ使用量上限 | npmデフォルト |

## 排他制御

同時実行は推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各拡張機能処理時 | 拡張機能名 |
| エラーログ | エラー発生時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 更新エラー | 1件以上 | コンソール出力 |

## 備考

- npm run update-grammarsで実行
- update-grammarスクリプトを持つ主な拡張機能：
  - TypeScript/JavaScript言語機能
  - C/C++言語サポート
  - Python言語サポート
  - Java言語サポート
  - Go言語サポート
  - Rust言語サポート
  - 等
- 各拡張機能のupdate-grammarスクリプトは、通常以下の処理を行う：
  - 外部リポジトリから最新の文法定義をダウンロード
  - 必要に応じてフォーマット変換
  - syntaxes/ディレクトリに配置
- 更新後は統合テストが自動的に実行される
- 変更内容はGitで差分確認後、コミットする必要がある
