# バッチ設計書 29-download-builtin-extensions

## 概要

本ドキュメントは、VSCodeプロジェクトにおける組み込み拡張機能ダウンロードバッチ「download-builtin-extensions」の設計内容を記載する。このバッチはnpmスクリプトとして実装されており、外部から提供される組み込み拡張機能をダウンロードして配置する。

### 本バッチの処理概要

download-builtin-extensionsバッチは、product.jsonで定義された外部の組み込み拡張機能（builtInExtensions、webBuiltInExtensions）をMarketplaceまたはGitHubからダウンロードし、.build/builtInExtensions/ディレクトリに配置する。これにより、VSCodeビルドに必要な外部拡張機能が準備される。

**業務上の目的・背景**：VSCodeには、リポジトリ内で開発される拡張機能（extensions/配下）とは別に、外部から取得する組み込み拡張機能が存在する。これらは別のリポジトリやMarketplaceで管理されており、VSCodeのビルド時に取得する必要がある。download-builtin-extensionsはこの取得プロセスを自動化し、開発者やCIが簡単に必要な拡張機能を準備できるようにする。

**バッチの実行タイミング**：開発環境のセットアップ時、ビルド前、またはCIパイプラインで実行される。

**主要な処理内容**：
1. product.jsonからbuiltInExtensions/webBuiltInExtensionsリストを読み込み
2. control.jsonから各拡張機能の状態（disabled/marketplace）を読み込み
3. 各拡張機能に対して以下を実行：
   - バージョンチェック（既に最新版がある場合はスキップ）
   - プラットフォーム互換性チェック
   - MarketplaceまたはGitHubからVSIXをダウンロード
   - .build/builtInExtensions/に展開・配置
4. control.jsonを更新して状態を保存

**前後の処理との関連**：ビルドタスク（compile-build等）の前に実行される。CI/CDパイプラインでは初期セットアップの一部として実行される。

**影響範囲**：.build/builtInExtensions/ディレクトリに拡張機能がダウンロードされる。~/.vscode-oss-dev/extensions/control.jsonが更新される。

## バッチ種別

データ取得 / 外部リソースダウンロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（セットアップ時、ビルド前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| npm | npmがインストールされていること |
| ネットワーク接続 | Marketplace/GitHubへのアクセスが可能であること |

### 実行可否判定

- 常に実行可能
- 既にダウンロード済みで最新の拡張機能はスキップされる

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_BUILD_BUILTIN_EXTENSIONS_SILENCE_PLEASE | 環境変数 | No | なし | ログ出力を抑制 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| product.json | JSON | builtInExtensions/webBuiltInExtensions定義 |
| ~/.vscode-oss-dev/extensions/control.json | JSON | 拡張機能の制御状態 |
| Marketplace API | REST | 拡張機能のダウンロード元（設定時） |
| GitHub | HTTPS | 拡張機能のダウンロード元（フォールバック） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .build/builtInExtensions/*/ | ディレクトリ | ダウンロードされた拡張機能 |
| ~/.vscode-oss-dev/extensions/control.json | JSON | 更新された制御状態 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 配置先 | .build/builtInExtensions/{拡張機能名}/ |
| 構造 | package.json + 拡張機能ファイル |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイルの読み込み
   a. product.jsonからbuiltInExtensions/webBuiltInExtensionsを取得
   b. control.jsonから各拡張機能の状態を取得
2. 各拡張機能に対してループ処理
   a. プラットフォーム互換性チェック
      └─ 現在のプラットフォームが対象に含まれるか確認
   b. 制御状態の確認
      └─ disabled: スキップ
      └─ marketplace: ダウンロード
      └─ カスタムパス: ローカル参照
   c. バージョンチェック
      └─ .build/builtInExtensions/{name}/package.jsonのバージョン確認
      └─ 最新の場合はスキップ
   d. ダウンロード処理
      └─ vsixファイルがある場合: ローカルVSIXを使用
      └─ Marketplace設定がある場合: Marketplaceからダウンロード
      └─ それ以外: GitHubからダウンロード
   e. 展開・配置
      └─ .build/builtInExtensions/に配置
3. control.jsonの更新
   └─ 各拡張機能の状態を保存
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[product.json読み込み]
    B --> C[control.json読み込み]
    C --> D[拡張機能ループ開始]
    D --> E{プラットフォーム対応?}
    E -->|No| F[スキップ]
    E -->|Yes| G{制御状態?}
    G -->|disabled| H[スキップログ出力]
    G -->|marketplace| I{バージョン最新?}
    G -->|カスタムパス| J[パス存在確認]
    I -->|Yes| K[スキップログ出力]
    I -->|No| L[既存削除]
    L --> M{vsixファイル?}
    M -->|Yes| N[ローカルVSIX使用]
    M -->|No| O{Marketplace設定?}
    O -->|Yes| P[Marketplaceからダウンロード]
    O -->|No| Q[GitHubからダウンロード]
    N --> R[配置]
    P --> R
    Q --> R
    R --> S[次の拡張機能]
    F --> S
    H --> S
    K --> S
    J --> S
    S --> D
    D --> T[全拡張機能完了]
    T --> U[control.json更新]
    U --> V[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークエラー | Marketplace/GitHub接続失敗 | ネットワーク接続を確認 |
| - | ダウンロードエラー | 拡張機能取得失敗 | product.jsonの設定を確認 |
| - | パス不存在エラー | カスタムパスが見つからない | control.jsonの設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（npmパッケージの内部リトライに依存） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラー発生時はエラーメッセージがコンソールに出力される。control.jsonを確認し、問題のある拡張機能をdisabledに設定して再実行することが可能。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十の拡張機能 |
| 目標処理時間 | 数分（ネットワーク速度依存） |
| メモリ使用量上限 | npmデフォルト |

## 排他制御

同時実行は推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Synchronizing built-in extensions..." |
| ヘルプログ | バッチ開始時 | "--builtinフラグの説明" |
| スキップログ | 最新版存在時 | "{name}@{version} up to date" |
| ダウンロードログ | ダウンロード完了時 | "{name}" |
| 無効ログ | disabled時 | "[disabled] {name}" |
| ローカルログ | カスタムパス時 | "[local] {name}: {path}" |
| エラーログ | エラー発生時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ダウンロードエラー | 1件以上 | コンソール出力 |

## 備考

- npm run download-builtin-extensionsで実行
- control.jsonの場所：~/.vscode-oss-dev/extensions/control.json
- control.jsonの形式：
  ```json
  {
    "extension-name": "disabled" | "marketplace" | "/path/to/local"
  }
  ```
- VSCODE_BUILD_BUILTIN_EXTENSIONS_SILENCE_PLEASEでログ出力を抑制可能
- product.jsonのbuiltInExtensions構造：
  ```json
  {
    "name": "extension-id",
    "version": "1.0.0",
    "sha256": "hash",
    "repo": "github-repo",
    "platforms": ["win32", "darwin", "linux"],
    "metadata": { ... }
  }
  ```
- vsixフィールドがある場合はローカルファイルを優先
- extensionsGallery.serviceUrlが設定されている場合はMarketplaceを使用
- Marketplaceが設定されていない場合はGitHubからダウンロード
- rimraf.syncで既存ディレクトリを削除してからダウンロード
