# バッチ設計書 3-product-publish

## 概要

本ドキュメントは、Visual Studio Codeのビルド成果物公開処理「product-publish」の設計仕様を定義するものです。各プラットフォームで生成されたビルド成果物を収集し、builds.code.visualstudio.comへ公開する処理を担当します。

### 本バッチの処理概要

本バッチは、product-buildパイプラインのPublishステージとして実行され、Windows/Linux/macOS/Alpine/Webの各ビルドステージで生成された成果物を収集・処理し、公開サーバーへアップロードします。ESRPを使用した署名検証やリリースビルドの自動公開も行います。

**業務上の目的・背景**：VSCodeのビルドプロセスでは、複数のプラットフォーム向けに並列でビルドが実行されます。本バッチは、これらの分散したビルド成果物を一元的に収集し、builds.code.visualstudio.comを通じてユーザーに提供可能な状態にします。これにより、開発者やユーザーは常に最新のInsider/Stableビルドにアクセスできるようになります。

**バッチの実行タイミング**：product-buildパイプラインのPublishステージとして、他のステージと独立して（dependsOn: []）実行開始されます。ただし、成果物の処理は他のビルドステージが成果物を生成した後に行われます。

**主要な処理内容**：
1. ソースコードのチェックアウトと依存関係インストール
2. 以前の試行で処理済みの成果物情報を取得
3. ビルドメタデータの作成（初回実行時）
4. 公開用認証トークンの取得
5. 各プラットフォームの成果物を順次処理・公開
6. スケジュールビルド時のリリースビルド自動公開（insider/exploration品質の場合）

**前後の処理との関連**：本バッチは、Compile/CompileCLI/Windows/Linux/macOS/Alpine/Webの各ビルドステージと並列で開始しますが、実際の成果物処理は各ステージが成果物をアップロードした後に行われます。VSCODE_RELEASE=trueの場合、後続のApproveRelease→Releaseステージがトリガーされます。

**影響範囲**：builds.code.visualstudio.com、Azure Cosmos DB（ビルドメタデータ）、Azure Blob Storage（ステージング領域）に影響します。

## バッチ種別

CI/CDパイプライン（成果物公開処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | product-buildパイプライン実行時 |
| 実行時刻 | 親パイプラインに依存 |
| 実行曜日 | 親パイプラインに依存 |
| 実行日 | - |
| トリガー | product-buildパイプライン（VSCODE_PUBLISH=true時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| VSCODE_PUBLISH | true（デフォルト）であること |
| VSCODE_CIBUILD | false（CIビルド以外）であること |
| VSCODE_COMPILE_ONLY | false であること |
| ビルドエージェント | 1es-windows-2022-x64 プールが利用可能 |
| Azure Key Vault | vscode-build-secrets, vscode-esrp へのアクセス権限 |

### 実行可否判定

```
VSCODE_PUBLISH = and(
  eq(parameters.VSCODE_PUBLISH, true),
  eq(variables.VSCODE_CIBUILD, false),
  eq(parameters.VSCODE_COMPILE_ONLY, false)
)
```

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VSCODE_QUALITY | string | Yes | insider | ビルド品質（exploration/insider/stable） |
| VSCODE_SCHEDULEDBUILD | boolean | Yes | false | スケジュールビルドかどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Pipeline Artifacts | 各種 | 各プラットフォームのビルド成果物 |
| Azure Key Vault (vscode-build-secrets) | Secret | github-distro-mixin-password |
| Azure Key Vault (vscode-esrp) | Secret | esrp-auth, esrp-sign |
| artifacts_processed_*.txt | テキスト | 以前の試行で処理済みの成果物リスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| builds.code.visualstudio.com | 各種バイナリ | 公開ビルド成果物 |
| Azure Cosmos DB | JSON | ビルドメタデータ |
| Pipeline Artifact | テキスト | artifacts_processed_*.txt |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | artifacts_processed_$(System.StageAttempt).txt |
| 出力先 | $(Pipeline.Workspace)/artifacts_processed_$(System.StageAttempt)/ |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

## 処理フロー

### 処理シーケンス

```
1. ソースコードチェックアウト
   └─ common/checkout.ymlテンプレート使用
2. Node.jsセットアップ
   └─ .nvmrcからバージョン指定
3. Azure Key Vaultシークレット取得
   └─ github-distro-mixin-password
4. ESRPシークレット取得
   └─ esrp-auth, esrp-sign
5. ビルドタグ追加
   └─ "🚀" タグをビルドに付与
6. ビルド依存関係インストール
   └─ build/ディレクトリでnpm ci
7. 処理済み成果物情報ダウンロード
   └─ 以前のステージ試行からartifacts_processed_*.txt取得
8. Azureシークレット取得
   └─ AzureCLI@2でIDトークン取得
9. ビルド作成（初回のみ）
   └─ createBuild.ts実行（artifacts_processed_*が存在しない場合）
10. 公開認証トークン取得
    └─ getPublishAuthTokens.ts
11. 成果物処理・公開
    └─ publish.ts（3回リトライ）
12. リリースビルド公開（条件付き）
    └─ releaseBuild.ts（insider/exploration + スケジュールビルド時）
```

### フローチャート

```mermaid
flowchart TD
    A[ジョブ開始] --> B[チェックアウト]
    B --> C[Node.jsセットアップ]
    C --> D[Key Vaultシークレット取得]
    D --> E[ESRPシークレット取得]
    E --> F[ビルドタグ追加]
    F --> G[ビルド依存関係インストール]
    G --> H[処理済み成果物DL]
    H --> I[Azureシークレット取得]
    I --> J{初回実行?}
    J -->|Yes| K[ビルド作成]
    J -->|No| L[スキップ]
    K --> M[公開認証トークン取得]
    L --> M
    M --> N[成果物処理・公開]
    N --> O{insider/exploration<br>かつ<br>スケジュールビルド?}
    O -->|Yes| P[リリースビルド公開]
    O -->|No| Q[成果物情報保存]
    P --> Q
    Q --> R[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| createBuild | Azure Cosmos DB | INSERT | ビルドメタデータの新規登録 |
| publish | Azure Cosmos DB | UPDATE | 成果物情報の更新 |
| releaseBuild | Azure Cosmos DB | UPDATE | リリースステータスの更新 |

### テーブル別操作詳細

#### Azure Cosmos DB (vscode.documents.azure.com)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | version, buildId, timestamp | package.jsonのversion | ビルド作成時 |
| UPDATE | artifacts | プラットフォーム別成果物情報 | 成果物処理時 |
| UPDATE | released | true | リリース時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AUTH_FAILED | 認証エラー | Azure/ESRP認証失敗 | Key Vault設定確認、サービスプリンシパル確認 |
| ARTIFACT_NOT_FOUND | 成果物エラー | 期待する成果物が見つからない | 前段ビルドステージの状態確認 |
| PUBLISH_FAILED | 公開エラー | builds.code.visualstudio.comへの公開失敗 | ネットワーク確認、リトライ |
| ESRP_ERROR | 署名エラー | ESRP署名処理失敗 | ESRP認証情報確認 |
| BUILD_CREATE_FAILED | ビルド作成エラー | Cosmos DBへの書き込み失敗 | Azure接続確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 成果物処理: 3回 |
| リトライ間隔 | 自動（Azure DevOps標準） |
| リトライ対象エラー | publish.tsの一時的なエラー |

### 障害時対応

1. 認証エラーの場合、Azure Key Vaultのシークレットの有効期限を確認
2. 成果物が見つからない場合、前段のビルドステージのログを確認
3. 公開失敗の場合、builds.code.visualstudio.comのステータスを確認
4. ステージ再試行機能（StageAttempt）により、失敗時は再試行可能
5. artifacts_processed_*.txtにより、再試行時に既に処理済みの成果物はスキップ

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 成果物単位 |
| コミットタイミング | 各成果物の公開完了時 |
| ロールバック条件 | 成果物公開失敗時は該当成果物のみスキップ、全体は継続 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約20成果物/実行（プラットフォーム x アーキテクチャ） |
| 目標処理時間 | 180分以内（timeoutInMinutes: 180） |
| メモリ使用量上限 | エージェント依存 |

## 排他制御

- 同一ビルドID内で複数のPublishジョブは実行されない
- artifacts_processed_*.txtにより、複数試行間での重複処理を防止
- ビルド作成時、既存ビルドの有無をチェック

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | ジョブ名、品質、スケジュールフラグ |
| 認証ログ | 認証処理時 | 認証成功/失敗 |
| 成果物ログ | 成果物処理時 | 処理対象成果物名、処理結果 |
| 公開ログ | 公開処理時 | 公開先URL、成功/失敗 |
| リリースログ | リリース時 | リリースバージョン |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 180分超過 | Azure DevOps（タイムアウト） |
| 公開失敗 | 3回リトライ後も失敗 | Azure DevOps通知 |
| 成果物欠損 | 期待する成果物の欠如 | ビルドログ |

## 備考

- Windowsエージェント（1es-windows-2022-x64）で実行されるのは、一部の処理がWindowsを前提としているため
- retryCountOnTaskFailure: 3により、成果物処理タスクは自動的に3回までリトライされる
- artifacts_processed_$(System.StageAttempt).txtにより、ステージ再試行時の冪等性を確保
- insider/exploration品質かつスケジュールビルドの場合のみ、自動リリースが行われる
- ESRP（Enterprise Security Response Platform）を使用して、成果物の署名検証を実施
