# バッチ設計書 30-smoketest

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるスモークテスト実行バッチ「smoketest」の設計内容を記載する。このバッチはnpmスクリプトとして実装されており、VSCodeの基本的な動作を検証するE2E（End-to-End）テストを実行する。

### 本バッチの処理概要

smoketestバッチは、VSCodeの主要機能が正常に動作することを確認するための統合テストスイートである。Electron版、Web版、リモート開発版の各環境でテストを実行でき、リリース前の品質検証に使用される。

**業務上の目的・背景**：VSCodeは複雑なデスクトップアプリケーションであり、コード変更がUIや機能に予期しない影響を与える可能性がある。スモークテストは、検索、ターミナル、言語機能、拡張機能、設定など主要な機能の動作を自動的に検証し、リグレッションを早期に検出する。これにより、リリース品質の確保と開発効率の向上を実現する。

**バッチの実行タイミング**：リリース前の品質検証時、CI/CDパイプライン（PR時、ナイトリービルド時）、および開発者によるローカル検証時に実行される。

**主要な処理内容**：
1. 事前コンパイル（preLaunch.ts）の実行
2. テストプロジェクトリポジトリの準備（クローンまたはリセット）
3. 安定版VSCodeのダウンロード（移行テスト用、オプション）
4. テストスイートの実行：
   - データロステスト
   - 設定テスト
   - 検索テスト
   - ノートブックテスト
   - 言語機能テスト
   - ターミナルテスト
   - タスクテスト
   - ステータスバーテスト
   - 拡張機能テスト
   - マルチルートテスト
   - ローカライゼーションテスト
   - 起動テスト
   - チャットテスト
   - アクセシビリティテスト
5. テスト結果のログ出力

**前後の処理との関連**：compileタスク後に実行される。CI/CDパイプラインではビルド検証の一部として組み込まれる。

**影響範囲**：テスト用の一時ディレクトリが作成・削除される。本番コードへの影響はない。

## バッチ種別

E2Eテスト / 統合テスト / 品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR時、リリース前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | .nvmrcで指定されたバージョン以上のNode.jsがインストールされていること |
| npm | npmがインストールされていること |
| VSCode/Electron | テスト対象のVSCodeがビルドされていること |
| Playwright | ブラウザ自動化ツールがインストールされていること（npm playwright-install） |
| Git | テストリポジトリのクローン用 |

### 実行可否判定

- VSCodeが一度起動された履歴があること（Electron版）
- ネットワーク接続（テストリポジトリクローン、安定版ダウンロード用）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --build | string | No | なし | テスト対象のVSCodeビルドパス |
| --stable-build | string | No | なし | 安定版VSCodeのパス（移行テスト用） |
| --web | boolean | No | false | Web版テストを実行 |
| --remote | boolean | No | false | リモート開発テストを実行 |
| --headless | boolean | No | false | ヘッドレスモードで実行 |
| --verbose | boolean | No | false | 詳細ログ出力 |
| --tracing | boolean | No | false | トレース情報を収集 |
| --browser | string | No | chromium | 使用ブラウザ（chromium/webkit/firefox等） |
| --test-repo | string | No | なし | カスタムテストリポジトリパス |
| --electronArgs | string | No | なし | Electronへの追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストリポジトリ | Git | vscode-smoketest-express |
| VSCodeビルド | アプリケーション | テスト対象のVSCode |
| テストスクリプト | TypeScript | test/smoke/src/areas/配下 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .build/logs/smoke-tests-*/ | ログファイル | テスト実行ログ |
| .build/crashes/smoke-tests-*/ | クラッシュダンプ | クラッシュ情報（発生時） |
| 標準出力 | テキスト | テスト結果サマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ログファイル | smoke-test-runner.log |
| ログパス | .build/logs/smoke-tests-{electron/browser/remote}/ |
| クラッシュパス | .build/crashes/smoke-tests-{electron/browser/remote}/ |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   a. ログディレクトリの作成
   b. テストデータディレクトリの作成（一時ディレクトリ）
   c. 品質レベルの判定（Dev/OSS/Insiders/Stable）
2. 事前準備（before hook）
   a. テストリポジトリの準備（クローンまたはリセット）
   b. 安定版VSCodeのダウンロード（オプション、移行テスト用）
   c. ApplicationOptionsの設定
3. テストスイートの実行
   a. 各テストカテゴリを順次実行
   b. 失敗時はエラーログを記録
   c. トレース情報の収集（有効時）
4. 後処理（after hook）
   a. テストデータディレクトリのクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[preLaunch.ts実行]
    B --> C[test/smoke/compile]
    C --> D[Mocha起動]
    D --> E[ログディレクトリ作成]
    E --> F[テストデータディレクトリ作成]
    F --> G{Web版?}
    G -->|Yes| H[Web環境設定]
    G -->|No| I{ビルド指定?}
    I -->|Yes| J[ビルドパス設定]
    I -->|No| K[開発環境設定]
    H --> L[テストリポジトリ準備]
    J --> L
    K --> L
    L --> M{移行テスト有効?}
    M -->|Yes| N[安定版ダウンロード]
    M -->|No| O[テストスイート実行]
    N --> O
    O --> P[データロステスト]
    P --> Q[設定テスト]
    Q --> R[検索テスト]
    R --> S[ノートブックテスト]
    S --> T[言語機能テスト]
    T --> U[ターミナルテスト]
    U --> V[その他テスト...]
    V --> W[クリーンアップ]
    W --> X[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | VSCode未検出 | ビルド未実行 | scripts/code.shを実行 |
| - | テストリポジトリエラー | クローン失敗 | ネットワーク接続を確認 |
| - | タイムアウト | テスト実行時間超過 | テスト対象を見直し |
| - | アサーションエラー | テスト失敗 | 該当機能を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 一部処理で最大20回（安定版ダウンロード等） |
| リトライ間隔 | 1000ms |
| リトライ対象エラー | ネットワーク関連エラー |

### 障害時対応

テスト失敗時はログファイルを確認し、該当するテストケースと機能を調査する。クラッシュ発生時はクラッシュダンプを分析する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約100テストケース |
| 目標処理時間 | 数分〜数十分 |
| タイムアウト | セットアップ5分、各テスト可変 |

## 排他制御

同一マシンでの同時実行は推奨されない（ポート競合、リソース競合の可能性）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Running ... smoke tests against {path}" |
| 進捗ログ | 各テスト実行時 | テスト名、結果 |
| エラーログ | テスト失敗時 | エラー詳細、スタックトレース |
| 終了ログ | バッチ終了時 | テストサマリー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗 | 1件以上 | CI/CDパイプライン失敗通知 |
| タイムアウト | 設定値超過 | CI/CDパイプライン失敗通知 |

## 備考

- npm run smoketestで実行（コンパイル含む）
- npm run smoketest-no-compileでコンパイルなしで実行
- テストリポジトリ：https://github.com/microsoft/vscode-smoketest-express
- Mochaフレームワークを使用
- @vscode/test-electronパッケージで安定版ダウンロード
- graceful-fsでファイル操作を安定化
- テストカテゴリ：
  - データロス（Electron限定）
  - 設定
  - 検索
  - ノートブック（Electron限定）
  - 言語機能
  - ターミナル
  - タスク
  - ステータスバー
  - 拡張機能（Dev/OSS以外）
  - マルチルート
  - ローカライゼーション（デスクトップ、Dev/OSS以外）
  - 起動（デスクトップ限定）
  - チャット（Electron限定）
  - アクセシビリティ
- VSCODE_DEV=1で開発モード判定
- VSCODE_QUALITYで品質レベル判定
