# バッチ設計書 31-test-browser

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるブラウザ環境向けユニットテスト実行バッチ「test-browser」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeのブラウザ環境向けコードに対するユニットテストを、Playwrightを使用して複数のブラウザエンジン（Chromium、Firefox、WebKit）上で実行します。

**業務上の目的・背景**：VSCodeはElectronアプリケーションとしてだけでなく、vscode.devなどのWebブラウザ環境でも動作する必要があります。ブラウザ固有のAPI（DOM操作、Web Storage、IndexedDBなど）を使用するコードが正しく動作することを保証するため、実際のブラウザエンジン上でテストを実行する必要があります。このバッチにより、ブラウザ互換性の問題を早期に検出し、クロスブラウザ対応の品質を担保します。

**バッチの実行タイミング**：開発時の手動実行、およびCI/CDパイプライン（GitHub Actions pr.yml）でのプルリクエスト検証時に自動実行されます。

**主要な処理内容**：
1. Playwrightのブラウザドライバーをインストール（初回または必要時）
2. ローカルHTTPサーバーを起動してテストファイルをホスト
3. 指定されたブラウザ（Chromium、Firefox、WebKit）を起動
4. テストモジュールをブラウザ上で動的にロード・実行
5. Mochaテストランナーによるテスト結果の収集・レポート
6. テスト失敗時のエラー情報出力

**前後の処理との関連**：事前にTypeScriptコンパイル（compile/watch）が完了している必要があります。このバッチはtest-nodeやtest.sh/test.batと並行して実行可能であり、それぞれ異なる実行環境をカバーします。

**影響範囲**：`out`または`out-build`ディレクトリ配下のテストファイル（`**/*.test.js`）が対象。ただし`node`、`electron-browser`、`electron-main`、`electron-utility`配下のテストは除外されます。

## バッチ種別

テスト実行 / ユニットテスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時手動）/ PR作成時（CI自動） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions（PR作成・更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 22.x以上がインストールされていること |
| npm依存関係 | `npm install`が完了していること |
| コンパイル完了 | TypeScriptコンパイル（`npm run compile`または`npm run watch`）が完了していること |
| Playwrightブラウザ | `npx playwright install`によりブラウザがインストールされていること（スクリプト内で自動実行される） |

### 実行可否判定

`test/unit/browser/index.js`が存在し、`out`ディレクトリにコンパイル済みのテストファイルが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --build | boolean | No | false | `out-build`ディレクトリからテストを実行 |
| --run | string | No | - | 特定のテストファイルのみを実行 |
| --grep, -g, -f | string | No | - | 指定パターンにマッチするテストのみ実行 |
| --runGlob, --glob | string | No | `**/*.test.js` | 実行するテストファイルのglobパターン |
| --browser | string/array | No | chromium,firefox,webkit | テストを実行するブラウザ |
| --debug | boolean | No | false | ヘッドレスモードを無効化してデバッグ |
| --sequential | boolean | No | false | ブラウザを順次実行（並列でなく） |
| --reporter | string | No | spec (macOS/Linux), list (Windows) | Mochaレポーター |
| --reporter-options | string | No | - | レポーターオプション |
| --tfs | string | No | - | TFSレポート用の設定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| out/**/*.test.js | JavaScript | コンパイル済みテストファイル |
| test/unit/browser/renderer.html | HTML | テスト実行用HTMLページ |
| product.json | JSON | 製品設定情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト実行結果（Mochaレポート） |
| 標準エラー出力 | テキスト | エラー情報 |
| JUnit XMLファイル | XML | CI環境でのテスト結果レポート（--tfs指定時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `test-results/{platform}-{arch}-{browser}-{tfs}-results.xml` |
| 出力先 | `BUILD_ARTIFACTSTAGINGDIRECTORY`または`GITHUB_WORKSPACE` |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（XML形式） |

## 処理フロー

### 処理シーケンス

```
1. パラメータ解析
   └─ minimistによるコマンドライン引数のパース
2. テストモジュール収集
   └─ globパターンによるテストファイルの列挙
   └─ 除外パターン（node/electron系）の適用
3. HTTPサーバー起動
   └─ yaserverによる静的ファイルサーバー起動
   └─ ランダムプレフィックスによるセキュリティ確保
4. ブラウザ起動（並列または順次）
   └─ Playwrightによるブラウザインスタンス作成
   └─ コンテキスト・ページの作成
5. テスト実行
   └─ renderer.htmlをロード
   └─ テストモジュールの動的インポート
   └─ Mochaによるテスト実行
6. 結果収集
   └─ IPC経由でのテスト結果受信
   └─ レポーターによる出力
7. クリーンアップ
   └─ ブラウザ終了
   └─ サーバー停止
8. 終了コード設定
   └─ 失敗テストがあれば1、なければ0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ解析]
    B --> C[テストモジュール収集]
    C --> D[HTTPサーバー起動]
    D --> E{複数ブラウザ?}
    E -->|Yes & sequential| F1[順次ブラウザ実行]
    E -->|Yes & parallel| F2[並列ブラウザ実行]
    E -->|No| F3[単一ブラウザ実行]
    F1 --> G[テスト結果収集]
    F2 --> G
    F3 --> G
    G --> H{失敗テストあり?}
    H -->|Yes| I[エラー情報出力]
    H -->|No| J[成功メッセージ出力]
    I --> K[クリーンアップ]
    J --> K
    K --> L[終了コード設定]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | テスト失敗 | テストアサーション失敗 | テストコードまたは対象コードを修正 |
| 1 | モジュールロードエラー | テストファイルのロード失敗 | コンパイルエラーの確認・修正 |
| 1 | ブラウザ起動エラー | Playwrightがブラウザを起動できない | Playwrightの再インストール |
| 1 | タイムアウト | テスト実行が規定時間を超過 | テストの最適化またはタイムアウト延長 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（デフォルト） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `--debug`オプションを付けて実行し、ブラウザのDevToolsでデバッグ
2. 失敗したテストモジュールのみを`--run`で再実行
3. CSSモジュールのロードエラーの場合は再コンパイル

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース非使用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千テストケース |
| 目標処理時間 | 5分以内（並列実行時） |
| メモリ使用量上限 | ブラウザプロセスごとに1GB程度 |

## 排他制御

同一マシン上での複数インスタンス実行は可能。ただし、ポート競合を避けるため、HTTPサーバーは動的ポート（0番指定）を使用。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 実行オプション情報 |
| 進捗ログ | 各テスト実行時 | テスト名、結果（pass/fail/pending） |
| 終了ログ | バッチ終了時 | 総テスト数、成功数、失敗数、スキップ数、実行時間 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗率 | 0% | GitHub Actions（PRステータス） |
| 実行時間 | 10分 | CI/CDパイプライン |

## 備考

- Playwrightは初回実行時にブラウザドライバーを自動ダウンロードするため、初回実行は時間がかかる場合があります
- `--browser chromium-msedge`のようにチャンネルを指定することで、Microsoft Edgeなど特定のブラウザバリアントでテストを実行できます
- CI環境では`--tfs`オプションによりJUnit形式のレポートが生成され、テスト結果の可視化に使用されます
