# バッチ設計書 32-test-node

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるNode.js環境向けユニットテスト実行バッチ「test-node」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeのNode.js環境向けコードに対するユニットテストを、Mochaテストフレームワークを使用してNode.jsランタイム上で実行します。

**業務上の目的・背景**：VSCodeはElectronアプリケーションであり、メインプロセスやサーバーサイドのコードはNode.js環境で動作します。ファイルシステム操作、プロセス管理、ネットワーク通信などNode.js固有のAPIを使用するコードが正しく動作することを保証するため、Node.jsランタイム上で直接テストを実行する必要があります。このバッチにより、サーバーサイドロジックの品質を担保し、リグレッションを防止します。

**バッチの実行タイミング**：開発時の手動実行、およびCI/CDパイプライン（GitHub Actions pr.yml）でのプルリクエスト検証時に自動実行されます。

**主要な処理内容**：
1. Node.jsバージョンの検証（最低バージョン要件チェック）
2. テストモジュールの収集（globパターンによる列挙）
3. 除外パターンの適用（ブラウザ系・Electron系テストの除外）
4. ESMモジュールローダーによるテストファイルの動的インポート
5. Mochaによるテスト実行
6. エラーハンドリングと結果レポート

**前後の処理との関連**：事前にTypeScriptコンパイル（compile/watch）が完了している必要があります。このバッチはtest-browserやtest.sh/test.batと並行して実行可能であり、それぞれ異なる実行環境をカバーします。

**影響範囲**：`out`または`out-build`ディレクトリ配下のテストファイル（`**/test/**/*.test.js`）が対象。ただし`browser`、`electron-browser`、`electron-main`、`electron-utility`配下のテスト、および一部のネイティブモジュール依存テストは除外されます。

## バッチ種別

テスト実行 / ユニットテスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時手動）/ PR作成時（CI自動） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions（PR作成・更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | remote/.npmrcで指定されたバージョン以上がインストールされていること |
| npm依存関係 | `npm install`が完了していること |
| コンパイル完了 | TypeScriptコンパイル（`npm run compile`または`npm run watch`）が完了していること |

### 実行可否判定

Node.jsのメジャーバージョンが`remote/.npmrc`で指定された`target`バージョン以上である場合に実行可能。バージョン不足の場合はエラーメッセージを出力して終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --build | boolean | No | false | `out-build`ディレクトリからテストを実行 |
| --run | string | No | - | 特定のテストファイルのみを実行 |
| --runGlob | string | No | `**/test/**/*.test.js` | 実行するテストファイルのglobパターン |
| --coverage | boolean | No | false | カバレッジレポートを生成 |
| --coveragePath | string | No | - | カバレッジレポートの出力先 |
| --coverageFormats | string | No | - | カバレッジレポートの形式 |
| --delay | boolean | No | true | Mochaの遅延実行を有効化（内部設定） |
| --ui | string | No | tdd | Mochaのテストインターフェース |
| --timeout | number | No | 5000 | テストタイムアウト（ミリ秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| out/**/test/**/*.test.js | JavaScript | コンパイル済みテストファイル |
| product.json | JSON | 製品設定情報 |
| package.json | JSON | パッケージ設定情報 |
| remote/.npmrc | Text | Node.jsバージョン要件 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト実行結果（Mochaレポート） |
| 標準エラー出力 | テキスト | エラー情報 |

### 出力ファイル仕様

カバレッジ有効時のみファイル出力があります。

| 項目 | 内容 |
|-----|------|
| ファイル名 | カバレッジレポート（指定形式による） |
| 出力先 | --coveragePathで指定されたパス |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. パラメータ解析
   └─ minimistによるコマンドライン引数のパース
2. Node.jsバージョン検証
   └─ remote/.npmrcからtargetバージョンを取得
   └─ 現在のNode.jsバージョンと比較
   └─ 不足時はエラー終了
3. グローバル設定
   └─ _VSCODE_PRODUCT_JSON, _VSCODE_PACKAGE_JSON設定
   └─ _VSCODE_FILE_ROOT設定
   └─ buildモード時はNLSメッセージ読み込み
4. テストユーティリティ設定
   └─ ファイル操作関数のグローバル登録
5. テストモジュール収集
   └─ globパターンによるファイル列挙
   └─ 除外パターンの適用
6. テストモジュールロード
   └─ ESMインポートによる動的ロード
   └─ Mochaスイートイベントの発火
7. テスト実行
   └─ Mochaランナーによる実行
8. エラーハンドリング
   └─ 予期せぬエラーの収集
   └─ 最終テストで検証
9. 終了コード設定
   └─ 失敗テストがあれば1、なければ0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ解析]
    B --> C{Node.jsバージョン確認}
    C -->|不足| D[エラー終了]
    C -->|OK| E[グローバル設定]
    E --> F[テストモジュール収集]
    F --> G{モジュールあり?}
    G -->|No| H[スキップ終了]
    G -->|Yes| I[モジュールロード]
    I --> J[Mochaテスト実行]
    J --> K{失敗テストあり?}
    K -->|Yes| L[終了コード1]
    K -->|No| M[終了コード0]
    L --> N[バッチ終了]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | バージョンエラー | Node.jsバージョンが要件未満 | Node.jsのアップグレード |
| 1 | テスト失敗 | テストアサーション失敗 | テストコードまたは対象コードを修正 |
| 1 | モジュールロードエラー | テストファイルのロード失敗 | コンパイルエラーの確認・修正 |
| 1 | 予期せぬエラー | テスト中の未キャッチ例外 | エラーログを確認して原因を特定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（デフォルト） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `--run`オプションで特定のテストファイルを指定して再実行
2. エラーログで予期せぬエラーを確認
3. Node.jsバージョンを確認し、必要に応じてアップグレード

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース非使用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千テストケース |
| 目標処理時間 | 2分以内 |
| メモリ使用量上限 | 2GB程度（Node.jsヒープ） |

## 排他制御

同一マシン上での複数インスタンス実行は可能。テスト間でファイルシステムの一時ファイルを使用する場合は、テストごとに一意のディレクトリを使用することで競合を回避。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 暗黙的（Mochaのデフォルト動作） |
| 進捗ログ | 各テスト実行時 | テスト名、結果（pass/fail/pending） |
| 終了ログ | バッチ終了時 | 総テスト数、成功数、失敗数、スキップ数、実行時間 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗率 | 0% | GitHub Actions（PRステータス） |
| 実行時間 | 5分 | CI/CDパイプライン |

## 備考

- このバッチはESM（ECMAScript Modules）形式のテストファイルをサポートしています
- `--delay`フラグはMochaの遅延実行機能を使用し、非同期のテストモジュールロードを可能にしています
- 以下のテストは明示的に除外されています：
  - `**/vs/platform/environment/test/node/nativeModules.test.js` - Electronのネイティブモジュール依存
  - `**/vs/base/parts/storage/test/node/storage.test.js` - SQLiteネイティブモジュール依存
  - `**/vs/workbench/contrib/testing/test/**` - フレーキーテスト（GitHub Issue #137853）
- カラー出力は`MOCHA_COLORS=1`環境変数で強制的に有効化されています
