# バッチ設計書 33-test.sh/test.bat

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるElectron環境向けユニットテスト実行バッチ「test.sh/test.bat」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeのElectron環境向けコードに対するユニットテストを、実際のElectronアプリケーション内で実行します。Linux/macOS向けのシェルスクリプト（test.sh）とWindows向けのバッチファイル（test.bat）の2種類が提供されています。

**業務上の目的・背景**：VSCodeはElectronベースのデスクトップアプリケーションであり、レンダラープロセスやメインプロセスで動作するコードは、実際のElectronランタイム環境でテストする必要があります。Electron固有のAPI（BrowserWindow、IPC通信、ネイティブモジュールなど）を使用するコードの動作を検証するため、このバッチではElectronプロセス内でテストを実行します。これにより、実際のアプリケーション環境に近い状態での品質検証が可能になります。

**バッチの実行タイミング**：開発時の手動実行、およびCI/CDパイプライン（GitHub Actions）でのプルリクエスト検証時に自動実行されます。

**主要な処理内容**：
1. Electronバイナリのダウンロード・準備（未存在時）
2. product.jsonから製品名を取得
3. クラッシュレポーターディレクトリの設定
4. Electronプロセスの起動
5. test/unit/electron/index.jsによるテストの実行
6. IPC経由でのテスト結果収集

**前後の処理との関連**：事前にTypeScriptコンパイル（compile/watch）が完了し、`npm install`によりElectronがインストールされている必要があります。このバッチはtest-browserやtest-nodeと並行して実行可能であり、Electron固有のコードをカバーします。

**影響範囲**：`out`または`out-build`ディレクトリ配下のテストファイルが対象。特にElectronメインプロセス、レンダラープロセス、ユーティリティプロセス向けのテストを実行します。

## バッチ種別

テスト実行 / ユニットテスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時手動）/ PR作成時（CI自動） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions（PR作成・更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 22.x以上がインストールされていること |
| npm依存関係 | `npm install`が完了していること |
| コンパイル完了 | TypeScriptコンパイル（`npm run compile`または`npm run watch`）が完了していること |
| Electronバイナリ | .build/electronディレクトリにElectronが存在すること（スクリプトが自動ダウンロード） |

### 実行可否判定

product.jsonが存在し、Electronバイナリが存在または自動ダウンロード可能な場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --grep, -g, -f | string | No | - | 指定パターンにマッチするテストのみ実行 |
| --run | string | No | - | 特定のテストファイルのみを実行 |
| --runGlob | string | No | - | 実行するテストファイルのglobパターン |
| --build | boolean | No | false | `out-build`ディレクトリからテストを実行 |
| --dev | boolean | No | false | DevToolsを開いてデバッグモードで実行 |
| --reporter | string | No | spec | Mochaレポーター |
| --reporter-options | string | No | - | レポーターオプション |
| --timeout | string | No | - | テストタイムアウト（ミリ秒） |
| --crash-reporter-directory | string | No | .build/crashes | クラッシュダンプの保存先 |
| --tfs | string | No | - | TFSレポート用の設定 |
| --coverage | boolean | No | false | カバレッジレポートを生成 |
| --testSplit | string | No | - | テストを分割実行（i/n形式） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| out/test/unit/electron/index.js | JavaScript | テストエントリーポイント |
| product.json | JSON | 製品設定情報（nameShort, nameLong, applicationName） |
| .build/electron/ | Directory | Electronバイナリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト実行結果（Mochaレポート） |
| 標準エラー出力 | テキスト | エラー情報 |
| JUnit XMLファイル | XML | CI環境でのテスト結果レポート（--tfs指定時） |
| .build/crashes/ | ファイル | クラッシュダンプ（異常終了時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `test-results/{platform}-{arch}-{tfs}-results.xml` |
| 出力先 | `BUILD_ARTIFACTSTAGINGDIRECTORY`または`GITHUB_WORKSPACE` |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（XML形式） |

## 処理フロー

### 処理シーケンス

```
1. 環境検出
   └─ OS種別の判定（darwin/linux/windows）
   └─ プロジェクトルートパスの解決
2. 製品情報取得
   └─ product.jsonからnameLong/applicationName取得
   └─ Electronバイナリパスの構築
3. npm依存関係確認
   └─ node_modulesの存在確認
   └─ 未存在時はnpm install実行
4. Electronダウンロード
   └─ npm run electronによるバイナリ準備
5. 環境変数設定
   └─ ELECTRON_ENABLE_LOGGING=1
   └─ クラッシュレポーターディレクトリ設定
6. テスト実行
   └─ Electronプロセス起動
   └─ test/unit/electron/index.js読み込み
   └─ BrowserWindowでのテスト実行
7. 結果収集
   └─ IPC経由でのテスト結果受信
   └─ レポーターによる出力
8. 終了コード処理
   └─ Electron特有の終了コード255→0変換（Windows）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[OS種別判定]
    B --> C[製品情報取得]
    C --> D{node_modules存在?}
    D -->|No| E[npm install実行]
    D -->|Yes| F[Electronダウンロード確認]
    E --> F
    F --> G[環境変数設定]
    G --> H[Electronプロセス起動]
    H --> I[テスト実行]
    I --> J[IPC経由結果収集]
    J --> K{レンダラークラッシュ?}
    K -->|Yes| L[エラー終了]
    K -->|No| M{テスト失敗?}
    M -->|Yes| N[終了コード1]
    M -->|No| O[終了コード0]
    L --> P[バッチ終了]
    N --> P
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | テスト失敗 | テストアサーション失敗 | テストコードまたは対象コードを修正 |
| 1 | Electron起動エラー | Electronバイナリが見つからない | npm run electron を実行 |
| 1 | レンダラークラッシュ | テスト中にレンダラープロセスがクラッシュ | クラッシュダンプを確認 |
| 255 | Electron終了 | app.exit(0)がElectron 1.7.4で255を返す | スクリプトが0に変換（Windows） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（デフォルト） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `--dev`オプションを付けて実行し、DevToolsでデバッグ
2. クラッシュダンプ（.build/crashes/）を確認
3. 特定のテストのみを`--run`で再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース非使用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千テストケース |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | Electronプロセス合計で2GB程度 |

## 排他制御

同一マシン上での複数インスタンス実行は可能。ただし、ユーザーデータディレクトリは実行ごとに一時ディレクトリを使用することで競合を回避（`--dev`モード以外）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 暗黙的 |
| 進捗ログ | 各テスト実行時 | テスト名、結果（pass/fail/pending） |
| 終了ログ | バッチ終了時 | 総テスト数、成功数、失敗数、スキップ数、実行時間 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |
| コンソールログ | ELECTRON_ENABLE_LOGGING=1 | Electron内部のログメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗率 | 0% | GitHub Actions（PRステータス） |
| レンダラークラッシュ | 0回 | クラッシュダンプ生成 |

## 備考

- macOSでは`ulimit -n 4096`でファイルディスクリプタ上限を増加させています
- Windows版では、Electron 1.7.4の既知の問題（Issue #28582）により、app.exit(0)が終了コード255を返すため、スクリプトが0に変換しています
- `--dev`モードでは、ユーザーデータディレクトリが永続化され、DevToolsが開いた状態でテストが実行されます
- クラッシュレポーターは`crashReporter.start()`で初期化され、クラッシュダンプは指定されたディレクトリに保存されます
- per-test-coverageオプションを使用すると、テストごとのV8カバレッジレポートが生成されます
