# バッチ設計書 34-test-integration.sh/test-integration.bat

## 概要

本ドキュメントは、VSCodeプロジェクトにおける拡張機能統合テスト実行バッチ「test-integration.sh/test-integration.bat」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeの拡張機能に対する統合テストを、実際のVSCode環境（Electron）内で実行します。拡張機能のAPI呼び出し、ワークスペース操作、言語機能などを検証するE2E（End-to-End）テストを包括的に実行します。

**業務上の目的・背景**：VSCodeは拡張機能によって機能を拡張できるアーキテクチャを持っており、拡張機能APIの動作を検証することは品質保証の重要な要素です。このバッチでは、実際のVSCode環境内で拡張機能をロードし、APIテスト、言語機能テスト（TypeScript、Markdown、Emmet等）、Git統合テストなどを実行します。これにより、拡張機能と本体の統合が正しく動作することを保証します。

**バッチの実行タイミング**：開発時の手動実行、およびCI/CDパイプライン（GitHub Actions）でのプルリクエスト検証時に自動実行されます。

**主要な処理内容**：
1. 一時ディレクトリの作成（ユーザーデータ、ログ用）
2. Node.js統合テストの実行（.integrationTest.jsファイル）
3. VSCode API統合テスト（フォルダ・ワークスペース）
4. 各拡張機能の統合テスト（Colorize、TypeScript、Markdown、Emmet、Git等）
5. 言語サーバーのスタンドアロンテスト（CSS、HTML）
6. 一時ディレクトリのクリーンアップ

**前後の処理との関連**：事前にTypeScriptコンパイル（compile/watch）と拡張機能のビルドが完了している必要があります。test.sh/test.batによるユニットテストの後に実行されることが多いです。

**影響範囲**：extensions配下の各拡張機能テストコード、およびVSCode APIの動作全般に影響します。

## バッチ種別

テスト実行 / 統合テスト / E2Eテスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時手動）/ PR作成時（CI自動） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions（PR作成・更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 22.x以上がインストールされていること |
| npm依存関係 | `npm install`が完了していること |
| コンパイル完了 | TypeScriptコンパイル（`npm run compile`または`npm run watch`）が完了していること |
| 拡張機能ビルド | 各拡張機能のビルド（outディレクトリ）が完了していること |
| VSCodeバイナリ | ソースからの実行、またはビルド済みバイナリ（INTEGRATION_TEST_ELECTRON_PATH） |

### 実行可否判定

scripts/code.shまたはINTEGRATION_TEST_ELECTRON_PATHで指定されたVSCodeバイナリが存在し、拡張機能テストコードがビルド済みの場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| INTEGRATION_TEST_ELECTRON_PATH | 環境変数 | No | ./scripts/code.sh | テスト実行に使用するVSCodeパス |
| INTEGRATION_TEST_APP_NAME | 環境変数 | No | - | テスト後にkillするアプリ名 |
| その他 | - | No | - | test.shに渡されるオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| extensions/vscode-api-tests/ | Directory | VSCode API統合テスト |
| extensions/vscode-colorize-tests/ | Directory | カラライズテスト |
| extensions/typescript-language-features/ | Directory | TypeScript言語機能テスト |
| extensions/markdown-language-features/ | Directory | Markdown言語機能テスト |
| extensions/emmet/ | Directory | Emmetテスト |
| extensions/git/ | Directory | Git統合テスト |
| extensions/git-base/ | Directory | Git基本機能テスト |
| extensions/ipynb/ | Directory | Jupyter Notebookテスト |
| extensions/notebook-renderers/ | Directory | Notebookレンダラーテスト |
| extensions/configuration-editing/ | Directory | 設定編集テスト |
| extensions/github-authentication/ | Directory | GitHub認証テスト |
| extensions/css-language-features/server/ | Directory | CSS言語サーバーテスト |
| extensions/html-language-features/server/ | Directory | HTML言語サーバーテスト |
| extensions/terminal-suggest/ | Directory | ターミナルサジェストテスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト実行結果 |
| 標準エラー出力 | テキスト | エラー情報 |
| .build/crashes/ | ファイル | クラッシュダンプ |
| .build/logs/integration-tests/ | Directory | テストログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種ログファイル |
| 出力先 | .build/logs/integration-tests/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境セットアップ
   └─ 一時ディレクトリ作成（VSCODEUSERDATADIR）
   └─ クラッシュレポートディレクトリ設定
   └─ ログディレクトリ設定
2. VSCodeパス決定
   └─ INTEGRATION_TEST_ELECTRON_PATH確認
   └─ 未設定時はscripts/code.sh使用
3. Node.js統合テスト
   └─ test.sh --runGlob **/*.integrationTest.js
4. API統合テスト（フォルダ）
   └─ vscode-api-tests/testWorkspace
   └─ singlefolder-tests実行
5. API統合テスト（ワークスペース）
   └─ vscode-api-tests/testworkspace.code-workspace
   └─ workspace-tests実行
6. 拡張機能テスト実行
   └─ Colorizeテスト
   └─ Terminal Suggestテスト
   └─ TypeScriptテスト
   └─ Markdownテスト
   └─ Emmetテスト
   └─ Gitテスト
   └─ Git Baseテスト
   └─ Ipynbテスト
   └─ Notebook Outputテスト
   └─ Configuration editingテスト
   └─ GitHub Authenticationテスト
7. スタンドアロンテスト
   └─ CSS言語サーバーテスト
   └─ HTML言語サーバーテスト
8. クリーンアップ
   └─ 一時ディレクトリ削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境セットアップ]
    B --> C[VSCodeパス決定]
    C --> D[Node.js統合テスト]
    D --> E[API統合テスト - フォルダ]
    E --> F[API統合テスト - ワークスペース]
    F --> G[拡張機能テストループ]
    G --> H[Colorizeテスト]
    H --> I[TypeScriptテスト]
    I --> J[Markdownテスト]
    J --> K[Emmetテスト]
    K --> L[Gitテスト]
    L --> M[その他拡張機能テスト]
    M --> N[CSS/HTML言語サーバーテスト]
    N --> O[クリーンアップ]
    O --> P{エラー発生?}
    P -->|Yes| Q[エラーコードで終了]
    P -->|No| R[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | テスト失敗 | いずれかのテストが失敗 | 失敗したテストを個別に確認・修正 |
| 非0 | VSCode起動エラー | バイナリが見つからない | INTEGRATION_TEST_ELECTRON_PATHを確認 |
| 非0 | 拡張機能ロードエラー | 拡張機能のビルドが未完了 | 拡張機能を再ビルド |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（デフォルト） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 失敗したテストスイートを特定してログを確認
2. .build/logs/integration-tests/のログを確認
3. 個別の拡張機能テストを手動で実行してデバッグ

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース非使用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百テストケース |
| 目標処理時間 | 15分以内 |
| メモリ使用量上限 | VSCodeプロセスごとに2GB程度 |

## 排他制御

各テストスイート間でVSCodeプロセスを再起動するため、テスト間の状態干渉は発生しません。INTEGRATION_TEST_APP_NAMEが設定されている場合、各テスト後にアプリをkillします。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各テストスイート開始時 | テストスイート名（### で区切り） |
| 進捗ログ | 各テスト実行時 | テスト結果 |
| 終了ログ | 各テストスイート終了時 | 成功/失敗 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗率 | 0% | GitHub Actions（PRステータス） |
| 実行時間 | 30分 | CI/CDパイプライン |

## 備考

- `API_TESTS_EXTRA_ARGS`には以下のオプションが含まれます：
  - `--disable-telemetry`: テレメトリ無効化
  - `--disable-experiments`: 実験機能無効化
  - `--skip-welcome`: ウェルカムページスキップ
  - `--skip-release-notes`: リリースノートスキップ
  - `--no-cached-data`: キャッシュデータ無効化
  - `--disable-updates`: 自動更新無効化
  - `--use-inmemory-secretstorage`: インメモリシークレットストレージ使用
  - `--disable-extensions`: 他の拡張機能無効化（テスト対象のみ有効化）
  - `--disable-workspace-trust`: ワークスペース信頼無効化
- kill_app関数は、テスト間でVSCodeプロセスが残らないようにするために使用されます
- CSS/HTML言語サーバーテストはCommonJS形式のスタンドアロンテストとして実行されます
