# バッチ設計書 35-test-remote-integration.sh/test-remote-integration.bat

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるリモート開発機能向け統合テスト実行バッチ「test-remote-integration.sh/test-remote-integration.bat」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeのリモート開発機能（Remote Development）に対する統合テストを実行します。vscode-remote://プロトコルを使用してリモートサーバー上でテストを実行し、ローカルとリモート間の通信、ファイルシステム操作、拡張機能のリモート実行などを検証します。

**業務上の目的・背景**：VSCodeはRemote - SSH、Remote - Containers、WSL等のリモート開発機能を提供しており、これらの機能ではクライアント（UI）とサーバー（拡張機能ホスト）が分離されて動作します。このバッチでは、テストリゾルバー（vscode-test-resolver）を使用して疑似的なリモート環境を構築し、リモート開発機能が正しく動作することを検証します。これにより、ネットワーク越しのファイル操作や拡張機能実行の品質を保証します。

**バッチの実行タイミング**：開発時の手動実行、およびCI/CDパイプライン（GitHub Actions）でのプルリクエスト検証時に自動実行されます。

**主要な処理内容**：
1. 一時ディレクトリの作成（ユーザーデータ、ログ、テストリゾルバーデータ用）
2. リモートサーバー用Node.jsのダウンロード（必要時）
3. REMOTE_VSCODE環境変数によるリモートパス設定
4. vscode-remote://プロトコルを使用したAPIテスト実行
5. 各拡張機能のリモート統合テスト
6. 一時ディレクトリのクリーンアップ

**前後の処理との関連**：事前にTypeScriptコンパイルと拡張機能のビルドが完了している必要があります。test-integration.shによるローカル統合テストの後に実行されることが多いです。

**影響範囲**：VSCodeのリモート開発機能全般、拡張機能のリモート実行、ファイルシステムプロバイダーの動作に影響します。

## バッチ種別

テスト実行 / 統合テスト / リモート開発テスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時手動）/ PR作成時（CI自動） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions（PR作成・更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 22.x以上がインストールされていること |
| npm依存関係 | `npm install`が完了していること |
| コンパイル完了 | TypeScriptコンパイル（`npm run compile`または`npm run watch`）が完了していること |
| 拡張機能ビルド | 各拡張機能のビルド（outディレクトリ）が完了していること |
| リモートサーバーNode.js | gulp nodeタスクでダウンロード済み、またはVSCODE_REMOTE_SERVER_PATHで指定 |

### 実行可否判定

scripts/code.shまたはINTEGRATION_TEST_ELECTRON_PATHで指定されたVSCodeバイナリが存在し、リモートサーバー用のNode.jsが準備されている場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (AUTHORITY) | 位置引数 | No | vscode-remote://test+test | リモートAuthority |
| $2 (EXT_PATH) | 位置引数 | No | $ROOT/extensions | 拡張機能パス |
| $3 (VSCODEUSERDATADIR) | 位置引数 | No | 一時ディレクトリ | ユーザーデータディレクトリ |
| INTEGRATION_TEST_ELECTRON_PATH | 環境変数 | No | ./scripts/code.sh | テスト実行に使用するVSCodeパス |
| VSCODE_REMOTE_SERVER_PATH | 環境変数 | No | - | リモートサーバーのパス |
| INTEGRATION_TEST_APP_NAME | 環境変数 | No | - | テスト後にkillするアプリ名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| extensions/vscode-api-tests/ | Directory | VSCode API統合テスト |
| extensions/typescript-language-features/ | Directory | TypeScript言語機能テスト |
| extensions/markdown-language-features/ | Directory | Markdown言語機能テスト |
| extensions/emmet/ | Directory | Emmetテスト |
| extensions/git/ | Directory | Git統合テスト |
| extensions/ipynb/ | Directory | Jupyter Notebookテスト |
| extensions/configuration-editing/ | Directory | 設定編集テスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト実行結果 |
| 標準エラー出力 | テキスト | エラー情報 |
| .build/crashes/ | ファイル | クラッシュダンプ |
| .build/logs/integration-tests-remote/ | Directory | テストログ |
| .build/logs/integration-tests-remote/server/ | Directory | サーバーログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種ログファイル |
| 出力先 | .build/logs/integration-tests-remote/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境セットアップ
   └─ 一時ディレクトリ作成（VSCODEUSERDATADIR）
   └─ クラッシュレポートディレクトリ設定
   └─ テストリゾルバーデータディレクトリ作成
2. リモート環境設定
   └─ AUTHORITY設定（vscode-remote://test+test）
   └─ REMOTE_VSCODE環境変数設定
   └─ TESTRESOLVER_DATA_FOLDER設定
   └─ TESTRESOLVER_LOGS_FOLDER設定
3. リモートサーバー準備
   └─ gulp nodeでNode.jsダウンロード（ソースから実行時）
   └─ または VSCODE_REMOTE_SERVER_PATH使用
4. API統合テスト（フォルダ）
   └─ --folder-uriでリモートフォルダ指定
   └─ singlefolder-tests実行
5. API統合テスト（ワークスペース）
   └─ --file-uriでリモートワークスペース指定
   └─ workspace-tests実行
6. 拡張機能テスト実行
   └─ TypeScriptテスト
   └─ Markdownテスト
   └─ Emmetテスト
   └─ Gitテスト
   └─ Ipynbテスト
   └─ Configuration editingテスト
7. クリーンアップ
   └─ 一時ディレクトリ削除
   └─ テストリゾルバーデータ削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境セットアップ]
    B --> C{引数指定あり?}
    C -->|Yes| D[引数からAUTHORITY/EXT_PATH設定]
    C -->|No| E[デフォルト値設定]
    D --> F[リモートサーバー準備]
    E --> F
    F --> G{VSCODE_REMOTE_SERVER_PATH指定?}
    G -->|Yes| H[指定パス使用]
    G -->|No| I[gulp nodeでダウンロード]
    H --> J[API統合テスト - フォルダ]
    I --> J
    J --> K[API統合テスト - ワークスペース]
    K --> L[拡張機能テストループ]
    L --> M[TypeScript/Markdown/Emmetテスト]
    M --> N[Git/Ipynb/Configテスト]
    N --> O[クリーンアップ]
    O --> P{エラー発生?}
    P -->|Yes| Q[エラーコードで終了]
    P -->|No| R[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | テスト失敗 | いずれかのテストが失敗 | 失敗したテストを個別に確認・修正 |
| 非0 | サーバー起動エラー | リモートサーバーが起動できない | VSCODE_REMOTE_SERVER_PATHを確認 |
| 非0 | 接続エラー | クライアント-サーバー間の通信失敗 | ネットワーク設定、ポートを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（デフォルト） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. サーバーログ（.build/logs/integration-tests-remote/server/）を確認
2. テストリゾルバーの動作を確認
3. 個別の拡張機能テストを手動で実行してデバッグ

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース非使用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百テストケース |
| 目標処理時間 | 15分以内 |
| メモリ使用量上限 | クライアント・サーバー合計で4GB程度 |

## 排他制御

各テストスイート間でVSCodeプロセスを再起動するため、テスト間の状態干渉は発生しません。テストリゾルバーデータディレクトリは一意のパスを使用します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各テストスイート開始時 | テストスイート名（### で区切り） |
| 進捗ログ | 各テスト実行時 | テスト結果 |
| サーバーログ | サーバー動作中 | リモートサーバーのログ |
| 終了ログ | 各テストスイート終了時 | 成功/失敗 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗率 | 0% | GitHub Actions（PRステータス） |
| 実行時間 | 30分 | CI/CDパイプライン |

## 備考

- `vscode-remote://test+test`はテストリゾルバーが提供する疑似的なリモート環境を表します
- EXTRA_INTEGRATION_TEST_ARGUMENTSにはビルド版実行時に以下が追加されます：
  - `--extensions-dir=$EXT_PATH`: 拡張機能ディレクトリ
  - `--enable-proposed-api=vscode.vscode-test-resolver`: テストリゾルバーのProposed API有効化
  - `--enable-proposed-api=vscode.vscode-api-tests`: APIテストのProposed API有効化
- TESTRESOLVER_INSTALL_BUILTIN_EXTENSIONは、ビルド版実行時にスモークテストチェック拡張機能をインストールします
- リモートパスは`$REMOTE_VSCODE`環境変数で構築され、`$AUTHORITY$EXT_PATH`形式になります
- `--folder-uri`と`--file-uri`オプションでリモートURIを直接指定します
