# バッチ設計書 36-test-web-integration.sh/test-web-integration.bat

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるWeb版（vscode.dev）向け統合テスト実行バッチ「test-web-integration.sh/test-web-integration.bat」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeのWeb版（ブラウザ版）に対する統合テストを、Playwrightを使用してブラウザ上で実行します。vscode.devと同様のWeb環境で拡張機能のテストを実行し、Web固有の制約（ファイルシステムアクセス、Node.js API非使用など）の下での動作を検証します。

**業務上の目的・背景**：VSCodeはvscode.devとしてWebブラウザでも動作するバージョンを提供しています。Web版ではNode.js APIが使用できず、ファイルシステムアクセスも制限されるため、この環境固有のテストが必要です。このバッチでは、test/integration/browser/を使用してWeb環境での拡張機能の動作を検証し、vscode.devの品質を保証します。

**バッチの実行タイミング**：開発時の手動実行、およびCI/CDパイプライン（GitHub Actions）でのプルリクエスト検証時に自動実行されます。

**主要な処理内容**：
1. テスト用コードのコンパイル（未コンパイル時）
2. Playwrightのインストール（未インストール時）
3. Node.jsサーバーの起動
4. Playwright経由でのブラウザテスト実行
5. 各拡張機能のWeb統合テスト

**前後の処理との関連**：事前にTypeScriptコンパイルと拡張機能のビルドが完了している必要があります。test-integration.shおよびtest-remote-integration.shの後に実行されることが多いです。

**影響範囲**：VSCodeのWeb版全般、Web対応拡張機能の動作、ブラウザAPIの使用に影響します。

## バッチ種別

テスト実行 / 統合テスト / Web統合テスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時手動）/ PR作成時（CI自動） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / GitHub Actions（PR作成・更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 22.x以上がインストールされていること |
| npm依存関係 | `npm install`が完了していること |
| コンパイル完了 | TypeScriptコンパイル（`npm run compile`または`npm run watch`）が完了していること |
| 拡張機能ビルド | 各拡張機能のビルド（outディレクトリ）が完了していること |
| Playwright | `npm run playwright-install`が完了していること（スクリプトが自動実行） |

### 実行可否判定

test/integration/browser/out/index.jsが存在し、Playwrightがインストールされている場合に実行可能。未存在時はスクリプトが自動でコンパイルとインストールを実行します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (AUTHORITY) | 位置引数 | No | vscode-remote://test+test/ | リモートAuthority（Windows版のみ） |
| $2 (EXT_PATH) | 位置引数 | No | $ROOT/extensions | 拡張機能パス（Windows版のみ） |
| VSCODE_REMOTE_SERVER_PATH | 環境変数 | No | - | リモートサーバーのパス |
| その他 | - | No | - | test/integration/browser/out/index.jsに渡されるオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/integration/browser/out/index.js | JavaScript | Webテストランナー |
| extensions/vscode-api-tests/ | Directory | VSCode API統合テスト |
| extensions/typescript-language-features/ | Directory | TypeScript言語機能テスト |
| extensions/markdown-language-features/ | Directory | Markdown言語機能テスト |
| extensions/emmet/ | Directory | Emmetテスト |
| extensions/git/ | Directory | Git統合テスト |
| extensions/ipynb/ | Directory | Jupyter Notebookテスト |
| extensions/configuration-editing/ | Directory | 設定編集テスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト実行結果 |
| 標準エラー出力 | テキスト | エラー情報 |

### 出力ファイル仕様

本バッチはログファイルをファイルシステムに出力しません（標準出力のみ）。

## 処理フロー

### 処理シーケンス

```
1. 環境確認
   └─ test/integration/browser/out/index.jsの存在確認
2. 前提条件準備（必要時）
   └─ test/integration/browserのコンパイル
   └─ Playwrightのインストール
3. サーバー準備
   └─ VSCODE_REMOTE_SERVER_PATH確認
   └─ ソースからの実行時はgulp nodeでダウンロード
4. API統合テスト（フォルダ）
   └─ --workspacePathでワークスペース指定
   └─ singlefolder-tests実行
5. API統合テスト（ワークスペース）
   └─ --workspacePathでワークスペースファイル指定
   └─ workspace-tests実行
6. 拡張機能テスト実行
   └─ TypeScriptテスト
   └─ Markdownテスト
   └─ Emmetテスト
   └─ Gitテスト（一時ディレクトリ作成）
   └─ Ipynbテスト（一時ディレクトリ作成）
   └─ Configuration editingテスト（一時ディレクトリ作成）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{index.js存在?}
    B -->|No| C[test/integration/browserをコンパイル]
    B -->|Yes| D[Playwrightインストール確認]
    C --> D
    D --> E{VSCODE_REMOTE_SERVER_PATH指定?}
    E -->|Yes| F[指定パス使用]
    E -->|No| G[gulp nodeでダウンロード]
    F --> H[API統合テスト - フォルダ]
    G --> H
    H --> I[API統合テスト - ワークスペース]
    I --> J[TypeScriptテスト]
    J --> K[Markdownテスト]
    K --> L[Emmetテスト]
    L --> M[Gitテスト]
    M --> N[Ipynbテスト]
    N --> O[Configテスト]
    O --> P{エラー発生?}
    P -->|Yes| Q[エラーコードで終了]
    P -->|No| R[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | テスト失敗 | いずれかのテストが失敗 | 失敗したテストを個別に確認・修正 |
| 非0 | ブラウザ起動エラー | Playwrightがブラウザを起動できない | Playwrightを再インストール |
| 非0 | コンパイルエラー | テストコードのコンパイル失敗 | コンパイルエラーを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（デフォルト） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. test/integration/browser/のコンパイル状態を確認
2. Playwrightの再インストール
3. 個別の拡張機能テストを手動で実行してデバッグ

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース非使用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百テストケース |
| 目標処理時間 | 10分以内 |
| メモリ使用量上限 | ブラウザプロセスごとに1GB程度 |

## 排他制御

同一マシン上での複数インスタンス実行は可能。Git/Ipynb/Configテストでは一時ディレクトリを作成して競合を回避します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各テストスイート開始時 | テストスイート名（### で区切り） |
| 進捗ログ | 各テスト実行時 | テスト結果 |
| 終了ログ | 各テストスイート終了時 | 成功/失敗 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗率 | 0% | GitHub Actions（PRステータス） |
| 実行時間 | 20分 | CI/CDパイプライン |

## 備考

- test/integration/browser/out/index.jsは専用のWeb統合テストランナーです
- テストはPlaywrightを使用してChromium上で実行されます
- `--workspacePath`オプションでローカルファイルシステムのパスを指定しますが、Web版VSCodeではこれがサーバー経由でアクセスされます
- Git/Ipynb/Configuration editingテストでは一時ディレクトリを作成してワークスペースとして使用します
- Windows版では一時ディレクトリの作成にNode.jsの`os.tmpdir()`を使用します
- このバッチはtest-integration.shと同じ拡張機能をテストしますが、Web環境固有の制約の下で実行されます
- Web版ではNode.js APIが使用できないため、一部のテストはスキップまたは異なる動作をする可能性があります
