# バッチ設計書 37-upload-sourcemaps.ts

## 概要

本ドキュメントは、VSCodeプロジェクトにおけるソースマップアップロードバッチ「upload-sourcemaps.ts」の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、VSCodeのビルド成果物に含まれるソースマップ（.mapファイル）をAzure Blob Storageにアップロードします。ソースマップは本番環境でのエラー発生時にスタックトレースを元のTypeScriptコードにマッピングするために使用されます。

**業務上の目的・背景**：VSCodeは難読化（minification/mangling）されたJavaScriptコードとしてリリースされます。本番環境でエラーが発生した場合、スタックトレースは難読化されたコードを参照するため、デバッグが困難になります。ソースマップをサーバーにアップロードすることで、エラー発生時にソースマップを使用して元のTypeScriptコードの行番号・関数名を復元でき、効率的なデバッグとバグ修正が可能になります。

**バッチの実行タイミング**：Azure Pipelinesによる製品ビルドパイプラインの一部として、ビルド完了後に自動実行されます。

**主要な処理内容**：
1. VSCodeクライアントのソースマップ収集（out-vscode-min）
2. 本番依存パッケージのソースマップ収集（node_modules）
3. 拡張機能のソースマップ収集（.build/extensions）
4. Azure Blob Storageへのアップロード（sourcemaps/{commit}/配下）

**前後の処理との関連**：事前にproduct-buildパイプラインによるビルド（compile-build-with-mangling）が完了している必要があります。このバッチの後にupload-nlsmetadata.ts、upload-cdn.tsが実行されます。

**影響範囲**：Azure Blob Storage上のソースマップファイル。Application Insightsやエラー追跡システムからの参照に影響します。

## バッチ種別

ビルドスクリプト / デプロイ / アセットアップロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルドごと（製品ビルド時） |
| 実行時刻 | ビルドパイプライン依存 |
| 実行曜日 | ビルドパイプライン依存 |
| 実行日 | ビルドパイプライン依存 |
| トリガー | Azure Pipelines（product-build完了後） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | compile-build-with-manglingタスクが完了していること |
| 環境変数 | BUILD_SOURCEVERSION（コミットハッシュ）が設定されていること |
| Azure認証 | AZURE_TENANT_ID、AZURE_CLIENT_ID、AZURE_ID_TOKENが設定されていること |
| Azureストレージ | AZURE_STORAGE_ACCOUNTが設定されていること |

### 実行可否判定

必要な環境変数が全て設定され、out-vscode-minディレクトリにソースマップが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| base | 位置引数 | No | - | カスタムベースディレクトリ |
| maps | 位置引数 | No | `${base}/**/*.map` | カスタムソースマップパターン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| out-vscode-min/**/*.map | JavaScript Source Map | クライアントソースマップ |
| node_modules/**/*.map | JavaScript Source Map | 依存パッケージのソースマップ |
| .build/extensions/**/*.js.map | JavaScript Source Map | 拡張機能のソースマップ |
| build/.moduleignore | Text | 除外するnode_modulesパターン |
| build/.moduleignore.{platform} | Text | プラットフォーム固有の除外パターン |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Azure Blob Storage | .map ファイル | ソースマップファイル |
| 標準出力 | テキスト | アップロード進捗ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| コンテナ名 | $web |
| プレフィックス | sourcemaps/{commit}/ |
| ファイルパス | core/{相対パス} |
| 文字コード | UTF-8 |

## 処理フロー

### 処理シーケンス

```
1. 環境変数取得
   └─ BUILD_SOURCEVERSION（コミットハッシュ）
   └─ Azure認証情報
2. 認証情報作成
   └─ ClientAssertionCredentialの初期化
3. ソースマップ収集
   └─ カスタム指定がない場合：
      └─ out-vscode-minからクライアントソースマップ
      └─ 本番依存パッケージのソースマップ
      └─ .build/extensionsから拡張機能ソースマップ
   └─ カスタム指定がある場合：
      └─ 指定されたbase/mapsからソースマップ
4. パス変換
   └─ 相対パスに "core/" プレフィックスを付加
5. フィルタリング
   └─ .moduleignoreに基づく除外
6. アップロード
   └─ gulp-azure-storageを使用
   └─ $webコンテナ、sourcemaps/{commit}/配下
7. 完了処理
   └─ エラー時はprocess.exit(1)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数取得]
    B --> C[Azure認証]
    C --> D{カスタム引数?}
    D -->|No| E[デフォルトソース収集]
    D -->|Yes| F[カスタムソース収集]
    E --> G[クライアントソースマップ]
    G --> H[node_modulesソースマップ]
    H --> I[拡張機能ソースマップ]
    I --> J[ソースマージ]
    F --> J
    J --> K[パス変換]
    K --> L[.moduleignoreフィルタ]
    L --> M[Azure Blobアップロード]
    M --> N{エラー発生?}
    N -->|Yes| O[exit 1]
    N -->|No| P[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 認証エラー | Azure認証情報が無効 | AZURE_TENANT_ID、AZURE_CLIENT_ID、AZURE_ID_TOKENを確認 |
| 1 | アップロードエラー | Azure Blob Storageへの接続失敗 | ネットワーク設定、ストレージアカウントを確認 |
| 1 | ファイル読み込みエラー | ソースマップファイルが存在しない | ビルドが正常に完了しているか確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | gulp-azure-storageの内部リトライ |
| リトライ間隔 | ライブラリ依存 |
| リトライ対象エラー | 一時的なネットワークエラー |

### 障害時対応

1. Azure認証情報を確認
2. ビルド成果物の存在を確認
3. Azure Blob Storageの接続設定を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルアップロード） |
| コミットタイミング | 各ファイルごとに完了 |
| ロールバック条件 | N/A（冪等性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千ファイル |
| 目標処理時間 | 10分以内 |
| メモリ使用量上限 | 2GB程度 |

## 排他制御

コミットハッシュをプレフィックスとして使用するため、異なるビルド間での競合は発生しません。同一コミットの再実行は上書きとなります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ファイルアップロード時 | "Uploading Sourcemap {相対パス}" |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| アップロード失敗 | 0件 | Azure Pipelinesパイプラインステータス |
| 実行時間 | 30分 | パイプラインタイムアウト |

## 備考

- ClientAssertionCredentialを使用してAzure ADトークンベースの認証を行います
- アップロード先は`$web`コンテナで、静的Webサイトホスティング用のコンテナです
- ソースマップは`sourcemaps/{commit}/core/`配下に格納され、commit hashで一意に識別されます
- node_modulesのソースマップは`.moduleignore`ファイルに基づいてフィルタリングされます
- カスタムのbase/mapsパラメータを指定することで、特定のディレクトリのみをアップロードできます
- このスクリプトはevent-stream、vinyl-fs、gulp-azure-storageを使用したGulpスタイルのストリーム処理を行います
